# -*- coding: utf-8 -*-
#
# Copyright (C) 2015 GNS3 Technologies Inc.
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

import ipaddress


def getNetworkUrl(protocol, host, port, user=None, settings={}):
    """
    Return a network url from settings

    :param protocol: server protocol (http/https)
    :param host: host address
    :param port: port
    :param user: the username
    :param settings: Additional settings
    """

    # 64 character autogenerated user name, we hide it, it's more user friendly
    if user and len(user) != 64:

        try:
            ipaddress.IPv6Address(host.rsplit('%', 1)[0])  # remove any scope ID
            # this is an IPv6 address, we must surround it with brackets to be used in URLs (RFC2732)
            host = "[{}]".format(host)
        except ipaddress.AddressValueError:
            pass

        return "{protocol}://{user}@{host}:{port}".format(protocol=protocol, user=user, host=host, port=port)
    return "{protocol}://{host}:{port}".format(protocol=protocol, host=host, port=port)
