/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.query;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.BooleanSupplier;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MultiCollector;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Weight;
import org.elasticsearch.common.lucene.MinimumScoreCollector;
import org.elasticsearch.common.lucene.search.FilteredCollector;
import org.elasticsearch.search.profile.query.InternalProfileCollector;
import org.elasticsearch.search.query.CancellableCollector;
import org.elasticsearch.search.query.EarlyTerminatingCollector;
import org.elasticsearch.search.query.QuerySearchResult;

abstract class QueryCollectorContext {
    private String profilerName;

    QueryCollectorContext(String profilerName) {
        this.profilerName = profilerName;
    }

    abstract Collector create(Collector var1) throws IOException;

    protected InternalProfileCollector createWithProfiler(InternalProfileCollector in) throws IOException {
        Collector collector = this.create(in);
        return new InternalProfileCollector(collector, this.profilerName, in != null ? Collections.singletonList(in) : Collections.emptyList());
    }

    void postProcess(QuerySearchResult result) throws IOException {
    }

    static Collector createQueryCollector(List<QueryCollectorContext> collectors) throws IOException {
        Collector collector = null;
        for (QueryCollectorContext ctx : collectors) {
            collector = ctx.create(collector);
        }
        return collector;
    }

    static InternalProfileCollector createQueryCollectorWithProfiler(List<QueryCollectorContext> collectors) throws IOException {
        InternalProfileCollector collector = null;
        for (QueryCollectorContext ctx : collectors) {
            collector = ctx.createWithProfiler(collector);
        }
        return collector;
    }

    static QueryCollectorContext createMinScoreCollectorContext(final float minScore) {
        return new QueryCollectorContext("search_min_score"){

            @Override
            Collector create(Collector in) {
                return new MinimumScoreCollector(in, minScore);
            }
        };
    }

    static QueryCollectorContext createFilteredCollectorContext(final IndexSearcher searcher, final Query query) {
        return new QueryCollectorContext("search_post_filter"){

            @Override
            Collector create(Collector in) throws IOException {
                Weight filterWeight = searcher.createNormalizedWeight(query, false);
                return new FilteredCollector(in, filterWeight);
            }
        };
    }

    static QueryCollectorContext createMultiCollectorContext(final Collection<Collector> subs) {
        return new QueryCollectorContext("search_multi"){

            @Override
            Collector create(Collector in) throws IOException {
                ArrayList<Collector> subCollectors = new ArrayList<Collector>();
                subCollectors.add(in);
                subCollectors.addAll(subs);
                return MultiCollector.wrap(subCollectors);
            }

            @Override
            protected InternalProfileCollector createWithProfiler(InternalProfileCollector in) throws IOException {
                ArrayList<InternalProfileCollector> subCollectors = new ArrayList<InternalProfileCollector>();
                subCollectors.add(in);
                if (subs.stream().anyMatch(col -> !(col instanceof InternalProfileCollector))) {
                    throw new IllegalArgumentException("non-profiling collector");
                }
                for (Collector collector : subs) {
                    subCollectors.add((InternalProfileCollector)collector);
                }
                Collector collector = MultiCollector.wrap(subCollectors);
                return new InternalProfileCollector(collector, "search_multi", subCollectors);
            }
        };
    }

    static QueryCollectorContext createCancellableCollectorContext(final BooleanSupplier cancelled) {
        return new QueryCollectorContext("search_cancelled"){

            @Override
            Collector create(Collector in) throws IOException {
                return new CancellableCollector(cancelled, in);
            }
        };
    }

    static QueryCollectorContext createEarlyTerminationCollectorContext(final int numHits) {
        return new QueryCollectorContext("search_terminate_after_count"){
            private EarlyTerminatingCollector collector;

            @Override
            Collector create(Collector in) throws IOException {
                assert (this.collector == null);
                this.collector = new EarlyTerminatingCollector(in, numHits, true);
                return this.collector;
            }
        };
    }
}

