/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.indexlifecycle;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.action.support.ActiveShardCount;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.Index;
import org.elasticsearch.xpack.core.indexlifecycle.ClusterStateWaitStep;
import org.elasticsearch.xpack.core.indexlifecycle.Step;

public class ShrunkShardsAllocatedStep
extends ClusterStateWaitStep {
    public static final String NAME = "shrunk-shards-allocated";
    private String shrunkIndexPrefix;

    public ShrunkShardsAllocatedStep(Step.StepKey key, Step.StepKey nextStepKey, String shrunkIndexPrefix) {
        super(key, nextStepKey);
        this.shrunkIndexPrefix = shrunkIndexPrefix;
    }

    String getShrunkIndexPrefix() {
        return this.shrunkIndexPrefix;
    }

    @Override
    public ClusterStateWaitStep.Result isConditionMet(Index index, ClusterState clusterState) {
        boolean indexExists;
        boolean bl = indexExists = clusterState.metaData().index(this.shrunkIndexPrefix + index.getName()) != null;
        if (!indexExists) {
            return new ClusterStateWaitStep.Result(false, new Info(false, -1, false));
        }
        boolean allShardsActive = ActiveShardCount.ALL.enoughShardsActive(clusterState, new String[]{this.shrunkIndexPrefix + index.getName()});
        int numShrunkIndexShards = clusterState.metaData().index(this.shrunkIndexPrefix + index.getName()).getNumberOfShards();
        if (allShardsActive) {
            return new ClusterStateWaitStep.Result(true, null);
        }
        return new ClusterStateWaitStep.Result(false, new Info(true, numShrunkIndexShards, allShardsActive));
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.shrunkIndexPrefix);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ShrunkShardsAllocatedStep other = (ShrunkShardsAllocatedStep)obj;
        return super.equals(obj) && Objects.equals(this.shrunkIndexPrefix, other.shrunkIndexPrefix);
    }

    public static final class Info
    implements ToXContentObject {
        private final int actualShards;
        private final boolean shrunkIndexExists;
        private final boolean allShardsActive;
        private final String message;
        static final ParseField ACTUAL_SHARDS = new ParseField("actual_shards", new String[0]);
        static final ParseField SHRUNK_INDEX_EXISTS = new ParseField("shrunk_index_exists", new String[0]);
        static final ParseField ALL_SHARDS_ACTIVE = new ParseField("all_shards_active", new String[0]);
        static final ParseField MESSAGE = new ParseField("message", new String[0]);
        static final ConstructingObjectParser<Info, Void> PARSER = new ConstructingObjectParser("shrunk_shards_allocated_step_info", a -> new Info((Boolean)a[0], (Integer)a[1], (Boolean)a[2]));

        public Info(boolean shrunkIndexExists, int actualShards, boolean allShardsActive) {
            this.actualShards = actualShards;
            this.shrunkIndexExists = shrunkIndexExists;
            this.allShardsActive = allShardsActive;
            this.message = !shrunkIndexExists ? "Waiting for shrunk index to be created" : (!allShardsActive ? "Waiting for all shard copies to be active" : "");
        }

        public int getActualShards() {
            return this.actualShards;
        }

        public boolean shrunkIndexExists() {
            return this.shrunkIndexExists;
        }

        public boolean allShardsActive() {
            return this.allShardsActive;
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field(MESSAGE.getPreferredName(), this.message);
            builder.field(SHRUNK_INDEX_EXISTS.getPreferredName(), this.shrunkIndexExists);
            builder.field(ACTUAL_SHARDS.getPreferredName(), this.actualShards);
            builder.field(ALL_SHARDS_ACTIVE.getPreferredName(), this.allShardsActive);
            builder.endObject();
            return builder;
        }

        public int hashCode() {
            return Objects.hash(this.shrunkIndexExists, this.actualShards, this.allShardsActive);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Info other = (Info)obj;
            return Objects.equals(this.shrunkIndexExists, other.shrunkIndexExists) && Objects.equals(this.actualShards, other.actualShards) && Objects.equals(this.allShardsActive, other.allShardsActive);
        }

        public String toString() {
            return Strings.toString((ToXContent)this);
        }

        static {
            PARSER.declareBoolean(ConstructingObjectParser.constructorArg(), SHRUNK_INDEX_EXISTS);
            PARSER.declareInt(ConstructingObjectParser.constructorArg(), ACTUAL_SHARDS);
            PARSER.declareBoolean(ConstructingObjectParser.constructorArg(), ALL_SHARDS_ACTIVE);
            PARSER.declareString((i, s) -> {}, MESSAGE);
        }
    }
}

