/*
 * Decompiled with CFR 0.152.
 */
package org.diylc.swingframework.objecttable;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import org.apache.log4j.Logger;

public class ObjectListTableModel<T>
extends AbstractTableModel {
    private static final Logger LOG = Logger.getLogger(ObjectListTableModel.class);
    private static final long serialVersionUID = 1L;
    private List<T> data;
    private List<Method> fieldGetters = new ArrayList<Method>();
    private List<Method> fieldSetters = new ArrayList<Method>();
    private List<Class<?>> fieldTypes = new ArrayList();
    private List<String> fieldNames = new ArrayList<String>();
    private List<Integer> actionColumns = new ArrayList<Integer>();

    public ObjectListTableModel(Class<? extends T> dataClass, String[] fields) throws SecurityException, NoSuchMethodException {
        for (int i = 0; i < fields.length; ++i) {
            Method setter;
            Method getter;
            String field = fields[i];
            if (field.toLowerCase().startsWith("action:")) {
                this.fieldGetters.add(null);
                this.fieldSetters.add(null);
                this.fieldTypes.add(String.class);
                this.fieldNames.add(field.substring(7));
                this.actionColumns.add(i);
                continue;
            }
            if (field.contains("/")) {
                String[] parts = field.split("/");
                getter = dataClass.getMethod(parts[0], new Class[0]);
                setter = dataClass.getMethod(parts[1], getter.getReturnType());
            } else {
                getter = dataClass.getMethod(field, new Class[0]);
                setter = null;
            }
            this.fieldGetters.add(getter);
            this.fieldSetters.add(setter);
            this.fieldTypes.add(getter.getReturnType());
            this.fieldNames.add(this.convertGetterToName(getter.getName()));
        }
    }

    public List<Integer> getActionColumns() {
        return this.actionColumns;
    }

    public void setData(List<T> data) {
        this.data = data;
        this.fireTableDataChanged();
    }

    public List<?> getData() {
        return this.data;
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return this.fieldTypes.get(columnIndex);
    }

    @Override
    public int getColumnCount() {
        return this.fieldGetters.size();
    }

    @Override
    public String getColumnName(int columnIndex) {
        return this.fieldNames.get(columnIndex);
    }

    @Override
    public int getRowCount() {
        return this.data == null ? 0 : this.data.size();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        try {
            Method getter = this.fieldGetters.get(columnIndex);
            if (getter == null) {
                return null;
            }
            return getter.invoke(this.data.get(rowIndex), new Object[0]);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return this.fieldSetters.get(columnIndex) != null;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        try {
            this.fieldSetters.get(columnIndex).invoke(this.data.get(rowIndex), aValue);
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage());
        }
    }

    private String convertGetterToName(String getter) {
        String name = getter.startsWith("get") ? getter.substring(3) : (getter.startsWith("is") ? getter.substring(2) : getter);
        for (int i = 1; i < name.length(); ++i) {
            if (!Character.isUpperCase(name.charAt(i))) continue;
            name = name.substring(0, i) + " " + name.substring(i);
            ++i;
        }
        name = name.replace('_', ' ');
        return name;
    }
}

