/*
 * AppleRecords - A DAAP client
 * Copyright (C) 2004  Chris Davies <c.davies@cdavies.org>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */

package org.cdavies.applerecords;

import javax.swing.*;
import javax.swing.border.*;
import java.awt.*;
import javax.swing.text.*;

import org.cdavies.applerecords.search.*;

/**
 * 
 * This Panel contains the search box widget and allows the implementation
 * of searching for tracks.
 * 
 * 
 * @author       Chris Davies (c.davies@cdavies.org)
 * @version      0.5 21/06/2004
 *
 */

public class AppleRecordsSearchPanel extends JPanel {
	
	private JTextField _searchField;
	
   /**
	*
	* An insanely boring constructor. Adds a border and JTextField to
	* the panel and thats about it.
	*
	*/
	
	public AppleRecordsSearchPanel() {
		
		super();
		
		Border _outline = BorderFactory.createLineBorder(Color.black);
		TitledBorder _searchBorder = BorderFactory.createTitledBorder(_outline, "Search");
		
		setBorder(_searchBorder);
		setLayout(new BorderLayout());
		
		_searchField = new JTextField(15);
		add(_searchField, BorderLayout.NORTH);
		
	}
	
   /**
	*
	* Allows you to add a SearchPanelActionListener to the Search text field
	* which listens to changes in the internal document representation of
	* the search field for changes.
	*
	* @param	listener	A SearchPanelActionListener to add to this panel
	* @see	SearchPanelActionListener
	*
	*/
	
	public void addSearchActionListener(SearchPanelActionListener listener) {
		
		_searchField.getDocument().addDocumentListener(listener);
		
	}
	
	
}
