/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service.paxos;

import com.google.common.base.Objects;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.UUID;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.Mutation;
import org.apache.cassandra.db.partitions.PartitionUpdate;
import org.apache.cassandra.db.rows.SerializationHelper;
import org.apache.cassandra.io.IVersionedSerializer;
import org.apache.cassandra.io.util.DataInputPlus;
import org.apache.cassandra.io.util.DataOutputPlus;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.UUIDGen;
import org.apache.cassandra.utils.UUIDSerializer;

public class Commit {
    public static final CommitSerializer serializer = new CommitSerializer();
    public final UUID ballot;
    public final PartitionUpdate update;

    public Commit(UUID ballot, PartitionUpdate update) {
        assert (ballot != null);
        assert (update != null);
        this.ballot = ballot;
        this.update = update;
    }

    public static Commit newPrepare(DecoratedKey key, CFMetaData metadata, UUID ballot) {
        return new Commit(ballot, PartitionUpdate.emptyUpdate(metadata, key));
    }

    public static Commit newProposal(UUID ballot, PartitionUpdate update) {
        update.updateAllTimestamp(UUIDGen.microsTimestamp(ballot));
        return new Commit(ballot, update);
    }

    public static Commit emptyCommit(DecoratedKey key, CFMetaData metadata) {
        return new Commit(UUIDGen.minTimeUUID(0L), PartitionUpdate.emptyUpdate(metadata, key));
    }

    public boolean isAfter(Commit other) {
        return this.ballot.timestamp() > other.ballot.timestamp();
    }

    public boolean hasBallot(UUID ballot) {
        return this.ballot.equals(ballot);
    }

    public Mutation makeMutation() {
        return new Mutation(this.update);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Commit commit = (Commit)o;
        return this.ballot.equals(commit.ballot) && this.update.equals(commit.update);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.ballot, this.update});
    }

    public String toString() {
        return String.format("Commit(%s, %s)", this.ballot, this.update);
    }

    public static class CommitSerializer
    implements IVersionedSerializer<Commit> {
        @Override
        public void serialize(Commit commit, DataOutputPlus out, int version) throws IOException {
            if (version < 10) {
                ByteBufferUtil.writeWithShortLength(commit.update.partitionKey().getKey(), out);
            }
            UUIDSerializer.serializer.serialize(commit.ballot, out, version);
            PartitionUpdate.serializer.serialize(commit.update, out, version);
        }

        @Override
        public Commit deserialize(DataInputPlus in, int version) throws IOException {
            ByteBuffer key = null;
            if (version < 10) {
                key = ByteBufferUtil.readWithShortLength(in);
            }
            UUID ballot = UUIDSerializer.serializer.deserialize(in, version);
            PartitionUpdate update = PartitionUpdate.serializer.deserialize(in, version, SerializationHelper.Flag.LOCAL, key);
            return new Commit(ballot, update);
        }

        @Override
        public long serializedSize(Commit commit, int version) {
            int size = 0;
            if (version < 10) {
                size += ByteBufferUtil.serializedSizeWithShortLength(commit.update.partitionKey().getKey());
            }
            return (long)size + UUIDSerializer.serializer.serializedSize(commit.ballot, version) + PartitionUpdate.serializer.serializedSize(commit.update, version);
        }
    }
}

