/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.config;

import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import org.apache.cassandra.db.marshal.UserType;

public final class UTMetaData {
    private final Map<ByteBuffer, UserType> userTypes;

    public UTMetaData() {
        this(new HashMap<ByteBuffer, UserType>());
    }

    public UTMetaData(Map<ByteBuffer, UserType> types) {
        this.userTypes = types;
    }

    public UserType getType(ByteBuffer typeName) {
        return this.userTypes.get(typeName);
    }

    public Map<ByteBuffer, UserType> getAllTypes() {
        return new HashMap<ByteBuffer, UserType>(this.userTypes);
    }

    public void addType(UserType type) {
        UserType old = this.userTypes.get(type.name);
        assert (old == null || type.isCompatibleWith(old));
        this.userTypes.put(type.name, type);
    }

    public void removeType(UserType type) {
        this.userTypes.remove(type.name);
    }

    public boolean equals(Object that) {
        if (!(that instanceof UTMetaData)) {
            return false;
        }
        return this.userTypes.equals(((UTMetaData)that).userTypes);
    }
}

