/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.languagetools;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.omegat.languagetools.ILanguageToolBridge;
import org.omegat.languagetools.LanguageToolWrapper;
import org.omegat.util.Preferences;

public final class LanguageToolPrefs {
    public static final String DEFAULT_DISABLED_CATEGORIES = "SPELL,TYPOS";
    public static final String DEFAULT_DISABLED_RULES = "SAME_TRANSLATION,TRANSLATION_LENGTH,DIFFERENT_PUNCTUATION";
    public static final LanguageToolWrapper.BridgeType DEFAULT_BRIDGE_TYPE = LanguageToolWrapper.BridgeType.NATIVE;

    private LanguageToolPrefs() {
    }

    public static void disableRule(String ruleId, String languageCode) {
        Set<String> rules = LanguageToolPrefs.getEnabledRules(languageCode);
        rules.remove(ruleId);
        LanguageToolPrefs.setEnabledRules(rules, languageCode);
        rules = LanguageToolPrefs.getDisabledRules(languageCode);
        rules.add(ruleId);
        LanguageToolPrefs.setDisabledRules(rules, languageCode);
    }

    public static void applyRules(ILanguageToolBridge bridge, String language) {
        Set<String> disabledCategories = LanguageToolPrefs.getDisabledCategories(language);
        Set<String> disabledRules = LanguageToolPrefs.getDisabledRules(language);
        Set<String> enabledRules = LanguageToolPrefs.getEnabledRules(language);
        bridge.applyRuleFilters(disabledCategories, disabledRules, enabledRules);
    }

    public static void setBridgeType(LanguageToolWrapper.BridgeType bridgeType) {
        Preferences.setPreference("lt_bridgeType", (Object)bridgeType);
    }

    public static LanguageToolWrapper.BridgeType getBridgeType() {
        return Preferences.getPreferenceEnumDefault("lt_bridgeType", DEFAULT_BRIDGE_TYPE);
    }

    public static void setRemoteUrl(String url) {
        Preferences.setPreference("lt_remoteURL", url);
    }

    public static String getRemoteUrl() {
        return Preferences.getPreference("lt_remoteURL");
    }

    public static void setLocalServerJarPath(String path) {
        Preferences.setPreference("lt_localServerJarPath", path);
    }

    public static String getLocalServerJarPath() {
        return Preferences.getPreference("lt_localServerJarPath");
    }

    public static void setDisabledRules(Set<String> rules, String languageCode) {
        LanguageToolPrefs.setLanguageSpecificPreference(rules, "lt_disabledRules", languageCode);
    }

    public static void setEnabledRules(Set<String> rules, String languageCode) {
        LanguageToolPrefs.setLanguageSpecificPreference(rules, "lt_enabledRules", languageCode);
    }

    public static void setDisabledCategories(Set<String> categories, String languageCode) {
        LanguageToolPrefs.setLanguageSpecificPreference(categories, "lt_disabledCategories", languageCode);
    }

    public static Set<String> getDisabledRules(String languageCode) {
        return LanguageToolPrefs.getLangauageSpecificPreference("lt_disabledRules", languageCode, DEFAULT_DISABLED_RULES);
    }

    public static Set<String> getDefaultDisabledRules() {
        return LanguageToolPrefs.setOf(DEFAULT_DISABLED_RULES);
    }

    public static Set<String> getEnabledRules(String languageCode) {
        return LanguageToolPrefs.getLangauageSpecificPreference("lt_enabledRules", languageCode, "");
    }

    public static Set<String> getDisabledCategories(String languageCode) {
        return LanguageToolPrefs.getLangauageSpecificPreference("lt_disabledCategories", languageCode, DEFAULT_DISABLED_CATEGORIES);
    }

    public static Set<String> getDefaultDisabledCategories() {
        return LanguageToolPrefs.setOf(DEFAULT_DISABLED_CATEGORIES);
    }

    private static Set<String> getLangauageSpecificPreference(String namePrefix, String languageCode, String defaultValue) {
        String key = namePrefix + "_" + languageCode;
        if (Preferences.existsPreference(key)) {
            return LanguageToolPrefs.setOf(Preferences.getPreference(key));
        }
        return LanguageToolPrefs.setOf(defaultValue);
    }

    private static Set<String> setOf(String commaDelimited) {
        return Stream.of(commaDelimited.split(",")).filter(s -> !s.isEmpty()).collect(Collectors.toSet());
    }

    private static void setLanguageSpecificPreference(Set<String> data, String namePrefix, String languageCode) {
        Preferences.setPreference(namePrefix + "_" + languageCode, String.join((CharSequence)",", data));
    }
}

