/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.externalfinder.gui;

import java.awt.Color;
import java.awt.Window;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.omegat.externalfinder.gui.ExternalFinderSubItemEditorPanel;
import org.omegat.externalfinder.item.ExternalFinderItem;
import org.omegat.externalfinder.item.ExternalFinderItemCommand;
import org.omegat.externalfinder.item.ExternalFinderValidationException;
import org.omegat.util.OStrings;
import org.omegat.util.gui.StaticUIUtils;

public class ExternalFinderItemCommandEditorController {
    private final ExternalFinderSubItemEditorPanel panel;
    private final ExternalFinderItemCommand.Builder builder;
    private boolean userDidConfirm;

    public ExternalFinderItemCommandEditorController() {
        this(new ExternalFinderItemCommand.Builder().setCommand(""));
    }

    public ExternalFinderItemCommandEditorController(ExternalFinderItemCommand item) {
        this(ExternalFinderItemCommand.Builder.from(item));
    }

    public ExternalFinderItemCommandEditorController(ExternalFinderItemCommand.Builder builder) {
        this.builder = builder;
        this.panel = new ExternalFinderSubItemEditorPanel();
    }

    public boolean show(Window parent) {
        JDialog dialog = new JDialog(parent, OStrings.getString("EXTERNALFINDER_COMMANDEDITOR_TITLE"));
        dialog.setModal(true);
        dialog.getContentPane().add(this.panel);
        dialog.setDefaultCloseOperation(2);
        StaticUIUtils.setWindowIcon(dialog);
        StaticUIUtils.setEscapeClosable(dialog);
        this.panel.urlPanel.setVisible(false);
        this.panel.commandTextArea.setText(this.builder.getCommand());
        this.panel.commandTextArea.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.update();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.update();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.update();
            }

            private void update() {
                ExternalFinderItemCommandEditorController.this.builder.setCommand(ExternalFinderItemCommandEditorController.this.panel.commandTextArea.getText().trim());
                ExternalFinderItemCommandEditorController.this.validate();
            }
        });
        this.panel.delimiterTextField.setText(this.builder.getDelimiter());
        this.panel.delimiterTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.update();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.update();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.update();
            }

            private void update() {
                ExternalFinderItemCommandEditorController.this.builder.setDelimiter(ExternalFinderItemCommandEditorController.this.panel.delimiterTextField.getText());
                ExternalFinderItemCommandEditorController.this.validate();
            }
        });
        this.panel.targetComboBox.setModel(new DefaultComboBoxModel<ExternalFinderItem.TARGET>(ExternalFinderItem.TARGET.values()));
        this.panel.targetComboBox.setSelectedItem((Object)this.builder.getTarget());
        this.panel.targetComboBox.addActionListener(e -> {
            this.builder.setTarget((ExternalFinderItem.TARGET)((Object)((Object)this.panel.targetComboBox.getSelectedItem())));
            this.validate();
        });
        this.panel.encodingComboBox.setModel(new DefaultComboBoxModel<ExternalFinderItem.ENCODING>(ExternalFinderItem.ENCODING.values()));
        this.panel.encodingComboBox.setSelectedItem((Object)this.builder.getEncoding());
        this.panel.encodingComboBox.addActionListener(e -> {
            this.builder.setEncoding((ExternalFinderItem.ENCODING)((Object)((Object)this.panel.encodingComboBox.getSelectedItem())));
            this.validate();
        });
        this.panel.okButton.addActionListener(e -> {
            if (this.validate()) {
                this.userDidConfirm = true;
                StaticUIUtils.closeWindowByEvent(dialog);
            }
        });
        dialog.getRootPane().setDefaultButton(this.panel.okButton);
        this.panel.cancelButton.addActionListener(e -> {
            this.userDidConfirm = false;
            StaticUIUtils.closeWindowByEvent(dialog);
        });
        this.panel.testButton.addActionListener(e -> {
            try {
                Runtime.getRuntime().exec(this.builder.generateSampleCommand());
            }
            catch (Exception ex) {
                Logger.getLogger(ExternalFinderItemCommandEditorController.class.getName()).log(Level.SEVERE, null, ex);
                JOptionPane.showMessageDialog(dialog, ex.getLocalizedMessage(), OStrings.getString("ERROR_TITLE"), 0);
            }
        });
        this.validate();
        dialog.pack();
        dialog.setLocationRelativeTo(parent);
        dialog.setVisible(true);
        return this.userDidConfirm;
    }

    public ExternalFinderItemCommand getResult() {
        return this.builder.build();
    }

    private boolean validate() {
        boolean isValid = true;
        String sampleOutput = null;
        try {
            CharSequence[] args = this.builder.validate();
            sampleOutput = String.join((CharSequence)"\u2423", args);
        }
        catch (ExternalFinderValidationException e) {
            isValid = false;
            sampleOutput = e.getLocalizedMessage();
        }
        this.panel.okButton.setEnabled(isValid);
        this.panel.testButton.setEnabled(isValid);
        this.panel.sampleOutputTextArea.setText(sampleOutput);
        this.panel.sampleOutputTextArea.setForeground(isValid ? Color.BLACK : Color.RED);
        return isValid;
    }
}

