/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.languagemodel;

import edu.berkeley.nlp.lm.StupidBackoffLm;
import edu.berkeley.nlp.lm.io.LmReaders;
import java.io.File;
import java.util.List;
import org.languagetool.Experimental;
import org.languagetool.languagemodel.LanguageModel;
import org.languagetool.rules.ngrams.Probability;

@Experimental
public class BerkeleyLanguageModel
implements LanguageModel {
    private final StupidBackoffLm<String> lm;

    public BerkeleyLanguageModel(File berkeleyLm) {
        if (!berkeleyLm.isFile()) {
            throw new RuntimeException("You need to specify a BerkeleyLM file (*.blm.gz): " + berkeleyLm);
        }
        File vocabFile = new File(berkeleyLm.getParent(), "vocab_cs.gz");
        if (!vocabFile.exists()) {
            throw new RuntimeException("No vocabulary file 'vocab_cs.gz' found in the BerkeleyLM directory: " + vocabFile);
        }
        this.lm = LmReaders.readGoogleLmBinary((String)berkeleyLm.getAbsolutePath(), (String)vocabFile.getAbsolutePath());
    }

    @Override
    public Probability getPseudoProbability(List<String> context) {
        float logProb = this.lm.getLogProb(context);
        if (Float.isNaN(logProb)) {
            return new Probability(0.0, 1.0f);
        }
        return new Probability(Math.pow(10.0, logProb), 1.0f);
    }

    @Override
    public void close() {
    }
}

