/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.client.session;

import java.io.IOException;
import java.time.Duration;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.sshd.agent.common.AgentForwardSupport;
import org.apache.sshd.client.ClientFactoryManager;
import org.apache.sshd.client.session.AbstractClientSession;
import org.apache.sshd.client.session.ClientSession;
import org.apache.sshd.client.session.ClientSessionHolder;
import org.apache.sshd.common.PropertyResolver;
import org.apache.sshd.common.SshException;
import org.apache.sshd.common.io.IoWriteFuture;
import org.apache.sshd.common.session.helpers.AbstractConnectionService;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.core.CoreModuleProperties;
import org.apache.sshd.server.x11.X11ForwardSupport;

public class ClientConnectionService
extends AbstractConnectionService
implements ClientSessionHolder {
    protected final String heartbeatRequest = (String)CoreModuleProperties.HEARTBEAT_REQUEST.getRequired((PropertyResolver)this);
    protected final Duration heartbeatInterval = (Duration)CoreModuleProperties.HEARTBEAT_INTERVAL.getRequired((PropertyResolver)this);
    protected final Duration heartbeatReplyMaxWait = (Duration)CoreModuleProperties.HEARTBEAT_REPLY_WAIT.getRequired((PropertyResolver)this);
    protected ScheduledFuture<?> clientHeartbeat;

    public ClientConnectionService(AbstractClientSession s) throws SshException {
        super(s);
    }

    @Override
    public final ClientSession getClientSession() {
        return this.getSession();
    }

    @Override
    public AbstractClientSession getSession() {
        return (AbstractClientSession)super.getSession();
    }

    @Override
    public void start() {
        ClientSession session = this.getClientSession();
        if (!session.isAuthenticated()) {
            throw new IllegalStateException("Session is not authenticated");
        }
        super.start();
    }

    @Override
    protected synchronized ScheduledFuture<?> startHeartBeat() {
        if (!GenericUtils.isNegativeOrNull((Duration)this.heartbeatInterval) && GenericUtils.isNotEmpty((CharSequence)this.heartbeatRequest)) {
            this.stopHeartBeat();
            ClientSession session = this.getClientSession();
            ClientFactoryManager manager = session.getFactoryManager();
            ScheduledExecutorService service = manager.getScheduledExecutorService();
            this.clientHeartbeat = service.scheduleAtFixedRate(this::sendHeartBeat, this.heartbeatInterval.toMillis(), this.heartbeatInterval.toMillis(), TimeUnit.MILLISECONDS);
            if (this.log.isDebugEnabled()) {
                this.log.debug("startHeartbeat({}) - started at interval={} with request={}", new Object[]{session, this.heartbeatInterval, this.heartbeatRequest});
            }
            return this.clientHeartbeat;
        }
        return super.startHeartBeat();
    }

    @Override
    protected synchronized void stopHeartBeat() {
        try {
            super.stopHeartBeat();
        }
        finally {
            if (this.clientHeartbeat != null) {
                this.clientHeartbeat = null;
            }
        }
    }

    @Override
    protected boolean sendHeartBeat() {
        if (this.clientHeartbeat == null) {
            return super.sendHeartBeat();
        }
        AbstractClientSession session = this.getSession();
        try {
            boolean withReply = !GenericUtils.isNegativeOrNull((Duration)this.heartbeatReplyMaxWait);
            Buffer buf = session.createBuffer((byte)80, this.heartbeatRequest.length() + 8);
            buf.putString(this.heartbeatRequest);
            buf.putBoolean(withReply);
            if (withReply) {
                Buffer reply = session.request(this.heartbeatRequest, buf, this.heartbeatReplyMaxWait);
                if (reply != null && this.log.isTraceEnabled()) {
                    this.log.trace("sendHeartBeat({}) received reply size={} for request={}", new Object[]{session, reply.available(), this.heartbeatRequest});
                }
            } else {
                IoWriteFuture future = session.writePacket(buf);
                future.addListener(this::futureDone);
            }
            this.heartbeatCount.incrementAndGet();
            return true;
        }
        catch (IOException | Error | RuntimeException e) {
            session.exceptionCaught(e);
            this.warn("sendHeartBeat({}) failed ({}) to send heartbeat #{} request={}: {}", session, e.getClass().getSimpleName(), this.heartbeatCount, this.heartbeatRequest, e.getMessage(), e);
            return false;
        }
    }

    @Override
    public AgentForwardSupport getAgentForwardSupport() {
        throw new IllegalStateException("Server side operation");
    }

    @Override
    public X11ForwardSupport getX11ForwardSupport() {
        throw new IllegalStateException("Server side operation");
    }
}

