# Copyright (C) 2005 Jay Beale
# Copyright (C) 2005 Charlie Long, Delphi Research
# Licensed under the GNU General Public License


require Bastille::API;
import Bastille::API;

$GLOBAL_TEST{'Logging'}{'morelogging'} =
    sub {

	my $syslog = &getGlobal('FILE','syslog.conf');
	my $syslogretval = $SKIPQ; 

	#We don't want to ding people for missing err

	# Check /var/log/syslog for three things...
	# Log all messages that are at the "err" severity level and above.
	
	#if (! &B_match_line($syslog,"\.err.*\t")) {
	#	$syslogretval = $ASKQ;
	#}
		### Check kern\.
	# Log all kernel messages.
	if (! &B_match_line($syslog,"kern[,.].*\t")) {
		$syslogretval = $ASKQ;
	}
		### Check ^[^\#]*auth\.    AND    user\.    AND   daemon\.    
		## Make them OR  and then put a comment in the code that says:
		## TODO: Check whether all three of these are actually necessary.
	# Get information about logins, especially failed ones.
	elsif (! &B_match_line($syslog,"authpriv[,.].*\t")) {
		$syslogretval = $ASKQ;
	}
	return $syslogretval;
};

#This logs for process accounting

$GLOBAL_TEST{'Logging'}{"pacct"} =
    sub {
	if (&GetDistro =~ /^SE/) {
	    return ( ! &B_is_service_off('acct') );
	}
	if (&GetDistro =~ "^RH") 
	{
	    # First check if the psacct init.d script is active.
	    if ( ! &B_is_service_off('psacct') ) {
		return $SKIPQ;
	    }
	    # If it's not, check rc.local for accton.
	    my $rclocal = &getGlobal('FILE','rc.local');
	    if (&B_match_line($rclocal,'accton')) {
		return $SKIPQ;
	    }
	    # If neither of these is true, ask the question.
	    return $ASKQ;
	}
    };

#This checks for Laus.  RedHat Enterprise has taken out of their distro
#so we are not worried about it.  We will use auditd later

$GLOBAL_TEST{'Logging'}{"laus"} =
    sub {
	my $sysctlconf = &getGlobal('FILE',"sysconfig_audit");
	my $sysctl = $SKIPQ;

	if (&GetDistro !~ /^SESLES/) {
		return $SKIPQ;
	}
	
	#Doesn't seem to be working with SUSE

        ## Check whether /etc/init.d/audit is on
	#if (&B_is_service_off('audit')) {
	#    return $ASKQ;
	#}

	#check /etc/sysconfig/audit for LaUS-related audting
	if (! &B_match_line("$sysctlconf","AUDIT_ALLOW_SUSPEND=1")) {
		$sysctl = $ASKQ;
	} 
	elsif (! &B_match_line("$sysctlconf","AUDIT_ATTACH_ALL=0")) {
		$sysctl = $ASKQ;
	} 
	# Check for 1024 or better (higher/lower?)
	elsif (! &B_match_line("$sysctlconf","AUDIT_MAX_MESSAGES=1024")) {
		$sysctl = $ASKQ;
	} 
	elsif (! &B_match_line("$sysctlconf","AUDIT_PARANOIA=0")) {
		$sysctl = $ASKQ;
	} 
	
	return $sysctl; 
    };


1;
