/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.progress.spi;

import org.netbeans.modules.progress.spi.InternalHandle;

public final class ProgressEvent {
    public static final int TYPE_START = 0;
    public static final int TYPE_FINISH = 4;
    public static final int TYPE_REQUEST_STOP = 3;
    public static final int TYPE_PROGRESS = 1;
    public static final int TYPE_SWITCH = 5;
    public static final int TYPE_SILENT = 6;
    private InternalHandle source;
    private long estimatedCompletion;
    private double percentageDone;
    private int workunitsDone;
    private String message;
    private int type;
    private boolean watched;
    private boolean switched;
    private String displayName;

    public ProgressEvent(InternalHandle internalHandle, int n, boolean bl) {
        this.source = internalHandle;
        this.estimatedCompletion = -1L;
        this.percentageDone = -1.0;
        this.workunitsDone = -1;
        this.message = null;
        this.type = n;
        this.watched = bl;
        this.switched = n == 5;
    }

    public ProgressEvent(InternalHandle internalHandle, int n, boolean bl, String string) {
        this(internalHandle, n, bl);
        this.message = string;
    }

    public ProgressEvent(InternalHandle internalHandle, String string, int n, double d, long l, boolean bl) {
        this(internalHandle, 1, bl);
        this.workunitsDone = n;
        this.percentageDone = d;
        this.estimatedCompletion = l;
        this.message = string;
    }

    public ProgressEvent(InternalHandle internalHandle, String string, int n, double d, long l, boolean bl, String string2) {
        this(internalHandle, string, n, d, l, bl);
        this.displayName = string2;
    }

    public InternalHandle getSource() {
        return this.source;
    }

    public long getEstimatedCompletion() {
        return this.estimatedCompletion;
    }

    public double getPercentageDone() {
        return this.percentageDone;
    }

    public int getWorkunitsDone() {
        return this.workunitsDone;
    }

    public String getMessage() {
        return this.message;
    }

    public int getType() {
        return this.type;
    }

    public boolean isWatched() {
        return this.watched;
    }

    public void copyMessageFromEarlier(ProgressEvent progressEvent) {
        if (this.message == null) {
            this.message = progressEvent.getMessage();
        }
        if (this.displayName == null) {
            this.displayName = progressEvent.getDisplayName();
        }
    }

    public void markAsSwitched() {
        this.switched = true;
    }

    public boolean isSwitched() {
        return this.switched;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String toString() {
        String string;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("EV[").append(this.getSource());
        stringBuilder.append(", disp: ").append(this.displayName);
        switch (this.type) {
            case 4: {
                string = "finish";
                break;
            }
            case 1: {
                string = "progress";
                break;
            }
            case 3: {
                string = "stop";
                break;
            }
            case 6: {
                string = "silent";
                break;
            }
            case 0: {
                string = "start";
                break;
            }
            case 5: {
                string = "switch";
                break;
            }
            default: {
                string = "" + this.type;
            }
        }
        stringBuilder.append(", type: ").append(string);
        stringBuilder.append(", pctDone: ").append(String.format("%3.2f", this.percentageDone));
        stringBuilder.append(", message: ").append(this.message);
        stringBuilder.append(", disp: ").append(this.displayName);
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    void markAsFinished() {
        this.type = 4;
    }
}

