/*
 * Decompiled with CFR 0.152.
 */
package org.fife.rtext;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.net.URL;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.UIManager;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.fife.rtext.RText;
import org.fife.ui.RScrollPane;
import org.fife.ui.SelectableLabel;
import org.fife.ui.UIUtil;
import org.fife.ui.app.AbstractPluggableGUIApplication;
import org.fife.ui.app.Plugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class AboutDialog
extends org.fife.ui.AboutDialog {
    private static final String MSG = "org.fife.rtext.AboutDialog";

    public AboutDialog(RText rtext) {
        super((Frame)((Object)rtext), rtext.getResourceBundle().getString("AboutDialogTitle"));
        ResourceBundle msg = ResourceBundle.getBundle(MSG);
        ComponentOrientation orientation = ComponentOrientation.getOrientation(this.getLocale());
        JPanel temp = UIUtil.newTabbedPanePanel((LayoutManager)new BorderLayout());
        temp.setBorder(UIUtil.getEmpty5Border());
        JPanel panel = UIUtil.newTabbedPanePanel();
        panel.setLayout(new BoxLayout(panel, 2));
        panel.add(new JLabel(msg.getString("Static.TableDescription")));
        panel.add(Box.createHorizontalGlue());
        temp.add((Component)panel, "North");
        JTable pluginTable = new JTable(AboutDialog.createTableData(rtext), new String[]{msg.getString("Column.Plugin"), msg.getString("Column.Version"), msg.getString("Column.Author")}){

            public Dimension getPreferredScrollableViewportSize() {
                return new Dimension(50, 50);
            }

            public boolean isCellEditable(int row, int column) {
                return false;
            }

            public boolean getScrollableTracksViewportHeight() {
                Container parent = this.getParent();
                return parent instanceof JViewport ? parent.getHeight() > this.getPreferredSize().height : false;
            }
        };
        UIUtil.fixJTableRendererOrientations((JTable)pluginTable);
        temp.add((Component)new RScrollPane((Component)pluginTable));
        temp.applyComponentOrientation(orientation);
        this.addPanel(msg.getString("Tab.Plugins"), temp);
        this.addPanel(msg.getString("Tab.Libraries"), AboutDialog.createLibrariesPanel(msg));
        this.pack();
    }

    protected JPanel createAboutApplicationPanel() {
        JPanel temp = UIUtil.newTabbedPanePanel((LayoutManager)new BorderLayout());
        temp.setBorder(UIUtil.getEmpty5Border());
        ClassLoader cl = ((Object)((Object)this)).getClass().getClassLoader();
        ResourceBundle msg = ResourceBundle.getBundle(MSG);
        URL imageURL = cl.getResource("org/fife/rtext/graphics/" + msg.getString("Splash.Image"));
        ImageIcon icon = new ImageIcon(imageURL);
        JLabel label = new JLabel(icon);
        label.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        temp.add((Component)label, "Center");
        JPanel panel = UIUtil.newTabbedPanePanel();
        RText rtext = (RText)((Object)this.getOwner());
        InfoPane editor = new InfoPane(rtext);
        panel.add((Component)((Object)editor));
        temp.add((Component)panel, "South");
        return temp;
    }

    private static final void appendLibrary(StringBuilder sb, String name, String url, String desc) {
        sb.append("<tr><td><b>").append(name).append("</b></td>");
        sb.append("<td><a href=\"").append(url).append("\">");
        sb.append(url).append("</a></td></tr>");
        sb.append("<tr><td colspan=\"2\">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;\u2022 ");
        sb.append(desc).append("</td></tr>");
        sb.append("<tr><td>&nbsp;</td><td>&nbsp;</td></tr>");
    }

    private static final JPanel createLibrariesPanel(ResourceBundle msg) {
        JPanel panel = UIUtil.newTabbedPanePanel((LayoutManager)new BorderLayout());
        panel.setBorder(UIUtil.getEmpty5Border());
        StringBuilder sb = new StringBuilder("<html><table>");
        AboutDialog.appendLibrary(sb, "RSyntaxTextArea:", "http://fifesoft.com/rsyntaxtextarea", msg.getString("Desc.RSyntaxTextArea"));
        AboutDialog.appendLibrary(sb, "JTidy:", "http://jtidy.sourceforge.net/", msg.getString("Desc.JTidy"));
        AboutDialog.appendLibrary(sb, "Jazzy:", "http://jazzy.sourceforge.net/", msg.getString("Desc.Jazzy"));
        AboutDialog.appendLibrary(sb, "JGoodies:", "http://jgoodies.com", msg.getString("Desc.JGoodies"));
        AboutDialog.appendLibrary(sb, "Insubstantial:", "https://github.com/Insubstantial/insubstantial", msg.getString("Desc.Substance"));
        AboutDialog.appendLibrary(sb, "Groovy:", "http://groovy.codehaus.org/", msg.getString("Desc.Groovy"));
        sb.append("</table>");
        final SelectableLabel label = new SelectableLabel(sb.toString());
        label.addHyperlinkListener(new HyperlinkListener(){

            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (HyperlinkEvent.EventType.ACTIVATED == e.getEventType() && !UIUtil.browse((String)e.getDescription())) {
                    UIManager.getLookAndFeel().provideErrorFeedback((Component)label);
                }
            }
        });
        panel.add((Component)label);
        return panel;
    }

    private static final String[][] createTableData(AbstractPluggableGUIApplication<?> app) {
        Plugin[] plugins = app.getPlugins();
        int count = plugins.length;
        if (count > 0) {
            String[][] strings = new String[count][3];
            for (int i = 0; i < count; ++i) {
                strings[i][0] = plugins[i].getPluginName();
                strings[i][1] = plugins[i].getPluginVersion();
                strings[i][2] = plugins[i].getPluginAuthor();
            }
            return strings;
        }
        ResourceBundle msg = ResourceBundle.getBundle(MSG);
        String text = msg.getString("Message.NoPluginsInstalled");
        String[][] strings = new String[][]{{text, "", ""}};
        return strings;
    }

    private static class InfoPane
    extends SelectableLabel
    implements HyperlinkListener {
        private RText rtext;

        public InfoPane(RText rtext) {
            this.rtext = rtext;
            this.setText(this.getContentText());
            this.addHyperlinkListener(this);
        }

        public String getContentText() {
            String version = this.rtext == null ? "firstTime" : this.rtext.getVersionString();
            String text = "<html><body><center>Version " + version + "<br>" + "Copyright (c) 2014 Robert Futrell<br>" + "<a href=\"http://rtext.fifesoft.com\">http://rtext.fifesoft.com</a>" + "</font></center></body></html>";
            return text;
        }

        public void hyperlinkUpdate(HyperlinkEvent e) {
            if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                UIUtil.browse((String)e.getURL().toString());
            }
        }

        public void updateUI() {
            super.updateUI();
            this.setText(this.getContentText());
        }
    }
}

