/*
 * Decompiled with CFR 0.152.
 */
package java.security.cert;

import gnu.classpath.SystemProperties;
import gnu.java.security.OID;
import java.io.IOException;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.cert.CertSelector;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.security.spec.X509EncodedKeySpec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.security.auth.x500.X500Principal;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class X509CertSelector
implements CertSelector,
Cloneable {
    private static final String AUTH_KEY_ID = "2.5.29.35";
    private static final String SUBJECT_KEY_ID = "2.5.29.14";
    private static final String NAME_CONSTRAINTS_ID = "2.5.29.30";
    private int basicConstraints = -1;
    private X509Certificate cert;
    private BigInteger serialNo;
    private X500Principal issuer;
    private X500Principal subject;
    private byte[] subjectKeyId;
    private byte[] authKeyId;
    private boolean[] keyUsage;
    private Date certValid;
    private OID sigId;
    private PublicKey subjectKey;
    private X509EncodedKeySpec subjectKeySpec;
    private Set keyPurposeSet;
    private List altNames;
    private boolean matchAllNames;
    private byte[] nameConstraints;
    private Set policy;
    static /* synthetic */ Class class$java$security$spec$X509EncodedKeySpec;
    static /* synthetic */ Class class$java$security$cert$X509CertSelector;

    public X509Certificate getCertificate() {
        return this.cert;
    }

    public void setCertificate(X509Certificate cert) {
        this.cert = cert;
    }

    public BigInteger getSerialNumber() {
        return this.serialNo;
    }

    public void setSerialNumber(BigInteger serialNo) {
        this.serialNo = serialNo;
    }

    public String getIssuerAsString() {
        if (this.issuer != null) {
            return this.issuer.getName();
        }
        return null;
    }

    public byte[] getIssuerAsBytes() throws IOException {
        if (this.issuer != null) {
            return this.issuer.getEncoded();
        }
        return null;
    }

    public void setIssuer(String name) throws IOException {
        if (name != null) {
            try {
                this.issuer = new X500Principal(name);
            }
            catch (IllegalArgumentException iae) {
                throw new IOException(iae.getMessage());
            }
        } else {
            this.issuer = null;
        }
    }

    public void setIssuer(byte[] name) throws IOException {
        if (name != null) {
            try {
                this.issuer = new X500Principal(name);
            }
            catch (IllegalArgumentException iae) {
                throw new IOException(iae.getMessage());
            }
        } else {
            this.issuer = null;
        }
    }

    public String getSubjectAsString() {
        if (this.subject != null) {
            return this.subject.getName();
        }
        return null;
    }

    public byte[] getSubjectAsBytes() throws IOException {
        if (this.subject != null) {
            return this.subject.getEncoded();
        }
        return null;
    }

    public void setSubject(String name) throws IOException {
        if (name != null) {
            try {
                this.subject = new X500Principal(name);
            }
            catch (IllegalArgumentException iae) {
                throw new IOException(iae.getMessage());
            }
        } else {
            this.subject = null;
        }
    }

    public void setSubject(byte[] name) throws IOException {
        if (name != null) {
            try {
                this.subject = new X500Principal(name);
            }
            catch (IllegalArgumentException iae) {
                throw new IOException(iae.getMessage());
            }
        } else {
            this.subject = null;
        }
    }

    public byte[] getSubjectKeyIdentifier() {
        if (this.subjectKeyId != null) {
            return (byte[])this.subjectKeyId.clone();
        }
        return null;
    }

    public void setSubjectKeyIdentifier(byte[] subjectKeyId) {
        this.subjectKeyId = subjectKeyId != null ? (byte[])subjectKeyId.clone() : null;
    }

    public byte[] getAuthorityKeyIdentifier() {
        if (this.authKeyId != null) {
            return (byte[])this.authKeyId.clone();
        }
        return null;
    }

    public void setAuthorityKeyIdentifier(byte[] authKeyId) {
        this.authKeyId = authKeyId != null ? (byte[])authKeyId.clone() : null;
    }

    public Date getCertificateValid() {
        if (this.certValid != null) {
            return (Date)this.certValid.clone();
        }
        return null;
    }

    public void setCertificateValid(Date certValid) {
        this.certValid = certValid != null ? (Date)certValid.clone() : null;
    }

    public Date getPrivateKeyValid() {
        return null;
    }

    public void setPrivateKeyValid(Date UNUSED) {
    }

    public String getSubjectPublicKeyAlgID() {
        return String.valueOf(this.sigId);
    }

    public void setSubjectPublicKeyAlgID(String sigId) throws IOException {
        if (sigId != null) {
            try {
                OID oid = new OID(sigId);
                int[] comp = oid.getIDs();
                if (!X509CertSelector.checkOid(comp)) {
                    throw new IOException("malformed OID: " + sigId);
                }
                this.sigId = oid;
            }
            catch (IllegalArgumentException iae) {
                IOException ioe = new IOException("malformed OID: " + sigId);
                ioe.initCause(iae);
                throw ioe;
            }
        } else {
            this.sigId = null;
        }
    }

    public PublicKey getSubjectPublicKey() {
        return this.subjectKey;
    }

    public void setSubjectPublicKey(PublicKey key) {
        this.subjectKey = key;
        if (key == null) {
            this.subjectKeySpec = null;
            return;
        }
        try {
            KeyFactory enc = KeyFactory.getInstance("X.509");
            Class clazz = class$java$security$spec$X509EncodedKeySpec;
            if (clazz == null) {
                clazz = class$java$security$spec$X509EncodedKeySpec = X509CertSelector.class("[Ljava.security.spec.X509EncodedKeySpec;", false);
            }
            this.subjectKeySpec = (X509EncodedKeySpec)enc.getKeySpec(key, clazz);
        }
        catch (Exception x) {
            this.subjectKey = null;
            this.subjectKeySpec = null;
        }
    }

    public void setSubjectPublicKey(byte[] key) throws IOException {
        if (key == null) {
            this.subjectKey = null;
            this.subjectKeySpec = null;
            return;
        }
        try {
            this.subjectKeySpec = new X509EncodedKeySpec(key);
            KeyFactory enc = KeyFactory.getInstance("X.509");
            this.subjectKey = enc.generatePublic(this.subjectKeySpec);
        }
        catch (Exception x) {
            this.subjectKey = null;
            this.subjectKeySpec = null;
            IOException ioe = new IOException(x.getMessage());
            ioe.initCause(x);
            throw ioe;
        }
    }

    public boolean[] getKeyUsage() {
        if (this.keyUsage != null) {
            return (boolean[])this.keyUsage.clone();
        }
        return null;
    }

    public void setKeyUsage(boolean[] keyUsage) {
        this.keyUsage = keyUsage != null ? (boolean[])keyUsage.clone() : null;
    }

    public Set getExtendedKeyUsage() {
        if (this.keyPurposeSet != null) {
            return Collections.unmodifiableSet(this.keyPurposeSet);
        }
        return null;
    }

    public void setExtendedKeyUsage(Set keyPurposeSet) throws IOException {
        if (keyPurposeSet == null) {
            this.keyPurposeSet = null;
            return;
        }
        HashSet s = new HashSet();
        Iterator it = keyPurposeSet.iterator();
        while (it.hasNext()) {
            Object o = it.next();
            if (!(o instanceof String)) {
                throw new IOException("not a string: " + o);
            }
            try {
                OID oid = new OID((String)o);
                int[] comp = oid.getIDs();
                if (X509CertSelector.checkOid(comp)) continue;
                throw new IOException("malformed OID: " + o);
            }
            catch (IllegalArgumentException iae) {
                IOException ioe = new IOException("malformed OID: " + o);
                ioe.initCause(iae);
                throw ioe;
            }
        }
        this.keyPurposeSet = s;
    }

    public boolean getMatchAllSubjectAltNames() {
        return this.matchAllNames;
    }

    public void setMatchAllSubjectAltNames(boolean matchAllNames) {
        this.matchAllNames = matchAllNames;
    }

    public void setSubjectAlternativeNames(Collection altNames) throws IOException {
        if (altNames == null) {
            this.altNames = null;
            return;
        }
        ArrayList l = new ArrayList(altNames.size());
        Iterator it = altNames.iterator();
        while (it.hasNext()) {
            Object o = it.next();
            if (!(o instanceof List && ((List)o).size() == 2 && ((List)o).get(0) instanceof Integer && ((List)o).get(1) instanceof String && ((List)o).get(1) instanceof byte[])) {
                throw new IOException("illegal alternative name: " + o);
            }
            Integer i = (Integer)((List)o).get(0);
            if (i < 0 || i > 8) {
                throw new IOException("illegal alternative name: " + o + ", bad id: " + i);
            }
            l.add(new ArrayList((List)o));
        }
        this.altNames = l;
    }

    public void addSubjectAlternativeName(int id, String name) throws IOException {
        if (id < 0 || id > 8 || name == null) {
            throw new IOException("illegal alternative name");
        }
        if (this.altNames == null) {
            this.altNames = new LinkedList();
        }
        ArrayList l = new ArrayList(2);
        l.add(new Integer(id));
        l.add(name);
        this.altNames.add(l);
    }

    public void addSubjectAlternativeName(int id, byte[] name) throws IOException {
        if (id < 0 || id > 8 || name == null) {
            throw new IOException("illegal alternative name");
        }
        if (this.altNames == null) {
            this.altNames = new LinkedList();
        }
        ArrayList l = new ArrayList(2);
        l.add(new Integer(id));
        l.add(name);
        this.altNames.add(l);
    }

    public byte[] getNameConstraints() {
        if (this.nameConstraints != null) {
            return (byte[])this.nameConstraints.clone();
        }
        return null;
    }

    public void setNameConstraints(byte[] nameConstraints) throws IOException {
        this.nameConstraints = nameConstraints != null ? (byte[])nameConstraints.clone() : null;
    }

    public int getBasicConstraints() {
        return this.basicConstraints;
    }

    public void setBasicConstraints(int basicConstraints) {
        if (basicConstraints < -1) {
            basicConstraints = -1;
        }
        this.basicConstraints = basicConstraints;
    }

    public boolean match(Certificate certificate) {
        byte[] nc;
        Object[] b;
        if (!(certificate instanceof X509Certificate)) {
            return false;
        }
        X509Certificate cert = (X509Certificate)certificate;
        if (this.cert != null) {
            try {
                byte[] e1 = this.cert.getEncoded();
                byte[] e2 = cert.getEncoded();
                if (!Arrays.equals(e1, e2)) {
                    return false;
                }
            }
            catch (CertificateEncodingException cee) {
                return false;
            }
        }
        if (this.serialNo != null && !this.serialNo.equals(cert.getSerialNumber())) {
            return false;
        }
        if (this.certValid != null) {
            try {
                cert.checkValidity(this.certValid);
            }
            catch (CertificateException ce) {
                return false;
            }
        }
        if (this.issuer != null && !this.issuer.equals(cert.getIssuerX500Principal())) {
            return false;
        }
        if (this.subject != null && !this.subject.equals(cert.getSubjectX500Principal())) {
            return false;
        }
        if (this.sigId != null && !this.sigId.toString().equals(cert.getSigAlgOID())) {
            return false;
        }
        if (this.subjectKeyId != null && !Arrays.equals(b = cert.getExtensionValue(SUBJECT_KEY_ID), this.subjectKeyId)) {
            return false;
        }
        if (this.authKeyId != null && !Arrays.equals(b = cert.getExtensionValue(AUTH_KEY_ID), this.authKeyId)) {
            return false;
        }
        if (this.keyUsage != null && !Arrays.equals((boolean[])(b = (Object[])cert.getKeyUsage()), this.keyUsage)) {
            return false;
        }
        if (this.basicConstraints >= 0 && cert.getBasicConstraints() != this.basicConstraints) {
            return false;
        }
        if (this.keyPurposeSet != null) {
            List kp = null;
            try {
                kp = cert.getExtendedKeyUsage();
            }
            catch (CertificateParsingException cpe) {
                return false;
            }
            if (kp == null) {
                return false;
            }
            Iterator it = this.keyPurposeSet.iterator();
            while (it.hasNext()) {
                if (kp.contains(it.next())) continue;
                return false;
            }
        }
        if (this.altNames != null) {
            Collection an = null;
            try {
                an = cert.getSubjectAlternativeNames();
            }
            catch (CertificateParsingException cpe) {
                return false;
            }
            if (an == null) {
                return false;
            }
            int match = 0;
            Iterator it = this.altNames.iterator();
            while (it.hasNext()) {
                List l = (List)it.next();
                Integer id = (Integer)l.get(0);
                String s = null;
                byte[] b2 = null;
                if (l.get(1) instanceof String) {
                    s = (String)l.get(1);
                } else if (l.get(1) instanceof byte[]) {
                    b2 = (byte[])l.get(1);
                } else {
                    return false;
                }
                Iterator it2 = an.iterator();
                while (it2.hasNext()) {
                    List l2;
                    Object o = it2.next();
                    if (!(o instanceof List) || (l2 = (List)o).size() != 2 || !id.equals(l2.get(0))) continue;
                    if (s != null && l2.get(1) instanceof String && s.equals(l2.get(1))) {
                        ++match;
                        continue;
                    }
                    if (b2 == null || !(l2.get(1) instanceof byte[]) || !Arrays.equals(b2, (byte[])l2.get(1))) continue;
                    ++match;
                }
                if (match != 0 && (!this.matchAllNames || match == this.altNames.size())) continue;
                return false;
            }
        }
        return this.nameConstraints == null || Arrays.equals(this.nameConstraints, nc = cert.getExtensionValue(NAME_CONSTRAINTS_ID));
    }

    public String toString() {
        int i;
        Class clazz = class$java$security$cert$X509CertSelector;
        if (clazz == null) {
            clazz = class$java$security$cert$X509CertSelector = X509CertSelector.class("[Ljava.security.cert.X509CertSelector;", false);
        }
        StringBuffer str = new StringBuffer(clazz.getName());
        String nl = SystemProperties.getProperty("line.separator");
        String eol = ";" + nl;
        str.append(" {").append(nl);
        if (this.cert != null) {
            str.append("  certificate = ").append(this.cert).append(eol);
        }
        if (this.basicConstraints >= 0) {
            str.append("  basic constraints = ").append(this.basicConstraints).append(eol);
        }
        if (this.serialNo != null) {
            str.append("  serial number = ").append(this.serialNo).append(eol);
        }
        if (this.certValid != null) {
            str.append("  valid date = ").append(this.certValid).append(eol);
        }
        if (this.issuer != null) {
            str.append("  issuer = ").append(this.issuer).append(eol);
        }
        if (this.subject != null) {
            str.append("  subject = ").append(this.subject).append(eol);
        }
        if (this.sigId != null) {
            str.append("  signature OID = ").append(this.sigId).append(eol);
        }
        if (this.subjectKey != null) {
            str.append("  subject public key = ").append(this.subjectKey).append(eol);
        }
        if (this.subjectKeyId != null) {
            str.append("  subject key ID = ");
            i = 0;
            while (i < this.subjectKeyId.length) {
                str.append(Character.forDigit((this.subjectKeyId[i] & 0xF0) >>> 8, 16));
                str.append(Character.forDigit(this.subjectKeyId[i] & 0xF, 16));
                if (i < this.subjectKeyId.length - 1) {
                    str.append(':');
                }
                ++i;
            }
            str.append(eol);
        }
        if (this.authKeyId != null) {
            str.append("  authority key ID = ");
            i = 0;
            while (i < this.authKeyId.length) {
                str.append(Character.forDigit((this.authKeyId[i] & 0xF0) >>> 8, 16));
                str.append(Character.forDigit(this.authKeyId[i] & 0xF, 16));
                if (i < this.authKeyId.length - 1) {
                    str.append(':');
                }
                ++i;
            }
            str.append(eol);
        }
        if (this.keyUsage != null) {
            str.append("  key usage = ");
            i = 0;
            while (i < this.keyUsage.length) {
                str.append(this.keyUsage[i] + 48);
                ++i;
            }
            str.append(eol);
        }
        if (this.keyPurposeSet != null) {
            str.append("  key purpose = ").append(this.keyPurposeSet).append(eol);
        }
        if (this.altNames != null) {
            str.append("  alternative names = ").append(this.altNames).append(eol);
        }
        if (this.nameConstraints != null) {
            str.append("  name constraints = <blob of data>").append(eol);
        }
        str.append("}").append(nl);
        return str.toString();
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException shouldNotHappen) {
            throw new Error(shouldNotHappen);
        }
    }

    private static final boolean checkOid(int[] oid) {
        boolean bl = false;
        if (oid != null && oid.length > 2 && oid[0] >= 0 && oid[0] <= 2 && oid[1] >= 0 && oid[1] <= 39) {
            bl = true;
        }
        return bl;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }
}

