/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.data;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.impl.CoreProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.NotNullFunction;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.TimedVcsCommit;
import com.intellij.vcs.log.VcsCommitMetadata;
import com.intellij.vcs.log.VcsLogProvider;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.data.CompressedRefs;
import com.intellij.vcs.log.data.DataPack;
import com.intellij.vcs.log.data.SingleTaskController;
import com.intellij.vcs.log.data.TopCommitsCache;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.data.VcsLogJoiner;
import com.intellij.vcs.log.data.VcsLogMultiRepoJoiner;
import com.intellij.vcs.log.data.VcsLogProgress;
import com.intellij.vcs.log.data.VcsLogRefreshNotEnoughDataException;
import com.intellij.vcs.log.data.VcsLogRefresher;
import com.intellij.vcs.log.data.VcsLogStorage;
import com.intellij.vcs.log.data.VcsUserRegistryImpl;
import com.intellij.vcs.log.data.index.VcsLogModifiableIndex;
import com.intellij.vcs.log.graph.GraphCommit;
import com.intellij.vcs.log.graph.GraphCommitImpl;
import com.intellij.vcs.log.graph.PermanentGraph;
import com.intellij.vcs.log.impl.RequirementsImpl;
import com.intellij.vcs.log.util.StopWatch;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsLogRefresherImpl
implements VcsLogRefresher,
Disposable {
    private static final Logger LOG = Logger.getInstance(VcsLogRefresherImpl.class);
    @NotNull
    private final Project myProject;
    @NotNull
    private final VcsLogStorage myStorage;
    @NotNull
    private final Map<VirtualFile, VcsLogProvider> myProviders;
    @NotNull
    private final VcsUserRegistryImpl myUserRegistry;
    @NotNull
    private final VcsLogModifiableIndex myIndex;
    @NotNull
    private final TopCommitsCache myTopCommitsDetailsCache;
    @NotNull
    private final Consumer<? super Exception> myExceptionHandler;
    @NotNull
    private final VcsLogProgress myProgress;
    private final int myRecentCommitCount;
    @NotNull
    private final SingleTaskController<RefreshRequest, DataPack> mySingleTaskController;
    @NotNull
    private volatile DataPack myDataPack;

    public VcsLogRefresherImpl(@NotNull Project project, @NotNull VcsLogStorage storage2, @NotNull Map<VirtualFile, VcsLogProvider> providers, @NotNull VcsUserRegistryImpl userRegistry, @NotNull VcsLogModifiableIndex index, @NotNull VcsLogProgress progress, @NotNull TopCommitsCache topCommitsDetailsCache, @NotNull Consumer<? super DataPack> dataPackUpdateHandler, @NotNull Consumer<? super Exception> exceptionHandler, int recentCommitsCount) {
        if (project == null) {
            VcsLogRefresherImpl.$$$reportNull$$$0(0);
        }
        if (storage2 == null) {
            VcsLogRefresherImpl.$$$reportNull$$$0(1);
        }
        if (providers == null) {
            VcsLogRefresherImpl.$$$reportNull$$$0(2);
        }
        if (userRegistry == null) {
            VcsLogRefresherImpl.$$$reportNull$$$0(3);
        }
        if (index == null) {
            VcsLogRefresherImpl.$$$reportNull$$$0(4);
        }
        if (progress == null) {
            VcsLogRefresherImpl.$$$reportNull$$$0(5);
        }
        if (topCommitsDetailsCache == null) {
            VcsLogRefresherImpl.$$$reportNull$$$0(6);
        }
        if (dataPackUpdateHandler == null) {
            VcsLogRefresherImpl.$$$reportNull$$$0(7);
        }
        if (exceptionHandler == null) {
            VcsLogRefresherImpl.$$$reportNull$$$0(8);
        }
        this.myDataPack = DataPack.EMPTY;
        this.myProject = project;
        this.myStorage = storage2;
        this.myProviders = providers;
        this.myUserRegistry = userRegistry;
        this.myIndex = index;
        this.myTopCommitsDetailsCache = topCommitsDetailsCache;
        this.myExceptionHandler = exceptionHandler;
        this.myRecentCommitCount = recentCommitsCount;
        this.myProgress = progress;
        this.mySingleTaskController = new SingleTaskController<RefreshRequest, DataPack>(this.myProject, "permanent", dataPack -> {
            if (dataPackUpdateHandler == null) {
                VcsLogRefresherImpl.$$$reportNull$$$0(30);
            }
            this.myDataPack = dataPack;
            dataPackUpdateHandler.consume(dataPack);
        }, false, (Disposable)this){

            @Override
            @NotNull
            protected SingleTaskController.SingleTask startNewBackgroundTask() {
                SingleTaskController.SingleTask singleTask = VcsLogRefresherImpl.this.startNewBackgroundTask(new MyRefreshTask(VcsLogRefresherImpl.this.myDataPack));
                if (singleTask == null) {
                    1.$$$reportNull$$$0(0);
                }
                return singleTask;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/VcsLogRefresherImpl$1", "startNewBackgroundTask"));
            }
        };
    }

    protected SingleTaskController.SingleTask startNewBackgroundTask(@NotNull Task.Backgroundable refreshTask) {
        if (refreshTask == null) {
            VcsLogRefresherImpl.$$$reportNull$$$0(9);
        }
        LOG.debug("Starting a background task...");
        ProgressIndicator indicator = this.myProgress.createProgressIndicator(VcsLogData.DATA_PACK_REFRESH);
        Future<?> future2 = ((CoreProgressManager)ProgressManager.getInstance()).runProcessWithProgressAsynchronously(refreshTask, indicator, null);
        return new SingleTaskController.SingleTaskImpl(future2, indicator);
    }

    @NotNull
    public DataPack getCurrentDataPack() {
        DataPack dataPack = this.myDataPack;
        if (dataPack == null) {
            VcsLogRefresherImpl.$$$reportNull$$$0(10);
        }
        return dataPack;
    }

    @Override
    @NotNull
    public DataPack readFirstBlock() {
        DataPack dataPack;
        try {
            LogInfo data = this.loadRecentData(new CommitCountRequirements(this.myRecentCommitCount).asMap(this.myProviders.keySet()));
            Collection commits = data.getCommits();
            Map<VirtualFile, CompressedRefs> refs = data.getRefs();
            List compoundList = VcsLogRefresherImpl.multiRepoJoin(commits);
            compoundList = compoundList.subList(0, Math.min(this.myRecentCommitCount, compoundList.size()));
            this.myDataPack = DataPack.build(compoundList, refs, this.myProviders, this.myStorage, false);
            this.mySingleTaskController.request((RefreshRequest[])new RefreshRequest[]{RefreshRequest.RELOAD_ALL});
            dataPack = this.myDataPack;
        }
        catch (VcsException e) {
            this.myExceptionHandler.consume((Object)e);
            DataPack dataPack2 = DataPack.EMPTY;
            if (dataPack2 == null) {
                VcsLogRefresherImpl.$$$reportNull$$$0(12);
            }
            return dataPack2;
        }
        if (dataPack == null) {
            VcsLogRefresherImpl.$$$reportNull$$$0(11);
        }
        return dataPack;
    }

    @NotNull
    private LogInfo loadRecentData(final @NotNull Map<VirtualFile, VcsLogProvider.Requirements> requirements) throws VcsException {
        if (requirements == null) {
            VcsLogRefresherImpl.$$$reportNull$$$0(13);
        }
        final StopWatch sw = StopWatch.start("loading commits");
        final LogInfo logInfo = new LogInfo(this.myStorage);
        new ProviderIterator(){

            @Override
            public void each(@NotNull VirtualFile root, @NotNull VcsLogProvider provider) throws VcsException {
                if (root == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (provider == null) {
                    2.$$$reportNull$$$0(1);
                }
                VcsLogProvider.DetailedLogData data = provider.readFirstBlock(root, (VcsLogProvider.Requirements)requirements.get(root));
                logInfo.put(root, VcsLogRefresherImpl.this.compactCommits(data.getCommits(), root));
                logInfo.put(root, data.getRefs());
                VcsLogRefresherImpl.this.storeUsersAndDetails(data.getCommits());
                sw.rootCompleted(root);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "root";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "provider";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/vcs/log/data/VcsLogRefresherImpl$2";
                objectArray[2] = "each";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }.iterate(this.getProvidersForRoots(requirements.keySet()));
        this.myUserRegistry.flush();
        this.myIndex.scheduleIndex(false);
        sw.report();
        LogInfo logInfo2 = logInfo;
        if (logInfo2 == null) {
            VcsLogRefresherImpl.$$$reportNull$$$0(14);
        }
        return logInfo2;
    }

    @NotNull
    private Map<VirtualFile, VcsLogProvider> getProvidersForRoots(@NotNull Set<VirtualFile> roots) {
        if (roots == null) {
            VcsLogRefresherImpl.$$$reportNull$$$0(15);
        }
        Map map = ContainerUtil.map2Map(roots, root -> Pair.create((Object)root, (Object)this.myProviders.get(root)));
        if (map == null) {
            VcsLogRefresherImpl.$$$reportNull$$$0(16);
        }
        return map;
    }

    @Override
    public void refresh(@NotNull Collection<VirtualFile> rootsToRefresh) {
        if (rootsToRefresh == null) {
            VcsLogRefresherImpl.$$$reportNull$$$0(17);
        }
        if (!rootsToRefresh.isEmpty()) {
            this.mySingleTaskController.request((RefreshRequest[])new RefreshRequest[]{new RefreshRequest(rootsToRefresh)});
        }
    }

    @NotNull
    private static <T extends GraphCommit<Integer>> List<T> multiRepoJoin(@NotNull Collection<List<T>> commits) {
        if (commits == null) {
            VcsLogRefresherImpl.$$$reportNull$$$0(18);
        }
        StopWatch sw = StopWatch.start("multi-repo join");
        List joined = new VcsLogMultiRepoJoiner().join(commits);
        sw.report();
        List list2 = joined;
        if (list2 == null) {
            VcsLogRefresherImpl.$$$reportNull$$$0(19);
        }
        return list2;
    }

    @NotNull
    private List<GraphCommit<Integer>> compactCommits(@NotNull List<? extends TimedVcsCommit> commits, @NotNull VirtualFile root) {
        if (commits == null) {
            VcsLogRefresherImpl.$$$reportNull$$$0(20);
        }
        if (root == null) {
            VcsLogRefresherImpl.$$$reportNull$$$0(21);
        }
        StopWatch sw = StopWatch.start("compacting commits");
        List map = ContainerUtil.map(commits, commit -> {
            if (root == null) {
                VcsLogRefresherImpl.$$$reportNull$$$0(29);
            }
            return this.compactCommit((TimedVcsCommit)commit, root);
        });
        this.myStorage.flush();
        sw.report();
        List list2 = map;
        if (list2 == null) {
            VcsLogRefresherImpl.$$$reportNull$$$0(22);
        }
        return list2;
    }

    @NotNull
    private GraphCommit<Integer> compactCommit(@NotNull TimedVcsCommit commit, @NotNull VirtualFile root) {
        if (commit == null) {
            VcsLogRefresherImpl.$$$reportNull$$$0(23);
        }
        if (root == null) {
            VcsLogRefresherImpl.$$$reportNull$$$0(24);
        }
        List parents = ContainerUtil.map((Collection)commit.getParents(), (Function)((NotNullFunction)hash -> {
            if (root == null) {
                VcsLogRefresherImpl.$$$reportNull$$$0(28);
            }
            return this.myStorage.getCommitIndex((Hash)hash, root);
        }));
        int index = this.myStorage.getCommitIndex((Hash)commit.getId(), root);
        this.myIndex.markForIndexing(index, root);
        GraphCommit<Integer> graphCommit = GraphCommitImpl.createIntCommit(index, parents, commit.getTimestamp());
        if (graphCommit == null) {
            VcsLogRefresherImpl.$$$reportNull$$$0(25);
        }
        return graphCommit;
    }

    private void storeUsersAndDetails(@NotNull List<? extends VcsCommitMetadata> metadatas) {
        if (metadatas == null) {
            VcsLogRefresherImpl.$$$reportNull$$$0(26);
        }
        for (VcsCommitMetadata vcsCommitMetadata : metadatas) {
            this.myUserRegistry.addUser(vcsCommitMetadata.getAuthor());
            this.myUserRegistry.addUser(vcsCommitMetadata.getCommitter());
        }
        this.myTopCommitsDetailsCache.storeDetails(metadatas);
    }

    @NotNull
    public VcsLogProgress getProgress() {
        VcsLogProgress vcsLogProgress = this.myProgress;
        if (vcsLogProgress == null) {
            VcsLogRefresherImpl.$$$reportNull$$$0(27);
        }
        return vcsLogProgress;
    }

    public void dispose() {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 16: 
            case 19: 
            case 22: 
            case 25: 
            case 27: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 16: 
            case 19: 
            case 22: 
            case 25: 
            case 27: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "storage";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "providers";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "userRegistry";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "index";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progress";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "topCommitsDetailsCache";
                break;
            }
            case 7: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataPackUpdateHandler";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exceptionHandler";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refreshTask";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 16: 
            case 19: 
            case 22: 
            case 25: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/data/VcsLogRefresherImpl";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requirements";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "roots";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootsToRefresh";
                break;
            }
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commits";
                break;
            }
            case 21: 
            case 24: 
            case 28: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commit";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "metadatas";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/data/VcsLogRefresherImpl";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentDataPack";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "readFirstBlock";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "loadRecentData";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getProvidersForRoots";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "multiRepoJoin";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "compactCommits";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "compactCommit";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getProgress";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "startNewBackgroundTask";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 16: 
            case 19: 
            case 22: 
            case 25: 
            case 27: {
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "loadRecentData";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getProvidersForRoots";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "refresh";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "multiRepoJoin";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "compactCommits";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "compactCommit";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "storeUsersAndDetails";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "lambda$compactCommit$3";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "lambda$compactCommits$2";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "lambda$new$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 16: 
            case 19: 
            case 22: 
            case 25: 
            case 27: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class LogInfo {
        private final VcsLogStorage myStorage;
        private final Map<VirtualFile, CompressedRefs> myRefs = ContainerUtil.newHashMap();
        private final Map<VirtualFile, List<GraphCommit<Integer>>> myCommits = ContainerUtil.newHashMap();

        LogInfo(VcsLogStorage storage2) {
            this.myStorage = storage2;
        }

        void put(@NotNull VirtualFile root, @NotNull List<GraphCommit<Integer>> commits) {
            if (root == null) {
                LogInfo.$$$reportNull$$$0(0);
            }
            if (commits == null) {
                LogInfo.$$$reportNull$$$0(1);
            }
            this.myCommits.put(root, commits);
        }

        void put(@NotNull VirtualFile root, @NotNull Set<VcsRef> refs) {
            if (root == null) {
                LogInfo.$$$reportNull$$$0(2);
            }
            if (refs == null) {
                LogInfo.$$$reportNull$$$0(3);
            }
            this.myRefs.put(root, new CompressedRefs(refs, this.myStorage));
        }

        void put(@NotNull VirtualFile root, @NotNull CompressedRefs refs) {
            if (root == null) {
                LogInfo.$$$reportNull$$$0(4);
            }
            if (refs == null) {
                LogInfo.$$$reportNull$$$0(5);
            }
            this.myRefs.put(root, refs);
        }

        @NotNull
        Collection<List<GraphCommit<Integer>>> getCommits() {
            Collection<List<GraphCommit<Integer>>> collection = this.myCommits.values();
            if (collection == null) {
                LogInfo.$$$reportNull$$$0(6);
            }
            return collection;
        }

        List<GraphCommit<Integer>> getCommits(@NotNull VirtualFile root) {
            if (root == null) {
                LogInfo.$$$reportNull$$$0(7);
            }
            return this.myCommits.get(root);
        }

        @NotNull
        Map<VirtualFile, CompressedRefs> getRefs() {
            Map<VirtualFile, CompressedRefs> map = this.myRefs;
            if (map == null) {
                LogInfo.$$$reportNull$$$0(8);
            }
            return map;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 6: 
                case 8: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 6: 
                case 8: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "root";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "commits";
                    break;
                }
                case 3: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "refs";
                    break;
                }
                case 6: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/vcs/log/data/VcsLogRefresherImpl$LogInfo";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/vcs/log/data/VcsLogRefresherImpl$LogInfo";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCommits";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRefs";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "put";
                    break;
                }
                case 6: 
                case 8: {
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "getCommits";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 6: 
                case 8: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class CommitCountRequirements
    implements VcsLogProvider.Requirements {
        private final int myCommitCount;

        CommitCountRequirements(int commitCount) {
            this.myCommitCount = commitCount;
        }

        public int getCommitCount() {
            return this.myCommitCount;
        }

        @NotNull
        Map<VirtualFile, VcsLogProvider.Requirements> asMap(@NotNull Collection<VirtualFile> roots) {
            if (roots == null) {
                CommitCountRequirements.$$$reportNull$$$0(0);
            }
            Map map = ContainerUtil.map2Map(roots, root -> Pair.create((Object)root, (Object)this));
            if (map == null) {
                CommitCountRequirements.$$$reportNull$$$0(1);
            }
            return map;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "roots";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/vcs/log/data/VcsLogRefresherImpl$CommitCountRequirements";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/vcs/log/data/VcsLogRefresherImpl$CommitCountRequirements";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "asMap";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "asMap";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static abstract class ProviderIterator {
        private ProviderIterator() {
        }

        abstract void each(@NotNull VirtualFile var1, @NotNull VcsLogProvider var2) throws VcsException;

        final void iterate(@NotNull Map<VirtualFile, VcsLogProvider> providers) throws VcsException {
            if (providers == null) {
                ProviderIterator.$$$reportNull$$$0(0);
            }
            for (Map.Entry<VirtualFile, VcsLogProvider> entry : providers.entrySet()) {
                this.each(entry.getKey(), entry.getValue());
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "providers", "com/intellij/vcs/log/data/VcsLogRefresherImpl$ProviderIterator", "iterate"));
        }
    }

    private static class RefreshRequest {
        private static final RefreshRequest RELOAD_ALL = new RefreshRequest((Collection)Collections.emptyList()){

            @Override
            public String toString() {
                return "RELOAD_ALL";
            }
        };
        private final Collection<VirtualFile> rootsToRefresh;

        RefreshRequest(@NotNull Collection<VirtualFile> rootsToRefresh) {
            if (rootsToRefresh == null) {
                RefreshRequest.$$$reportNull$$$0(0);
            }
            this.rootsToRefresh = rootsToRefresh;
        }

        public String toString() {
            return "{" + this.rootsToRefresh + "}";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootsToRefresh", "com/intellij/vcs/log/data/VcsLogRefresherImpl$RefreshRequest", "<init>"));
        }
    }

    private class MyRefreshTask
    extends Task.Backgroundable {
        @NotNull
        private DataPack myCurrentDataPack;
        @NotNull
        private final LogInfo myLoadedInfo;

        MyRefreshTask(DataPack currentDataPack) {
            if (currentDataPack == null) {
                MyRefreshTask.$$$reportNull$$$0(0);
            }
            super(VcsLogRefresherImpl.this.myProject, "Refreshing History...", false);
            this.myLoadedInfo = new LogInfo(VcsLogRefresherImpl.this.myStorage);
            this.myCurrentDataPack = currentDataPack;
        }

        public void run(@NotNull ProgressIndicator indicator) {
            if (indicator == null) {
                MyRefreshTask.$$$reportNull$$$0(1);
            }
            LOG.debug("Refresh task started");
            indicator.setIndeterminate(true);
            DataPack dataPack = this.myCurrentDataPack;
            while (true) {
                List<RefreshRequest> requests = VcsLogRefresherImpl.this.mySingleTaskController.popRequests();
                Collection<VirtualFile> rootsToRefresh = this.getRootsToRefresh(requests);
                LOG.debug("Requests: " + requests + ". roots to refresh: " + rootsToRefresh);
                if (rootsToRefresh.isEmpty()) break;
                dataPack = this.doRefresh(rootsToRefresh);
            }
            VcsLogRefresherImpl.this.mySingleTaskController.taskCompleted(dataPack);
        }

        @NotNull
        private Collection<VirtualFile> getRootsToRefresh(@NotNull List<RefreshRequest> requests) {
            if (requests == null) {
                MyRefreshTask.$$$reportNull$$$0(2);
            }
            ArrayList rootsToRefresh = ContainerUtil.newArrayList();
            for (RefreshRequest request : requests) {
                if (request == RefreshRequest.RELOAD_ALL) {
                    this.myCurrentDataPack = DataPack.EMPTY;
                    Set<VirtualFile> set = VcsLogRefresherImpl.this.myProviders.keySet();
                    if (set == null) {
                        MyRefreshTask.$$$reportNull$$$0(3);
                    }
                    return set;
                }
                rootsToRefresh.addAll(request.rootsToRefresh);
            }
            ArrayList arrayList = rootsToRefresh;
            if (arrayList == null) {
                MyRefreshTask.$$$reportNull$$$0(4);
            }
            return arrayList;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @NotNull
        private DataPack doRefresh(@NotNull Collection<VirtualFile> roots) {
            DataPack dataPack;
            StopWatch sw;
            block14: {
                DataPack dataPack2;
                block13: {
                    if (roots == null) {
                        MyRefreshTask.$$$reportNull$$$0(5);
                    }
                    sw = StopWatch.start("refresh");
                    PermanentGraph<Integer> permanentGraph = this.myCurrentDataPack.isFull() ? this.myCurrentDataPack.getPermanentGraph() : null;
                    Map<VirtualFile, CompressedRefs> currentRefs = this.myCurrentDataPack.getRefsModel().getAllRefsByRoot();
                    try {
                        if (permanentGraph != null) {
                            int commitCount = VcsLogRefresherImpl.this.myRecentCommitCount;
                            for (int attempt = 0; attempt <= 1; commitCount *= 5, ++attempt) {
                                this.loadLogAndRefs(roots, currentRefs, commitCount);
                                List compoundLog = VcsLogRefresherImpl.multiRepoJoin(this.myLoadedInfo.getCommits());
                                Map<VirtualFile, CompressedRefs> allNewRefs = this.getAllNewRefs(this.myLoadedInfo, currentRefs);
                                List<? extends GraphCommit<Integer>> joinedFullLog = this.join(compoundLog, ContainerUtil.newArrayList((Iterable)permanentGraph.getAllCommits()), currentRefs, allNewRefs);
                                if (joinedFullLog == null) {
                                    continue;
                                }
                                DataPack dataPack3 = DataPack.build(joinedFullLog, allNewRefs, VcsLogRefresherImpl.this.myProviders, VcsLogRefresherImpl.this.myStorage, true);
                                dataPack2 = dataPack3;
                                break block13;
                            }
                            LOG.info("Couldn't join " + commitCount / 5 + " recent commits to the log (" + permanentGraph.getAllCommits().size() + " commits)");
                        }
                        DataPack commitCount = this.loadFullLog();
                        dataPack = commitCount;
                        break block14;
                    }
                    catch (Exception e) {
                        VcsLogRefresherImpl.this.myExceptionHandler.consume((Object)e);
                        DataPack dataPack4 = DataPack.EMPTY;
                        DataPack dataPack5 = dataPack4;
                        if (dataPack5 == null) {
                            MyRefreshTask.$$$reportNull$$$0(8);
                        }
                        return dataPack5;
                    }
                }
                if (dataPack2 == null) {
                    MyRefreshTask.$$$reportNull$$$0(6);
                }
                return dataPack2;
            }
            if (dataPack == null) {
                MyRefreshTask.$$$reportNull$$$0(7);
            }
            return dataPack;
            finally {
                sw.report();
            }
        }

        @NotNull
        private Map<VirtualFile, CompressedRefs> getAllNewRefs(@NotNull LogInfo newInfo, @NotNull Map<VirtualFile, CompressedRefs> previousRefs) {
            if (newInfo == null) {
                MyRefreshTask.$$$reportNull$$$0(9);
            }
            if (previousRefs == null) {
                MyRefreshTask.$$$reportNull$$$0(10);
            }
            HashMap result2 = ContainerUtil.newHashMap();
            for (VirtualFile root : previousRefs.keySet()) {
                CompressedRefs newInfoRefs = newInfo.getRefs().get(root);
                result2.put(root, newInfoRefs != null ? newInfoRefs : previousRefs.get(root));
            }
            HashMap hashMap = result2;
            if (hashMap == null) {
                MyRefreshTask.$$$reportNull$$$0(11);
            }
            return hashMap;
        }

        private void loadLogAndRefs(@NotNull Collection<VirtualFile> roots, @NotNull Map<VirtualFile, CompressedRefs> prevRefs, int commitCount) throws VcsException {
            if (roots == null) {
                MyRefreshTask.$$$reportNull$$$0(12);
            }
            if (prevRefs == null) {
                MyRefreshTask.$$$reportNull$$$0(13);
            }
            LogInfo logInfo = VcsLogRefresherImpl.this.loadRecentData(this.prepareRequirements(roots, commitCount, prevRefs));
            for (VirtualFile root : roots) {
                this.myLoadedInfo.put(root, logInfo.getCommits(root));
                this.myLoadedInfo.put(root, logInfo.getRefs().get(root));
            }
        }

        @NotNull
        private Map<VirtualFile, VcsLogProvider.Requirements> prepareRequirements(@NotNull Collection<VirtualFile> roots, int commitCount, @NotNull Map<VirtualFile, CompressedRefs> prevRefs) {
            if (roots == null) {
                MyRefreshTask.$$$reportNull$$$0(14);
            }
            if (prevRefs == null) {
                MyRefreshTask.$$$reportNull$$$0(15);
            }
            HashMap requirements = ContainerUtil.newHashMap();
            for (VirtualFile root : roots) {
                requirements.put(root, new RequirementsImpl(commitCount, true, prevRefs.get(root).getRefs()));
            }
            HashMap hashMap = requirements;
            if (hashMap == null) {
                MyRefreshTask.$$$reportNull$$$0(16);
            }
            return hashMap;
        }

        @Nullable
        private List<? extends GraphCommit<Integer>> join(@NotNull List<? extends GraphCommit<Integer>> recentCommits, @NotNull List<GraphCommit<Integer>> fullLog, @NotNull Map<VirtualFile, CompressedRefs> previousRefs, @NotNull Map<VirtualFile, CompressedRefs> newRefs) {
            if (recentCommits == null) {
                MyRefreshTask.$$$reportNull$$$0(17);
            }
            if (fullLog == null) {
                MyRefreshTask.$$$reportNull$$$0(18);
            }
            if (previousRefs == null) {
                MyRefreshTask.$$$reportNull$$$0(19);
            }
            if (newRefs == null) {
                MyRefreshTask.$$$reportNull$$$0(20);
            }
            if (fullLog.isEmpty()) {
                return recentCommits;
            }
            StopWatch sw = StopWatch.start("joining new commits");
            Collection prevRefIndices = previousRefs.values().stream().flatMap(refs -> refs.getCommits().stream()).collect(Collectors.toSet());
            Collection newRefIndices = newRefs.values().stream().flatMap(refs -> refs.getCommits().stream()).collect(Collectors.toSet());
            try {
                List commits = (List)new VcsLogJoiner<CommitId, GraphCommit<Integer>>().addCommits(fullLog, prevRefIndices, recentCommits, newRefIndices).first;
                sw.report();
                return commits;
            }
            catch (VcsLogRefreshNotEnoughDataException e) {
                LOG.info((Throwable)e);
            }
            catch (IllegalStateException e) {
                LOG.info((Throwable)e);
            }
            return null;
        }

        @NotNull
        private DataPack loadFullLog() throws VcsException {
            StopWatch sw = StopWatch.start("full log reload");
            LogInfo logInfo = this.readFullLogFromVcs();
            List graphCommits = VcsLogRefresherImpl.multiRepoJoin(logInfo.getCommits());
            DataPack dataPack = DataPack.build(graphCommits, logInfo.getRefs(), VcsLogRefresherImpl.this.myProviders, VcsLogRefresherImpl.this.myStorage, true);
            sw.report();
            DataPack dataPack2 = dataPack;
            if (dataPack2 == null) {
                MyRefreshTask.$$$reportNull$$$0(21);
            }
            return dataPack2;
        }

        @NotNull
        private LogInfo readFullLogFromVcs() throws VcsException {
            final StopWatch sw = StopWatch.start("read full log from VCS");
            final LogInfo logInfo = new LogInfo(VcsLogRefresherImpl.this.myStorage);
            new ProviderIterator(){

                @Override
                void each(@NotNull VirtualFile root, @NotNull VcsLogProvider provider) throws VcsException {
                    if (root == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (provider == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    ArrayList graphCommits = ContainerUtil.newArrayList();
                    VcsLogProvider.LogData data = provider.readAllHashes(root, commit -> {
                        if (root == null) {
                            1.$$$reportNull$$$0(2);
                        }
                        graphCommits.add(VcsLogRefresherImpl.this.compactCommit(commit, root));
                    });
                    logInfo.put(root, graphCommits);
                    logInfo.put(root, data.getRefs());
                    VcsLogRefresherImpl.this.myUserRegistry.addUsers(data.getUsers());
                    sw.rootCompleted(root);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "root";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "provider";
                            break;
                        }
                    }
                    objectArray2[1] = "com/intellij/vcs/log/data/VcsLogRefresherImpl$MyRefreshTask$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "each";
                            break;
                        }
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[2] = "lambda$each$0";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            }.iterate(VcsLogRefresherImpl.this.myProviders);
            VcsLogRefresherImpl.this.myUserRegistry.flush();
            VcsLogRefresherImpl.this.myIndex.scheduleIndex(true);
            sw.report();
            LogInfo logInfo2 = logInfo;
            if (logInfo2 == null) {
                MyRefreshTask.$$$reportNull$$$0(22);
            }
            return logInfo2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 4: 
                case 6: 
                case 7: 
                case 8: 
                case 11: 
                case 16: 
                case 21: 
                case 22: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 4: 
                case 6: 
                case 7: 
                case 8: 
                case 11: 
                case 16: 
                case 21: 
                case 22: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "currentDataPack";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indicator";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "requests";
                    break;
                }
                case 3: 
                case 4: 
                case 6: 
                case 7: 
                case 8: 
                case 11: 
                case 16: 
                case 21: 
                case 22: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/vcs/log/data/VcsLogRefresherImpl$MyRefreshTask";
                    break;
                }
                case 5: 
                case 12: 
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "roots";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newInfo";
                    break;
                }
                case 10: 
                case 19: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "previousRefs";
                    break;
                }
                case 13: 
                case 15: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "prevRefs";
                    break;
                }
                case 17: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "recentCommits";
                    break;
                }
                case 18: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fullLog";
                    break;
                }
                case 20: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newRefs";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/vcs/log/data/VcsLogRefresherImpl$MyRefreshTask";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRootsToRefresh";
                    break;
                }
                case 6: 
                case 7: 
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "doRefresh";
                    break;
                }
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAllNewRefs";
                    break;
                }
                case 16: {
                    objectArray = objectArray2;
                    objectArray2[1] = "prepareRequirements";
                    break;
                }
                case 21: {
                    objectArray = objectArray2;
                    objectArray2[1] = "loadFullLog";
                    break;
                }
                case 22: {
                    objectArray = objectArray2;
                    objectArray2[1] = "readFullLogFromVcs";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "run";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getRootsToRefresh";
                    break;
                }
                case 3: 
                case 4: 
                case 6: 
                case 7: 
                case 8: 
                case 11: 
                case 16: 
                case 21: 
                case 22: {
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "doRefresh";
                    break;
                }
                case 9: 
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "getAllNewRefs";
                    break;
                }
                case 12: 
                case 13: {
                    objectArray = objectArray;
                    objectArray[2] = "loadLogAndRefs";
                    break;
                }
                case 14: 
                case 15: {
                    objectArray = objectArray;
                    objectArray[2] = "prepareRequirements";
                    break;
                }
                case 17: 
                case 18: 
                case 19: 
                case 20: {
                    objectArray = objectArray;
                    objectArray[2] = "join";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 4: 
                case 6: 
                case 7: 
                case 8: 
                case 11: 
                case 16: 
                case 21: 
                case 22: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

