/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic;

import com.intellij.diagnostic.DiagnosticBundle;
import com.intellij.diagnostic.MessagePool;
import com.intellij.icons.AllIcons;
import com.intellij.ui.AnimatedIcon;
import com.intellij.util.ui.EmptyIcon;
import java.awt.Cursor;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JLabel;

class IdeErrorsIcon
extends JLabel {
    private final Icon myReadIcon = AllIcons.Ide.FatalError_read;
    private final Icon myUnreadIcon;

    IdeErrorsIcon(boolean enableBlink) {
        this.myUnreadIcon = !enableBlink ? AllIcons.Ide.FatalError : new AnimatedIcon.Blinking(AllIcons.Ide.FatalError);
        this.setBorder(BorderFactory.createEmptyBorder(0, 1, 0, 1));
    }

    void setState(MessagePool.State state) {
        if (state != null && state != MessagePool.State.NoErrors) {
            this.setIcon(state == MessagePool.State.ReadErrors ? this.myReadIcon : this.myUnreadIcon);
            this.setCursor(Cursor.getPredefinedCursor(12));
            this.setToolTipText(DiagnosticBundle.message("error.notification.tooltip", new Object[0]));
        } else {
            this.setIcon(EmptyIcon.ICON_16);
            this.setCursor(Cursor.getPredefinedCursor(0));
            this.setToolTipText(null);
        }
    }
}

