/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types;

import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.lang.javascript.psi.JSResolvedTypeId;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.util.Getter;
import com.intellij.openapi.util.Key;
import com.intellij.util.ProcessingContext;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class JSRecursiveTypeUtil {
    public static final Key<Map<JSResolvedTypeId, Set<JSResolvedTypeId>>> ASSIGNABLE_KEY = Key.create((String)"already.compared.types");
    public static final Key<Map<JSResolvedTypeId, Set<JSResolvedTypeId>>> GENERICS_SUBSTITUTION = Key.create((String)"generics.compared.types");
    private static final int MAX_RECURSIVE_TYPE_COMPARING_DEPTH = 100;
    private static final Logger LOG = Logger.getInstance(JSRecursiveTypeUtil.class);

    public static boolean startRecursiveTypesComparison(@NotNull JSResolvedTypeId thisTypeId, @NotNull JSResolvedTypeId elementTypeId, @NotNull Key<Map<JSResolvedTypeId, Set<JSResolvedTypeId>>> key, @NotNull ProcessingContext processingContext) {
        if (thisTypeId == null) {
            JSRecursiveTypeUtil.$$$reportNull$$$0(0);
        }
        if (elementTypeId == null) {
            JSRecursiveTypeUtil.$$$reportNull$$$0(1);
        }
        if (key == null) {
            JSRecursiveTypeUtil.$$$reportNull$$$0(2);
        }
        if (processingContext == null) {
            JSRecursiveTypeUtil.$$$reportNull$$$0(3);
        }
        ProgressIndicatorProvider.checkCanceled();
        Map alreadyComparedTypes = (Map)processingContext.get(key);
        if (alreadyComparedTypes == null) {
            alreadyComparedTypes = new THashMap();
            processingContext.put(key, (Object)alreadyComparedTypes);
        } else if (alreadyComparedTypes.size() > 100) {
            return JSRecursiveTypeUtil.logOverflowError(thisTypeId, elementTypeId);
        }
        Set typesComparedToThis = (Set)alreadyComparedTypes.get(thisTypeId);
        if (typesComparedToThis == null) {
            THashSet set = new THashSet();
            set.add((Object)elementTypeId);
            alreadyComparedTypes.put(thisTypeId, set);
            return true;
        }
        if (typesComparedToThis.size() > 100) {
            return JSRecursiveTypeUtil.logOverflowError(thisTypeId, elementTypeId);
        }
        return typesComparedToThis.add(elementTypeId);
    }

    private static boolean logOverflowError(@NotNull JSResolvedTypeId thisTypeId, @NotNull JSResolvedTypeId elementTypeId) {
        boolean shouldLogError;
        if (thisTypeId == null) {
            JSRecursiveTypeUtil.$$$reportNull$$$0(4);
        }
        if (elementTypeId == null) {
            JSRecursiveTypeUtil.$$$reportNull$$$0(5);
        }
        boolean bl = shouldLogError = ApplicationManager.getApplication().isUnitTestMode() || PluginManagerCore.isRunningFromSources();
        if (shouldLogError || LOG.isDebugEnabled()) {
            JSType lType = thisTypeId.getOwnerType();
            JSType rType = elementTypeId.getOwnerType();
            String message = "Too deep type comparing: " + lType.getTypeText() + ", " + rType.getTypeText();
            if (shouldLogError) {
                LOG.error(message);
            } else {
                LOG.debug(message);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean computeWithRecursiveTypes(@NotNull JSResolvedTypeId id1, @NotNull JSResolvedTypeId id2, @NotNull Key<Map<JSResolvedTypeId, Set<JSResolvedTypeId>>> key, @NotNull ProcessingContext context, @NotNull Getter<Boolean> operation) {
        if (id1 == null) {
            JSRecursiveTypeUtil.$$$reportNull$$$0(6);
        }
        if (id2 == null) {
            JSRecursiveTypeUtil.$$$reportNull$$$0(7);
        }
        if (key == null) {
            JSRecursiveTypeUtil.$$$reportNull$$$0(8);
        }
        if (context == null) {
            JSRecursiveTypeUtil.$$$reportNull$$$0(9);
        }
        if (operation == null) {
            JSRecursiveTypeUtil.$$$reportNull$$$0(10);
        }
        if (!JSRecursiveTypeUtil.startRecursiveTypesComparison(id1, id2, key, context)) {
            return true;
        }
        try {
            boolean bl = (Boolean)operation.get();
            return bl;
        }
        finally {
            JSRecursiveTypeUtil.endRecursiveTypesComparison(id1, id2, key, context);
        }
    }

    public static void endRecursiveTypesComparison(@NotNull JSResolvedTypeId thisTypeId, @NotNull JSResolvedTypeId elementTypeId, @NotNull Key<Map<JSResolvedTypeId, Set<JSResolvedTypeId>>> key, @NotNull ProcessingContext processingContext) {
        Set keys;
        Map alreadyComparedTypes;
        if (thisTypeId == null) {
            JSRecursiveTypeUtil.$$$reportNull$$$0(11);
        }
        if (elementTypeId == null) {
            JSRecursiveTypeUtil.$$$reportNull$$$0(12);
        }
        if (key == null) {
            JSRecursiveTypeUtil.$$$reportNull$$$0(13);
        }
        if (processingContext == null) {
            JSRecursiveTypeUtil.$$$reportNull$$$0(14);
        }
        if ((alreadyComparedTypes = (Map)processingContext.get(key)) != null && (keys = (Set)alreadyComparedTypes.get(thisTypeId)) != null) {
            keys.remove(elementTypeId);
            if (keys.isEmpty()) {
                alreadyComparedTypes.remove(thisTypeId);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "thisTypeId";
                break;
            }
            case 1: 
            case 5: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementTypeId";
                break;
            }
            case 2: 
            case 8: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 3: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processingContext";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id1";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id2";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "operation";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/psi/types/JSRecursiveTypeUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "startRecursiveTypesComparison";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "logOverflowError";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "computeWithRecursiveTypes";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "endRecursiveTypesComparison";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

