/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2.actions.update;

import com.intellij.cvsSupport2.actions.update.UpdateSettings;
import com.intellij.cvsSupport2.config.CvsConfiguration;
import com.intellij.cvsSupport2.config.DateOrRevisionSettings;
import com.intellij.cvsSupport2.cvsoperations.dateOrRevision.RevisionOrDate;
import com.intellij.cvsSupport2.cvsoperations.dateOrRevision.RevisionOrDateImpl;
import com.intellij.cvsSupport2.keywordSubstitution.KeywordSubstitutionWrapper;
import org.netbeans.lib.cvsclient.command.KeywordSubstitution;

public class UpdateSettingsOnCvsConfiguration
implements UpdateSettings {
    private final boolean myCleanCopy;
    private final CvsConfiguration myConfiguration;
    private final boolean myResetSticky;

    public UpdateSettingsOnCvsConfiguration(boolean pruneEmptyDirectories, int mergingMode, String mergeWithBranchOneName, String mergeWithBranchTwoName, boolean createNewDirectories, String updateKeyboardSubstitution, DateOrRevisionSettings updateDateOrRevisionSettings, boolean makeNewFilesReadonly, boolean cleanCopy, boolean resetSticky) {
        this.myCleanCopy = cleanCopy;
        this.myResetSticky = resetSticky;
        this.myConfiguration = new CvsConfiguration();
        this.myConfiguration.PRUNE_EMPTY_DIRECTORIES = pruneEmptyDirectories;
        this.myConfiguration.MERGING_MODE = mergingMode;
        this.myConfiguration.MERGE_WITH_BRANCH1_NAME = mergeWithBranchOneName;
        this.myConfiguration.MERGE_WITH_BRANCH2_NAME = mergeWithBranchTwoName;
        this.myConfiguration.CREATE_NEW_DIRECTORIES = createNewDirectories;
        this.myConfiguration.UPDATE_KEYWORD_SUBSTITUTION = updateKeyboardSubstitution;
        this.myConfiguration.UPDATE_DATE_OR_REVISION_SETTINGS = updateDateOrRevisionSettings;
        this.myConfiguration.MAKE_NEW_FILES_READONLY = makeNewFilesReadonly;
    }

    public UpdateSettingsOnCvsConfiguration(CvsConfiguration configuration, boolean cleanCopy, boolean resetSticky) {
        this.myCleanCopy = cleanCopy;
        this.myConfiguration = configuration;
        this.myResetSticky = resetSticky;
    }

    @Override
    public boolean getPruneEmptyDirectories() {
        return this.myConfiguration.PRUNE_EMPTY_DIRECTORIES;
    }

    @Override
    public String getBranch1ToMergeWith() {
        if (this.myConfiguration.MERGING_MODE == 0) {
            return null;
        }
        return this.myConfiguration.MERGE_WITH_BRANCH1_NAME;
    }

    @Override
    public String getBranch2ToMergeWith() {
        if (this.myConfiguration.MERGING_MODE == 0) {
            return null;
        }
        if (this.myConfiguration.MERGING_MODE == 1) {
            return null;
        }
        return this.myConfiguration.MERGE_WITH_BRANCH2_NAME;
    }

    @Override
    public boolean getResetAllSticky() {
        return this.myResetSticky;
    }

    @Override
    public boolean getDontMakeAnyChanges() {
        return false;
    }

    @Override
    public boolean getCreateDirectories() {
        return this.myConfiguration.CREATE_NEW_DIRECTORIES;
    }

    @Override
    public boolean getCleanCopy() {
        return this.myCleanCopy;
    }

    @Override
    public KeywordSubstitution getKeywordSubstitution() {
        KeywordSubstitutionWrapper value = KeywordSubstitutionWrapper.getValue(this.myConfiguration.UPDATE_KEYWORD_SUBSTITUTION);
        if (value == null) {
            return null;
        }
        return value.getSubstitution();
    }

    @Override
    public RevisionOrDate getRevisionOrDate() {
        return RevisionOrDateImpl.createOn(this.myConfiguration.UPDATE_DATE_OR_REVISION_SETTINGS);
    }

    @Override
    public boolean getMakeNewFilesReadOnly() {
        return this.myConfiguration.MAKE_NEW_FILES_READONLY;
    }
}

