/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.testing.testunit.runConfigurations;

import b.h.la;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.text.VersionComparatorUtil;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.gem.GemInfo;
import org.jetbrains.plugins.ruby.gem.GemUtil;
import org.jetbrains.plugins.ruby.gem.util.GemSearchUtil;
import org.jetbrains.plugins.ruby.ruby.RModuleUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.Type;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.SymbolUtil;
import org.jetbrains.plugins.ruby.ruby.interpret.PsiCallable;
import org.jetbrains.plugins.ruby.ruby.interpret.RCallArguments;
import org.jetbrains.plugins.ruby.ruby.interpret.RubyPsiInterpreter;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPossibleCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RMethod;
import org.jetbrains.plugins.ruby.ruby.lang.psi.iterators.RBlockCall;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkUtil;
import org.jetbrains.plugins.ruby.testing.rspec.RSpecUtil;

public class TestUnitUtil {
    @NonNls
    private static final String e = "test_";
    @NonNls
    static final String ACTIVE_SUPPORT_TEST_CLOSURE_SHORT_NAME = "test";
    @NonNls
    static final String ACTIVE_SUPPORT_TEST_SETUP_SHORT_NAME = "setup";
    @NonNls
    static final String ACTIVE_SUPPORT_TEST_TEARDOWN_SHORT_NAME = "teardown";
    @NonNls
    private static final Set<String> d;
    public static final Set<String> TEST_SETUP_TEARDOWN_CALLS_SHORT_NAMES;
    @NonNls
    public static final Set<String> MINITEST_GROUP_CALL_SHORT_NAMES;
    @NonNls
    public static final Set<String> MINITEST_EXAMPLE_CALL_SHORT_NAMES;
    @NonNls
    public static final Set<String> MINITEST_SETUP_TEARDOWN_CALL_SHORT_NAMES;
    public static final Set<String> MINITEST_INSTANCE_CONTEXT_CALLS_SHORT_NAMES;
    public static final String TUNIT_TEST_FILE_PREFIX = "test_";
    public static final String TEST_UNIT_GEM_NAME = "test-unit";
    public static final String MINITEST_GEM_NAME = "minitest";
    public static final String MINITEST_REPORTERS_GEM_NAME = "minitest-reporters";
    public static final String MINITEST_RAILS_GEM_NAME = "minitest-rails";
    private static final String[] b;
    private static final String[] c;
    public static final String GENERATORS_R30_PREFIX = "test_unit:";
    private static final String a = "/test_\\d+_";
    private static final long f;

    private TestUnitUtil() {
    }

    public static boolean isInActiveSupportTestClosureBlock(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            TestUnitUtil.a(0);
        }
        return RubyPsiInterpreter.getSimpleCoveringCodeBlockScope(psiElement, d, null) != null;
    }

    public static boolean isInActiveSupportTestClosureRegion(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            TestUnitUtil.a(1);
        }
        return RubyPsiInterpreter.isInCallScope(psiElement, d, null);
    }

    public static boolean isInMiniTestSpecExampleOrGroupRegion(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            TestUnitUtil.a(2);
        }
        return RubyPsiInterpreter.isInCallScope(psiElement, MINITEST_EXAMPLE_CALL_SHORT_NAMES, null);
    }

    public static boolean isTestUnitFile(Project project, @Nullable VirtualFile file) {
        if (!TestUnitUtil.isFileWithValidTestUnitFileName(file)) {
            return false;
        }
        return TestUnitUtil.isTestUnitSupportLoaded(project);
    }

    public static boolean isTestUnitSupportLoaded(Project project) {
        long l2 = f ^ 0x2F690A290153L;
        return SymbolUtil.findConstantByFQN(project, Type.CLASS, "Test::Unit::TestCase", null) != null;
    }

    @Nullable
    public static Pair<String, String> determineCurrentTestNameAndFilterByMiniTestClosure(@NotNull PsiElement psiElement) {
        long l2 = f ^ 0x50BC3DEBDA5DL;
        if (psiElement == null) {
            TestUnitUtil.a(3);
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)psiElement);
        assert (module != null) : "Module must not be null here";
        assert (RModuleUtil.getInstance().hasRubySupport(module)) : "Current module must has ruby support";
        final String string = TestUnitUtil.a(module);
        final Ref ref = new Ref();
        PsiCallable psiCallable = new PsiCallable(){
            private static final long a = la.a(4156195455470222279L, -7297905949794714097L, MethodHandles.lookup().lookupClass()).a(130171373641533L);

            @Override
            public void processCall(RCallArguments arguments) {
                long l2 = a ^ 0xEDD1C06919BL;
                String string4 = arguments.evaluateArgument(0);
                if (string4 != null) {
                    if (VersionComparatorUtil.compare((String)string, (String)"3.1.0") < 0) {
                        String string2 = TestUnitUtil.a + string4.replaceAll("\\W+", "_").toLowerCase() + "/";
                        ref.set((Object)Pair.create((Object)string4, (Object)string2));
                    } else {
                        String string3 = TestUnitUtil.a + string4 + "/";
                        ref.set((Object)Pair.create((Object)string4, (Object)string3));
                    }
                }
            }
        };
        TestUnitUtil.a(psiElement, psiCallable, ArrayUtil.toStringArray(MINITEST_EXAMPLE_CALL_SHORT_NAMES));
        return (Pair)ref.get();
    }

    @NotNull
    private static String a(@NotNull Module module) {
        GemInfo gemInfo;
        long l2 = f ^ 0xCCD7DA6795BL;
        if (module == null) {
            TestUnitUtil.a(4);
        }
        if ((gemInfo = GemSearchUtil.findGemEx(module, MINITEST_GEM_NAME)) != null) {
            String string = gemInfo.getVersion();
            if (string == null) {
                TestUnitUtil.a(5);
            }
            return string;
        }
        String string = RubySdkUtil.isRuby19(RModuleUtil.getInstance().findRubySdkForModule(module)) ? "2.5.1" : "4.3.2";
        if (string == null) {
            TestUnitUtil.a(6);
        }
        return string;
    }

    @Nullable
    public static String determineCurrentTestNameByTestClosure(@NotNull PsiElement psiElement) {
        long l2 = f ^ 0x7C67EDC69D8AL;
        if (psiElement == null) {
            TestUnitUtil.a(7);
        }
        final Ref ref = new Ref();
        PsiCallable psiCallable = new PsiCallable(){
            private static final long a = la.a(6559932814636527009L, 6706140033025533454L, MethodHandles.lookup().lookupClass()).a(139188071911174L);

            @Override
            public void processCall(RCallArguments arguments) {
                long l2 = a ^ 0x60CB05967C6L;
                String string = arguments.evaluateArgument(0);
                if (string != null) {
                    ref.set((Object)("test_" + string.replaceAll("\\s+", "_")));
                }
            }
        };
        TestUnitUtil.a(psiElement, psiCallable, ACTIVE_SUPPORT_TEST_CLOSURE_SHORT_NAME);
        return (String)ref.get();
    }

    private static void a(@Nullable PsiElement psiElement, PsiCallable psiCallable, String ... stringArray) {
        RPsiElement rPsiElement;
        RPsiElement rPsiElement2 = rPsiElement = psiElement instanceof RPsiElement ? (RPsiElement)psiElement : (RPsiElement)PsiTreeUtil.getParentOfType((PsiElement)psiElement, RPsiElement.class);
        if (rPsiElement == null) {
            return;
        }
        RubyPsiInterpreter rubyPsiInterpreter = new RubyPsiInterpreter(true);
        rubyPsiInterpreter.registerCallable(psiCallable, stringArray);
        rubyPsiInterpreter.interpretCallsTreePath((PsiElement)rPsiElement, null);
    }

    public static boolean isTestClosureCall(@NotNull RPossibleCall call) {
        String string;
        long l2 = f ^ 0x4DB294E9DBF7L;
        if (call == null) {
            TestUnitUtil.a(8);
        }
        return (string = call.getCommand()) != null && ACTIVE_SUPPORT_TEST_CLOSURE_SHORT_NAME.equals(string);
    }

    public static boolean isMiniTestExampleGroupCall(@NotNull RPossibleCall call) {
        String string;
        if (call == null) {
            TestUnitUtil.a(9);
        }
        return (string = call.getCommand()) != null && MINITEST_GROUP_CALL_SHORT_NAMES.contains(string);
    }

    public static boolean isUnitTestMethod(@NotNull RMethod rMethod) {
        long l2 = f ^ 0x6830889FC1C9L;
        if (rMethod == null) {
            TestUnitUtil.a(10);
        }
        return rMethod.getName().startsWith("test_");
    }

    public static boolean isTestClosureSetupTeardownCall(@NotNull RPossibleCall call) {
        String string;
        long l2 = f ^ 0x2A0AAEA540C5L;
        if (call == null) {
            TestUnitUtil.a(11);
        }
        return (string = call.getCommand()) != null && (ACTIVE_SUPPORT_TEST_SETUP_SHORT_NAME.equals(string) || ACTIVE_SUPPORT_TEST_TEARDOWN_SHORT_NAME.equals(string));
    }

    @Nullable
    public static RPsiElement findValidTestClosure(@NotNull String name, @NotNull RClass rClass) {
        if (name == null) {
            TestUnitUtil.a(12);
        }
        if (rClass == null) {
            TestUnitUtil.a(13);
        }
        List<RPsiElement> list2 = TestUnitUtil.collectAllTestClosuresFrom(rClass);
        for (RPsiElement rPsiElement : list2) {
            String string = TestUnitUtil.determineCurrentTestNameByTestClosure((PsiElement)rPsiElement);
            if (!name.equals(string)) continue;
            return rPsiElement;
        }
        return null;
    }

    @NotNull
    public static List<RPsiElement> collectAllTestClosuresFrom(@NotNull RClass rClass) {
        if (rClass == null) {
            TestUnitUtil.a(14);
        }
        ArrayList<RPsiElement> arrayList = new ArrayList<RPsiElement>();
        TestUnitUtil.a(rClass, arrayList);
        List<Object> list2 = arrayList.size() > 0 ? arrayList : Collections.emptyList();
        if (list2 == null) {
            TestUnitUtil.a(15);
        }
        return list2;
    }

    private static void a(RClass rClass, List<RPsiElement> list2) {
        List list3 = rClass.getStatements();
        for (RPsiElement rPsiElement : list3) {
            RPossibleCall rPossibleCall;
            if (!(rPsiElement instanceof RPossibleCall) || !TestUnitUtil.isTestClosureCall(rPossibleCall = (RPossibleCall)rPsiElement)) continue;
            list2.add(rPsiElement);
        }
    }

    public static boolean isFileWithValidTestUnitFileName(@NotNull PsiFile psiFile) {
        if (psiFile == null) {
            TestUnitUtil.a(16);
        }
        return TestUnitUtil.isFileWithValidTestUnitFileName(psiFile, null, true);
    }

    public static boolean isFileWithValidTestUnitFileName(@Nullable VirtualFile file) {
        return TestUnitUtil.isFileWithValidTestUnitFileName(null, file, true);
    }

    public static boolean isFileWithValidMiniTestFileName(@Nullable VirtualFile file) {
        return TestUnitUtil.isFileWithValidTestUnitFileName(file);
    }

    public static boolean isFileWithValidTestUnitFileName(@Nullable VirtualFile file, boolean checkTestPrefixConvention) {
        return TestUnitUtil.isFileWithValidTestUnitFileName(null, file, checkTestPrefixConvention);
    }

    public static boolean isFileWithValidTestUnitFileName(@Nullable PsiFile psiFile, @Nullable VirtualFile file, boolean checkTestPrefixConvention) {
        long l2 = f ^ 0x1B56823A7664L;
        if (psiFile != null && file == null) {
            file = psiFile.getVirtualFile();
        }
        if (file == null || file.isDirectory()) {
            return false;
        }
        if (!"rb".equals(file.getExtension())) {
            return false;
        }
        String string = file.getNameWithoutExtension();
        if (string.endsWith("_test") || string.endsWith("Test")) {
            return true;
        }
        if (RSpecUtil.isFileWithRSpecTestFileName(file) && psiFile != null) {
            return true;
        }
        return checkTestPrefixConvention && string.startsWith("test_");
    }

    public static boolean isTestUnitSupportEnabled(@NotNull Module module) {
        if (module == null) {
            TestUnitUtil.a(17);
        }
        Sdk sdk = RModuleUtil.getInstance().findRubySdkForModule(module);
        return TestUnitUtil.isTestUnitSupportEnabled(module, sdk);
    }

    public static boolean isMiniTestSupportEnabled(@NotNull Module module) {
        Sdk sdk;
        if (module == null) {
            TestUnitUtil.a(18);
        }
        if ((sdk = RModuleUtil.getInstance().findRubySdkForModule(module)) != null && RubySdkUtil.isRuby18(sdk)) {
            return TestUnitUtil.isMiniTestGemAttached(module);
        }
        return true;
    }

    public static boolean isTestUnitSupportEnabled(Module module, Sdk sdk) {
        if (sdk != null && !RubySdkUtil.isRuby18(sdk)) {
            return TestUnitUtil.isTestUnitGemAttached(module);
        }
        return true;
    }

    public static boolean isTestUnitGemAttached(@NotNull Module module) {
        if (module == null) {
            TestUnitUtil.a(19);
        }
        return GemUtil.isGemOrRailsPluginSupportEnabled(module, b, ArrayUtil.EMPTY_STRING_ARRAY);
    }

    public static boolean isMiniTestGemAttached(@NotNull Module module) {
        if (module == null) {
            TestUnitUtil.a(20);
        }
        return GemUtil.isGemOrRailsPluginSupportEnabled(module, c, ArrayUtil.EMPTY_STRING_ARRAY);
    }

    @Nullable
    public static RPossibleCall getSimpleCoveringExampleOrBeforeAfterScope(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            TestUnitUtil.a(21);
        }
        return RubyPsiInterpreter.getSimpleCoveringCodeBlockScope(psiElement, MINITEST_INSTANCE_CONTEXT_CALLS_SHORT_NAMES, MINITEST_GROUP_CALL_SHORT_NAMES);
    }

    @Nullable
    public static RBlockCall getSimpleCoveringExampleGroupScope(@NotNull PsiElement psiElement) {
        RPossibleCall rPossibleCall;
        if (psiElement == null) {
            TestUnitUtil.a(22);
        }
        if ((rPossibleCall = RubyPsiInterpreter.getSimpleCoveringCodeBlockScope(psiElement, MINITEST_GROUP_CALL_SHORT_NAMES, MINITEST_INSTANCE_CONTEXT_CALLS_SHORT_NAMES)) instanceof RBlockCall) {
            return (RBlockCall)rPossibleCall;
        }
        return null;
    }

    static {
        f = la.a(6012257614699075877L, -4079912186431424527L, MethodHandles.lookup().lookupClass()).a(269571430492884L);
        long l2 = f ^ 0x7EF4E423F56AL;
        d = new HashSet<String>(Arrays.asList(ACTIVE_SUPPORT_TEST_CLOSURE_SHORT_NAME));
        TEST_SETUP_TEARDOWN_CALLS_SHORT_NAMES = new HashSet<String>();
        TEST_SETUP_TEARDOWN_CALLS_SHORT_NAMES.addAll(d);
        TEST_SETUP_TEARDOWN_CALLS_SHORT_NAMES.add(ACTIVE_SUPPORT_TEST_SETUP_SHORT_NAME);
        TEST_SETUP_TEARDOWN_CALLS_SHORT_NAMES.add(ACTIVE_SUPPORT_TEST_TEARDOWN_SHORT_NAME);
        MINITEST_GROUP_CALL_SHORT_NAMES = new HashSet<String>(Arrays.asList("describe"));
        MINITEST_EXAMPLE_CALL_SHORT_NAMES = new HashSet<String>(Arrays.asList("it"));
        MINITEST_SETUP_TEARDOWN_CALL_SHORT_NAMES = new HashSet<String>(Arrays.asList("before", "after"));
        MINITEST_INSTANCE_CONTEXT_CALLS_SHORT_NAMES = new HashSet<String>();
        MINITEST_INSTANCE_CONTEXT_CALLS_SHORT_NAMES.addAll(MINITEST_EXAMPLE_CALL_SHORT_NAMES);
        MINITEST_INSTANCE_CONTEXT_CALLS_SHORT_NAMES.addAll(MINITEST_SETUP_TEARDOWN_CALL_SHORT_NAMES);
        b = new String[]{TEST_UNIT_GEM_NAME};
        c = new String[]{MINITEST_GEM_NAME};
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = f ^ 0x75EFD80C6520L;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 15: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 4: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 5: 
            case 6: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/testing/testunit/runConfigurations/TestUnitUtil";
                break;
            }
            case 8: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rMethod";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rClass";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/testing/testunit/runConfigurations/TestUnitUtil";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getAttachedMinitestVersion";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "collectAllTestClosuresFrom";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isInActiveSupportTestClosureBlock";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isInActiveSupportTestClosureRegion";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isInMiniTestSpecExampleOrGroupRegion";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "determineCurrentTestNameAndFilterByMiniTestClosure";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getAttachedMinitestVersion";
                break;
            }
            case 5: 
            case 6: 
            case 15: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "determineCurrentTestNameByTestClosure";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isTestClosureCall";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isMiniTestExampleGroupCall";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isUnitTestMethod";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isTestClosureSetupTeardownCall";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "findValidTestClosure";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "collectAllTestClosuresFrom";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "isFileWithValidTestUnitFileName";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isTestUnitSupportEnabled";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "isMiniTestSupportEnabled";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "isTestUnitGemAttached";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "isMiniTestGemAttached";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getSimpleCoveringExampleOrBeforeAfterScope";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getSimpleCoveringExampleGroupScope";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

