/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.inspections.naming;

import b.h.la;
import com.intellij.psi.PsiElement;
import java.lang.invoke.MethodHandles;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.motion.RubyMotionUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.usages.UsageAnalyzer;
import org.jetbrains.plugins.ruby.ruby.inspections.RubyInspectionVisitor;
import org.jetbrains.plugins.ruby.ruby.inspections.fixes.RubyFix;
import org.jetbrains.plugins.ruby.ruby.inspections.fixes.RubyRenameFix;
import org.jetbrains.plugins.ruby.ruby.inspections.naming.ConventionInspection;
import org.jetbrains.plugins.ruby.ruby.inspections.naming.b;
import org.jetbrains.plugins.ruby.ruby.lang.TextUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RGlobalVariable;

public class RubyGlobalVariableNamingConventionInspection
extends ConventionInspection {
    private static final int c = 1;
    private static final int d = 30;
    private static final long e = la.a(-1016233053130903328L, -6463008023408161060L, MethodHandles.lookup().lookupClass()).a(280454920012166L);

    @Override
    protected String getDefaultRegex() {
        return TextUtil.IDENTIFIER_LOWERCASE_PATTERN.pattern();
    }

    @Override
    protected String getMotionDefaultRegex() {
        return RubyMotionUtil.getInstance().getRubyMotionIdentifierRegex();
    }

    @Override
    protected int getDefaultMinLength() {
        return 1;
    }

    @Override
    protected int getDefaultMaxLength() {
        return 30;
    }

    @Override
    protected RubyFix buildFix(PsiElement location) {
        return new RubyRenameFix();
    }

    @Override
    protected boolean buildQuickFixesOnlyForOnTheFlyErrors() {
        return true;
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        long l2 = e ^ 0x5A14BD5144FDL;
        if ("Global variable naming convention" == null) {
            RubyGlobalVariableNamingConventionInspection.d(0);
        }
        return "Global variable naming convention";
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... args) {
        long l2 = e ^ 0x5DD907178316L;
        String string = (String)args[0];
        if (string.length() < this.getMinLength()) {
            if ("Global variable name '#ref' is too short" == null) {
                RubyGlobalVariableNamingConventionInspection.d(1);
            }
            return "Global variable name '#ref' is too short";
        }
        if (string.length() > this.getMaxLength()) {
            if ("Global variable name '#ref' is too long" == null) {
                RubyGlobalVariableNamingConventionInspection.d(2);
            }
            return "Global variable name '#ref' is too long";
        }
        String string2 = "Global variable name '#ref' doesn't match regex '" + this.getRegex() + "' #loc";
        if (string2 == null) {
            RubyGlobalVariableNamingConventionInspection.d(3);
        }
        return string2;
    }

    @Override
    public RubyInspectionVisitor buildVisitor() {
        return new NamingConventionsVisitor(null);
    }

    private static /* synthetic */ void d(int n2) {
        Object[] objectArray;
        long l2 = e ^ 0x4F2B40BD6D48L;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "org/jetbrains/plugins/ruby/ruby/inspections/naming/RubyGlobalVariableNamingConventionInspection";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private class NamingConventionsVisitor
    extends RubyInspectionVisitor {
        private NamingConventionsVisitor() {
        }

        @Override
        public void visitRGlobalVariable(RGlobalVariable globalVariable) {
            if (!UsageAnalyzer.isDeclaration((RPsiElement)globalVariable)) {
                return;
            }
            String string = globalVariable.getName().substring(1);
            if (RubyGlobalVariableNamingConventionInspection.this.isValid(string, (PsiElement)globalVariable)) {
                return;
            }
            this.registerGlobalVariableError(globalVariable, string);
        }

        /* synthetic */ NamingConventionsVisitor(b x1) {
            this();
        }
    }
}

