/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.i18n;

import b.h.la;
import com.intellij.find.findUsages.FindUsagesHandler;
import com.intellij.lang.LanguageExtension;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.ex.temp.TempFileSystem;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.containers.MultiMap;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.i18n.dictionary.I18nCachedDictionaryProvider;
import org.jetbrains.plugins.ruby.i18n.dictionary.I18nDictionary;
import org.jetbrains.plugins.ruby.i18n.findUsages.RubyI18nFindUsagesHandler;
import org.jetbrains.plugins.ruby.i18n.locales.LocaleEntry;
import org.jetbrains.plugins.ruby.i18n.refactoring.safeDelete.RubyI18nSafeDeleteSupport;
import org.jetbrains.plugins.ruby.rails.model.RailsApp;
import org.jetbrains.plugins.ruby.ruby.module.RubyModuleSettings;

public abstract class I18nProvider {
    private static final String a = "locales";
    private static final String c = "i18n";
    public static final LanguageExtension<I18nProvider> EXTENSION;
    private static final I18nProvider b;
    private static final long d;

    @NotNull
    public abstract LocaleEntry createLocaleEntry(@NotNull PsiFile var1, @NotNull String var2);

    public List<?> getDictionaryDependencies(@NotNull Module module) {
        if (module == null) {
            I18nProvider.a(0);
        }
        return Collections.singletonList(PsiModificationTracker.MODIFICATION_COUNT);
    }

    public abstract boolean isTranslationElement(@NotNull PsiElement var1);

    @Nullable
    public abstract String getTranslation(@Nullable PsiElement var1);

    @Nullable
    public abstract String getKeyText(@Nullable PsiElement var1);

    @Nullable
    public abstract PsiElement getKeyElement(@Nullable PsiElement var1);

    @Nullable
    public abstract String getFullKey(@Nullable PsiElement var1);

    public abstract boolean canBeTranslationReferenceTarget(@NotNull PsiElement var1);

    @NotNull
    public RubyI18nSafeDeleteSupport createSafeDeleteSupport() {
        RubyI18nSafeDeleteSupport rubyI18nSafeDeleteSupport = RubyI18nSafeDeleteSupport.NULL_SUPPORT;
        if (rubyI18nSafeDeleteSupport == null) {
            I18nProvider.a(1);
        }
        return rubyI18nSafeDeleteSupport;
    }

    @NotNull
    public FindUsagesHandler createFindUsagesHandler(@NotNull PsiElement element) {
        if (element == null) {
            I18nProvider.a(2);
        }
        RubyI18nFindUsagesHandler rubyI18nFindUsagesHandler = new RubyI18nFindUsagesHandler(element);
        if (rubyI18nFindUsagesHandler == null) {
            I18nProvider.a(3);
        }
        return rubyI18nFindUsagesHandler;
    }

    @NotNull
    public static I18nProvider forElement(@NotNull PsiElement element) {
        I18nProvider i18nProvider;
        if (element == null) {
            I18nProvider.a(4);
        }
        I18nProvider i18nProvider2 = (i18nProvider = (I18nProvider)EXTENSION.forLanguage(element.getLanguage())) == null ? b : i18nProvider;
        if (i18nProvider2 == null) {
            I18nProvider.a(5);
        }
        return i18nProvider2;
    }

    @NotNull
    public static Collection<LocaleEntry> getAllLocaleEntries(@NotNull Module module) {
        if (module == null) {
            I18nProvider.a(6);
        }
        Collection<LocaleEntry> collection = I18nProvider.getDictionary(module).getAllLocaleEntries();
        if (collection == null) {
            I18nProvider.a(7);
        }
        return collection;
    }

    @NotNull
    public static List<LocaleEntry> getAllLocaleFiles(@NotNull List<? extends VirtualFile> localeRoots, @NotNull Module module) {
        if (localeRoots == null) {
            I18nProvider.a(8);
        }
        if (module == null) {
            I18nProvider.a(9);
        }
        if (localeRoots.isEmpty()) {
            List<LocaleEntry> list2 = Collections.emptyList();
            if (list2 == null) {
                I18nProvider.a(10);
            }
            return list2;
        }
        ArrayList<LocaleEntry> arrayList = new ArrayList<LocaleEntry>();
        PsiManager psiManager = PsiManager.getInstance((Project)module.getProject());
        for (VirtualFile virtualFile : localeRoots) {
            ProjectRootManager.getInstance((Project)module.getProject()).getFileIndex().iterateContentUnderDirectory(virtualFile, virtualFile2 -> {
                if (!virtualFile2.isDirectory()) {
                    PsiFile psiFile = psiManager.findFile(virtualFile2);
                    if (psiFile == null) {
                        return true;
                    }
                    I18nProvider i18nProvider = (I18nProvider)EXTENSION.forLanguage(psiFile.getLanguage());
                    if (i18nProvider != null) {
                        arrayList.add(i18nProvider.createLocaleEntry(psiFile, virtualFile.getPath()));
                    }
                }
                return true;
            });
        }
        ArrayList<LocaleEntry> arrayList2 = arrayList;
        if (arrayList2 == null) {
            I18nProvider.a(11);
        }
        return arrayList2;
    }

    public static boolean isLocaleFile(@NotNull PsiFile file) {
        if (file == null) {
            I18nProvider.a(12);
        }
        return (Boolean)CachedValuesManager.getCachedValue((PsiElement)file, () -> {
            if (file == null) {
                I18nProvider.a(19);
            }
            return new CachedValueProvider.Result((Object)I18nProvider.b(file), new Object[]{VirtualFileManager.VFS_STRUCTURE_MODIFICATIONS});
        });
    }

    @NotNull
    public static List<VirtualFile> getLocalesRoot(@Nullable Module module) {
        long l2 = d ^ 0x7D817F787973L;
        if (module == null) {
            List<VirtualFile> list2 = Collections.emptyList();
            if (list2 == null) {
                I18nProvider.a(13);
            }
            return list2;
        }
        ArrayList<VirtualFile> arrayList = new ArrayList<VirtualFile>();
        ArrayList<String> arrayList2 = new ArrayList<String>(RubyModuleSettings.getInstance(module).getI18nFolders());
        if (arrayList2.isEmpty()) {
            RailsApp railsApp = RailsApp.fromModule(module);
            if (railsApp != null) {
                VirtualFile virtualFile;
                VirtualFile virtualFile2 = railsApp.getConfigRoot();
                if (virtualFile2 != null && (virtualFile = virtualFile2.findChild(a)) != null) {
                    arrayList.add(virtualFile);
                    arrayList2.add(virtualFile.getPath());
                }
            } else {
                for (VirtualFile virtualFile : ModuleRootManager.getInstance((Module)module).getContentRoots()) {
                    VirtualFile virtualFile3;
                    VirtualFile virtualFile4 = virtualFile.findChild(c);
                    if (virtualFile4 != null) {
                        arrayList.add(virtualFile4);
                        arrayList2.add(virtualFile4.getPath());
                    }
                    if ((virtualFile3 = virtualFile.findChild(a)) == null) continue;
                    arrayList.add(virtualFile3);
                    arrayList2.add(virtualFile3.getPath());
                }
            }
            RubyModuleSettings.getInstance(module).setI18nFolders(arrayList2);
        } else {
            TempFileSystem tempFileSystem = ApplicationManager.getApplication().isUnitTestMode() ? TempFileSystem.getInstance() : LocalFileSystem.getInstance();
            for (String string : arrayList2) {
                VirtualFile virtualFile = tempFileSystem.findFileByPath(string);
                if (virtualFile == null) continue;
                arrayList.add(virtualFile);
            }
        }
        ArrayList<VirtualFile> arrayList3 = arrayList;
        if (arrayList3 == null) {
            I18nProvider.a(14);
        }
        return arrayList3;
    }

    @NotNull
    public static I18nDictionary createDictionary(@NotNull Module module) {
        if (module == null) {
            I18nProvider.a(15);
        }
        List<VirtualFile> list2 = I18nProvider.getLocalesRoot(module);
        final List<LocaleEntry> list3 = I18nProvider.getAllLocaleFiles(list2, module);
        final MultiMap multiMap = MultiMap.createSet();
        final MultiMap multiMap2 = MultiMap.createSet();
        final MultiMap multiMap3 = MultiMap.createSet();
        for (LocaleEntry localeEntry : list3) {
            String string = localeEntry.getLocale();
            if (string == null) continue;
            multiMap.putValue((Object)string, (Object)localeEntry);
            localeEntry.getAllKeys().forEach(string2 -> {
                multiMap2.putValue(string2, (Object)localeEntry);
                multiMap3.putValue(string2, (Object)string);
            });
        }
        I18nDictionary i18nDictionary = new I18nDictionary(){
            private static final long a = la.a(-7067201890836178517L, 8247935246816287363L, MethodHandles.lookup().lookupClass()).a(236241647766284L);

            @Override
            @NotNull
            public Collection<String> getAllLocales() {
                Set set = multiMap.keySet();
                if (set == null) {
                    1.b(0);
                }
                return set;
            }

            @Override
            @NotNull
            public Collection<String> getAllKeys() {
                Set set = multiMap3.keySet();
                if (set == null) {
                    1.b(1);
                }
                return set;
            }

            @Override
            @NotNull
            public Collection<LocaleEntry> getAllLocaleEntries() {
                Collection collection = list3;
                if (collection == null) {
                    1.b(2);
                }
                return collection;
            }

            @Override
            @NotNull
            public Collection<String> getLocalesByKey(@Nullable String key) {
                Collection collection = multiMap3.get((Object)key);
                if (collection == null) {
                    1.b(3);
                }
                return collection;
            }

            @Override
            @NotNull
            public Collection<LocaleEntry> getLocaleEntriesByKey(@Nullable String key) {
                Collection collection = multiMap2.get((Object)key);
                if (collection == null) {
                    1.b(4);
                }
                return collection;
            }

            @Override
            @NotNull
            public Collection<LocaleEntry> getLocaleEntriesByKeyPrefix(@Nullable String keyPrefix) {
                if (keyPrefix == null) {
                    Set<LocaleEntry> set = Collections.emptySet();
                    if (set == null) {
                        1.b(5);
                    }
                    return set;
                }
                Collection collection = this.getAllKeys().stream().filter(string2 -> string2.startsWith(keyPrefix)).flatMap(string -> multiMap2.get(string).stream()).collect(Collectors.toSet());
                if (collection == null) {
                    1.b(6);
                }
                return collection;
            }

            @Override
            @NotNull
            public Collection<LocaleEntry> getLocaleEntriesByLocale(@Nullable String locale) {
                Collection collection = multiMap.get((Object)locale);
                if (collection == null) {
                    1.b(7);
                }
                return collection;
            }

            private static /* synthetic */ void b(int n2) {
                Object[] objectArray;
                long l2 = a ^ 0x18904E197422L;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "org/jetbrains/plugins/ruby/i18n/I18nProvider$1";
                switch (n2) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getAllLocales";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getAllKeys";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getAllLocaleEntries";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getLocalesByKey";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getLocaleEntriesByKey";
                        break;
                    }
                    case 5: 
                    case 6: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getLocaleEntriesByKeyPrefix";
                        break;
                    }
                    case 7: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getLocaleEntriesByLocale";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        };
        if (i18nDictionary == null) {
            I18nProvider.a(16);
        }
        return i18nDictionary;
    }

    public static boolean isI18nSupportEnabled(@Nullable Module module) {
        return module != null && !I18nProvider.getLocalesRoot(module).isEmpty();
    }

    public static I18nDictionary getDictionary(@NotNull Module module) {
        if (module == null) {
            I18nProvider.a(17);
        }
        return (I18nDictionary)CachedValuesManager.getManager((Project)module.getProject()).getCachedValue((UserDataHolder)module, (CachedValueProvider)new I18nCachedDictionaryProvider(module));
    }

    private static boolean b(@NotNull PsiFile psiFile) {
        VirtualFile virtualFile;
        if (psiFile == null) {
            I18nProvider.a(18);
        }
        if ((virtualFile = psiFile.getVirtualFile()) == null) {
            return false;
        }
        for (VirtualFile virtualFile2 : I18nProvider.getLocalesRoot(ModuleUtilCore.findModuleForPsiElement((PsiElement)psiFile))) {
            if (!VfsUtilCore.isAncestor((VirtualFile)virtualFile2, (VirtualFile)virtualFile, (boolean)false)) continue;
            return true;
        }
        return false;
    }

    static {
        d = la.a(8554626209409478576L, 4407546966217213162L, MethodHandles.lookup().lookupClass()).a(248766604176426L);
        long l2 = d ^ 0x3B6D4E7A4A9L;
        EXTENSION = new LanguageExtension("org.jetbrains.plugins.ruby.i18n.i18nProvider");
        b = new I18nProvider(){
            private static final long e = la.a(3171330130981750524L, 830247623631634035L, MethodHandles.lookup().lookupClass()).a(245663788724296L);

            @Override
            @NotNull
            public LocaleEntry createLocaleEntry(@NotNull PsiFile psiFile, @NotNull String localesRootPath) {
                if (psiFile == null) {
                    2.b(0);
                }
                if (localesRootPath == null) {
                    2.b(1);
                }
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean isTranslationElement(@NotNull PsiElement element) {
                if (element == null) {
                    2.b(2);
                }
                return false;
            }

            @Override
            @Nullable
            public String getTranslation(@Nullable PsiElement element) {
                return null;
            }

            @Override
            @Nullable
            public String getKeyText(@Nullable PsiElement element) {
                return null;
            }

            @Override
            @Nullable
            public PsiElement getKeyElement(@Nullable PsiElement element) {
                return null;
            }

            @Override
            @Nullable
            public String getFullKey(@Nullable PsiElement element) {
                return null;
            }

            @Override
            @NotNull
            public FindUsagesHandler createFindUsagesHandler(@NotNull PsiElement element) {
                if (element == null) {
                    2.b(3);
                }
                FindUsagesHandler findUsagesHandler = FindUsagesHandler.NULL_HANDLER;
                if (findUsagesHandler == null) {
                    2.b(4);
                }
                return findUsagesHandler;
            }

            @Override
            public boolean canBeTranslationReferenceTarget(@NotNull PsiElement element) {
                if (element == null) {
                    2.b(5);
                }
                return false;
            }

            private static /* synthetic */ void b(int n2) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n3;
                String string;
                long l2 = e ^ 0x1B562E52F814L;
                switch (n2) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 4: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n2) {
                    default: {
                        n3 = 3;
                        break;
                    }
                    case 4: {
                        n3 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n3];
                switch (n2) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "psiFile";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "localesRootPath";
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "element";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "org/jetbrains/plugins/ruby/i18n/I18nProvider$2";
                        break;
                    }
                }
                switch (n2) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "org/jetbrains/plugins/ruby/i18n/I18nProvider$2";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[1] = "createFindUsagesHandler";
                        break;
                    }
                }
                switch (n2) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "createLocaleEntry";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "isTranslationElement";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray;
                        objectArray[2] = "createFindUsagesHandler";
                        break;
                    }
                    case 4: {
                        break;
                    }
                    case 5: {
                        objectArray = objectArray;
                        objectArray[2] = "canBeTranslationReferenceTarget";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n2) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 4: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = d ^ 0x45DE006318EDL;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 16: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/i18n/I18nProvider";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localeRoots";
                break;
            }
            case 12: 
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/i18n/I18nProvider";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createSafeDeleteSupport";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createFindUsagesHandler";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "forElement";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllLocaleEntries";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllLocaleFiles";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocalesRoot";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "createDictionary";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getDictionaryDependencies";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 16: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createFindUsagesHandler";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "forElement";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getAllLocaleEntries";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getAllLocaleFiles";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isLocaleFile";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "createDictionary";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getDictionary";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "isLocaleFileImpl";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "lambda$isLocaleFile$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

