/*
 * Decompiled with CFR 0.152.
 */
package org.wiztools.restclient.ui.resbody;

import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.swing.BorderFactory;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.wiztools.restclient.IGlobalOptions;
import org.wiztools.restclient.ServiceLocator;
import org.wiztools.restclient.bean.ContentType;
import org.wiztools.restclient.persistence.XMLException;
import org.wiztools.restclient.ui.FontableEditor;
import org.wiztools.restclient.ui.RESTView;
import org.wiztools.restclient.ui.ScriptEditor;
import org.wiztools.restclient.ui.ScriptEditorFactory;
import org.wiztools.restclient.ui.TextEditorSyntax;
import org.wiztools.restclient.ui.component.BodyPopupMenu;
import org.wiztools.restclient.ui.component.BodyPopupMenuListener;
import org.wiztools.restclient.ui.resbody.AbstractResBody;
import org.wiztools.restclient.util.HTMLIndentUtil;
import org.wiztools.restclient.util.HttpUtil;
import org.wiztools.restclient.util.JSONUtil;
import org.wiztools.restclient.util.XMLIndentUtil;

public class ResBodyTextPanel
extends AbstractResBody
implements FontableEditor {
    @Inject
    RESTView view;
    private final ScriptEditor se_response = ScriptEditorFactory.getXMLScriptEditor();
    private BodyPopupMenu bodyPopupMenu;

    @PostConstruct
    protected void init() {
        BodyPopupMenu bpm;
        this.se_response.setEditable(false);
        BodyPopupMenuListener listener = new BodyPopupMenuListener(){

            @Override
            public void onSuccess(String msg) {
                ResBodyTextPanel.this.view.setStatusMessage(msg);
            }

            @Override
            public void onFailure(String msg) {
                ResBodyTextPanel.this.view.setStatusMessage(msg);
            }

            @Override
            public void onMessage(String msg) {
                ResBodyTextPanel.this.view.setStatusMessage(msg);
            }
        };
        this.bodyPopupMenu = bpm = new BodyPopupMenu(this.se_response, listener, true);
        if (this.se_response.getEditorComponent() instanceof RSyntaxTextArea) {
            this.se_response.getEditorComponent().addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    this.showPopup(e);
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    this.showPopup(e);
                }

                private void showPopup(MouseEvent e) {
                    if ("".equals(ResBodyTextPanel.this.se_response.getText().trim())) {
                        return;
                    }
                    if (e.isPopupTrigger()) {
                        bpm.show(e.getComponent(), e.getX(), e.getY());
                    }
                }
            });
        }
        this.setBorder(BorderFactory.createEmptyBorder());
        this.setLayout(new GridLayout());
        this.add(this.se_response.getEditorView());
    }

    @Override
    public void setEditorFont(Font font) {
        this.se_response.getEditorComponent().setFont(font);
    }

    @Override
    public Font getEditorFont() {
        return this.se_response.getEditorComponent().getFont();
    }

    @Override
    public void setBody(byte[] body, ContentType type) {
        super.setBody(body, type);
        this.bodyPopupMenu.cancelRunningJob();
        boolean isXml = HttpUtil.isXmlContentType(type.getContentType());
        boolean isJson = HttpUtil.isJsonContentType(type.getContentType());
        boolean isHTML = HttpUtil.isHTMLContentType(type.getContentType());
        IGlobalOptions options = ServiceLocator.getInstance(IGlobalOptions.class);
        if (options.isPropertyTrue("response.body.syntax.color")) {
            if (isXml) {
                this.se_response.setSyntax(TextEditorSyntax.XML);
            }
            if (isJson) {
                this.se_response.setSyntax(TextEditorSyntax.JSON);
            }
            if (HttpUtil.isJsContentType(type.getContentType())) {
                this.se_response.setSyntax(TextEditorSyntax.JS);
            }
            if (HttpUtil.isCssContentType(type.getContentType())) {
                this.se_response.setSyntax(TextEditorSyntax.CSS);
            }
            if (isHTML) {
                this.se_response.setSyntax(TextEditorSyntax.HTML);
            }
        } else {
            this.se_response.setSyntax(TextEditorSyntax.NONE);
        }
        String responseBody = new String(this.getBody(), HttpUtil.getCharsetDefault(type));
        if (options.isPropertyTrue("response.body.indent")) {
            if (isXml) {
                try {
                    String indentedResponseBody = XMLIndentUtil.getIndented(responseBody);
                    this.se_response.setText(indentedResponseBody);
                }
                catch (IOException | XMLException ex) {
                    this.view.setStatusMessage("XML indentation failed.");
                    this.se_response.setText(responseBody);
                }
            } else if (isJson) {
                try {
                    String indentedResponseBody = JSONUtil.indentJSON(responseBody);
                    this.se_response.setText(indentedResponseBody);
                }
                catch (JSONUtil.JSONParseException ex) {
                    this.view.setStatusMessage("JSON indentation failed.");
                    this.se_response.setText(responseBody);
                }
            } else if (isHTML) {
                try {
                    String indentedResponseBody = HTMLIndentUtil.getIndented(responseBody);
                    this.se_response.setText(indentedResponseBody);
                }
                catch (Exception ex) {
                    this.view.setStatusMessage("HTML indentation failed.");
                    this.se_response.setText(responseBody);
                }
            } else {
                this.view.setStatusMessage("Response body neither XML,HTML nor JSON. No indentation.");
                this.se_response.setText(responseBody);
            }
        } else {
            this.se_response.setText(responseBody);
        }
        this.se_response.setCaretPosition(0);
    }

    @Override
    public void clearUI() {
        this.se_response.setText("");
    }
}

