/*
 * Decompiled with CFR 0.152.
 */
package org.wiztools.restclient.ui.option;

import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import org.wiztools.restclient.IGlobalOptions;
import org.wiztools.restclient.ServiceLocator;
import org.wiztools.restclient.ui.EscapableDialog;
import org.wiztools.restclient.ui.RESTUserInterface;
import org.wiztools.restclient.ui.UIUtil;
import org.wiztools.restclient.ui.option.IOptionsPanel;
import org.wiztools.restclient.util.Util;

public class OptionsDialog
extends EscapableDialog {
    private static final Logger LOG = Logger.getLogger(OptionsDialog.class.getName());
    private final Map<String, IOptionsPanel> panels = new LinkedHashMap<String, IOptionsPanel>();
    private static final ResourceBundle rb = ResourceBundle.getBundle("org.wiztools.restclient.uioptionsdialog");

    @Inject
    public OptionsDialog(RESTUserInterface ui) {
        super((Frame)ui.getFrame(), true);
    }

    @PostConstruct
    protected void init() {
        this.setTitle("Options");
        String t = rb.getString("panel");
        String[] arr = t.split(",");
        for (String s2 : arr) {
            String[] arrt = s2.split(":");
            try {
                LOG.log(Level.FINEST, "OptionsPanel adding: {0}", arrt[1]);
                this.panels.put(arrt[0], (IOptionsPanel)Class.forName(arrt[1]).newInstance());
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException ex) {
                LOG.log(Level.SEVERE, null, ex);
            }
        }
        for (String key : this.panels.keySet()) {
            IOptionsPanel p = this.panels.get(key);
            p.initOptions();
        }
        JTabbedPane jtp = new JTabbedPane();
        jtp.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        for (String key : this.panels.keySet()) {
            jtp.addTab(key, UIUtil.getFlowLayoutPanelLeftAligned((JPanel)((Object)this.panels.get(key))));
        }
        JPanel jp_encp = new JPanel();
        jp_encp.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        jp_encp.setLayout(new BorderLayout(5, 5));
        jp_encp.add((Component)jtp, "Center");
        JPanel jp_encp_south = new JPanel();
        jp_encp_south.setLayout(new FlowLayout(1));
        JButton jb_ok = new JButton("Ok");
        this.getRootPane().setDefaultButton(jb_ok);
        jb_ok.setMnemonic('o');
        jb_ok.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                OptionsDialog.this.actionOk();
            }
        });
        JButton jb_cancel = new JButton("Cancel");
        jb_cancel.setMnemonic('c');
        jb_cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                OptionsDialog.this.actionCancel();
            }
        });
        jp_encp_south.add(jb_ok);
        jp_encp_south.add(jb_cancel);
        jp_encp.add((Component)jp_encp_south, "South");
        this.setContentPane(jp_encp);
        this.pack();
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                OptionsDialog.this.writeProperties();
            }
        });
    }

    private void writeProperties() {
        for (String key : this.panels.keySet()) {
            this.panels.get(key).shutdownOptions();
        }
        ServiceLocator.getInstance(IGlobalOptions.class).writeProperties();
    }

    @Override
    public void doEscape(AWTEvent event) {
        this.actionCancel();
    }

    private void actionOk() {
        ArrayList<String> errors = new ArrayList<String>();
        for (String key : this.panels.keySet()) {
            List<String> t = this.panels.get(key).validateInput();
            if (t == null) continue;
            errors.addAll(t);
        }
        if (errors.size() > 0) {
            String errStr = Util.getHTMLListFromList(errors);
            JOptionPane.showMessageDialog(this, errStr, "Error in input.", 0);
            return;
        }
        for (String key : this.panels.keySet()) {
            this.panels.get(key).saveOptions();
        }
        this.setVisible(false);
    }

    private void actionCancel() {
        for (String key : this.panels.keySet()) {
            this.panels.get(key).revertOptions();
        }
        this.setVisible(false);
    }
}

