/*
 * Decompiled with CFR 0.152.
 */
package org.wiztools.appupdate;

import java.io.InputStream;
import java.io.Reader;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonReader;
import javax.json.JsonString;
import org.wiztools.appupdate.VersionImpl;
import org.wiztools.appupdate.VersionUrl;
import org.wiztools.appupdate.VersionUrlImpl;

public class JsonConvert {
    public VersionUrl getVersionUrl(Reader is) {
        JsonReader rdr = Json.createReader(is);
        return this.getVersionUrl(rdr);
    }

    public VersionUrl getVersionUrl(InputStream is) {
        JsonReader rdr = Json.createReader(is);
        return this.getVersionUrl(rdr);
    }

    private VersionUrl getVersionUrl(JsonReader rdr) {
        JsonObject obj = rdr.readObject();
        VersionImpl version = new VersionImpl(obj.getJsonString("version").getString());
        String dlUrl = obj.getJsonString("dl_url").getString();
        JsonString t = obj.getJsonString("release_notes_url");
        String releaseNotesUrl = t != null ? t.getString() : null;
        JsonString t2 = obj.getJsonString("least_version_required");
        VersionImpl leastVersionRequired = t2 != null ? new VersionImpl(t2.getString()) : null;
        VersionUrlImpl out = new VersionUrlImpl();
        out.setVersion(version);
        out.setUrl(dlUrl);
        out.setReleaseNotesUrl(releaseNotesUrl);
        out.setLeastVersionRequired(leastVersionRequired);
        return out;
    }
}

