/*
 * Decompiled with CFR 0.152.
 */
package git4idea.actions;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.dvcs.repo.Repository;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import git4idea.GitUtil;
import git4idea.branch.GitBranchUtil;
import git4idea.branch.GitRebaseParams;
import git4idea.i18n.GitBundle;
import git4idea.rebase.GitRebaseDialog;
import git4idea.rebase.GitRebaseUtils;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class GitRebase
extends DumbAwareAction {
    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            GitRebase.$$$reportNull$$$0(0);
        }
        Project project = e.getProject();
        Presentation presentation = e.getPresentation();
        if (project == null || !GitUtil.hasGitRepositories(project) || !GitRebaseUtils.getRebasingRepositories(project).isEmpty()) {
            presentation.setEnabledAndVisible(false);
        } else if (GitUtil.getRepositoriesInState(project, Repository.State.NORMAL).isEmpty()) {
            presentation.setEnabled(false);
        } else {
            presentation.setEnabledAndVisible(true);
        }
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            GitRebase.$$$reportNull$$$0(1);
        }
        return actionUpdateThread;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            GitRebase.$$$reportNull$$$0(2);
        }
        final Project project = (Project)e.getRequiredData(CommonDataKeys.PROJECT);
        ArrayList<GitRepository> repositories2 = new ArrayList<GitRepository>(GitUtil.getRepositories(project));
        repositories2.removeAll(GitRebaseUtils.getRebasingRepositories(project));
        ArrayList<VirtualFile> roots = new ArrayList<VirtualFile>(GitUtil.getRootsFromRepositories(DvcsUtil.sortRepositories(repositories2)));
        GitRepository selectedRepo = GitBranchUtil.guessRepositoryForOperation(project, e.getDataContext());
        VirtualFile defaultRoot = selectedRepo != null ? selectedRepo.getRoot() : null;
        GitRebaseDialog dialog2 = new GitRebaseDialog(project, roots, defaultRoot);
        if (dialog2.showAndGet()) {
            final VirtualFile root = dialog2.gitRoot();
            final GitRebaseParams selectedParams = dialog2.getSelectedParams();
            ProgressManager.getInstance().run((Task)new Task.Backgroundable(project, GitBundle.message("rebase.progress.indicator.title", new Object[0])){

                public void run(@NotNull ProgressIndicator indicator) {
                    if (indicator == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    GitRepository selectedRepository = Objects.requireNonNull((GitRepository)GitRepositoryManager.getInstance(project).getRepositoryForRoot(root));
                    GitRebaseUtils.rebase(project, Collections.singletonList(selectedRepository), selectedParams, indicator);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "git4idea/actions/GitRebase$1", "run"));
                }
            });
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/actions/GitRebase";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/actions/GitRebase";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

