/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.debugger;

import com.intellij.openapi.util.UserDataHolderEx;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;
import org.jetbrains.debugger.AttachStateManager;
import org.jetbrains.debugger.BreakpointManager;
import org.jetbrains.debugger.CallFrame;
import org.jetbrains.debugger.DebugEventListener;
import org.jetbrains.debugger.EvaluateContext;
import org.jetbrains.debugger.ExceptionCatchMode;
import org.jetbrains.debugger.ScriptDebuggerBundle;
import org.jetbrains.debugger.ScriptManager;
import org.jetbrains.debugger.SuspendContextManager;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0014\u0010\u001f\u001a\u0006\u0012\u0002\b\u00030 2\u0006\u0010!\u001a\u00020\"H\u0016R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0012\u0010\u0006\u001a\u00020\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0012\u0010\n\u001a\u00020\u000bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u00138WX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0012\u0010\u0016\u001a\u00020\u0017X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u001a\u0010\u001a\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001c0\u001bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001e\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006#\u00c0\u0006\u0001"}, d2={"Lorg/jetbrains/debugger/Vm;", "Lcom/intellij/openapi/util/UserDataHolderEx;", "attachStateManager", "Lorg/jetbrains/debugger/AttachStateManager;", "getAttachStateManager", "()Lorg/jetbrains/debugger/AttachStateManager;", "breakpointManager", "Lorg/jetbrains/debugger/BreakpointManager;", "getBreakpointManager", "()Lorg/jetbrains/debugger/BreakpointManager;", "debugListener", "Lorg/jetbrains/debugger/DebugEventListener;", "getDebugListener", "()Lorg/jetbrains/debugger/DebugEventListener;", "evaluateContext", "Lorg/jetbrains/debugger/EvaluateContext;", "getEvaluateContext", "()Lorg/jetbrains/debugger/EvaluateContext;", "presentableName", "", "getPresentableName", "()Ljava/lang/String;", "scriptManager", "Lorg/jetbrains/debugger/ScriptManager;", "getScriptManager", "()Lorg/jetbrains/debugger/ScriptManager;", "suspendContextManager", "Lorg/jetbrains/debugger/SuspendContextManager;", "Lorg/jetbrains/debugger/CallFrame;", "getSuspendContextManager", "()Lorg/jetbrains/debugger/SuspendContextManager;", "setBreakOnException", "Lorg/jetbrains/concurrency/Promise;", "catchMode", "Lorg/jetbrains/debugger/ExceptionCatchMode;", "intellij.platform.scriptDebugger.backend"})
public interface Vm
extends UserDataHolderEx {
    @NotNull
    public DebugEventListener getDebugListener();

    @NotNull
    public AttachStateManager getAttachStateManager();

    @Nullable
    public EvaluateContext getEvaluateContext();

    @NotNull
    public ScriptManager getScriptManager();

    @NotNull
    public BreakpointManager getBreakpointManager();

    @NotNull
    public SuspendContextManager<? extends CallFrame> getSuspendContextManager();

    @NotNull
    default public Promise<?> setBreakOnException(@NotNull ExceptionCatchMode catchMode) {
        Intrinsics.checkNotNullParameter((Object)((Object)catchMode), (String)"catchMode");
        return Promises.nullPromise();
    }

    @Nls
    @NotNull
    default public String getPresentableName() {
        String string2 = ScriptDebuggerBundle.message("debug.vm.title.main.thread", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(\"debug.vm.title.main.thread\")");
        return string2;
    }
}

