/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.debugger;

import com.intellij.xdebugger.XDebuggerBundle;
import com.intellij.xdebugger.frame.XCompositeNode;
import com.intellij.xdebugger.frame.XValueChildrenList;
import com.intellij.xdebugger.frame.XValueGroup;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.debugger.CallFrame;
import org.jetbrains.debugger.ParentlessVariableContext;
import org.jetbrains.debugger.Scope;
import org.jetbrains.debugger.ScopeType;
import org.jetbrains.debugger.ScopeVariablesGroup;
import org.jetbrains.debugger.VariableContext;
import org.jetbrains.debugger.VariableContextWrapper;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000,\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\u001a.\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n\u001a \u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n\u001a\f\u0010\u000e\u001a\u00020\u000f*\u00020\u0006H\u0002\u00a8\u0006\u0010"}, d2={"createAndAddScopeList", "", "node", "Lcom/intellij/xdebugger/frame/XCompositeNode;", "scopes", "", "Lorg/jetbrains/debugger/Scope;", "context", "Lorg/jetbrains/debugger/VariableContext;", "callFrame", "Lorg/jetbrains/debugger/CallFrame;", "createVariableContext", "scope", "parentContext", "createScopeNodeName", "", "intellij.platform.scriptDebugger.ui"})
public final class ScopeVariablesGroupKt {
    public static final void createAndAddScopeList(@NotNull XCompositeNode node, @NotNull List<? extends Scope> scopes, @NotNull VariableContext context, @Nullable CallFrame callFrame) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter(scopes, (String)"scopes");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        XValueChildrenList list = new XValueChildrenList(scopes.size());
        for (Scope scope2 : scopes) {
            list.addBottomGroup((XValueGroup)new ScopeVariablesGroup(scope2, context, callFrame, Intrinsics.areEqual((Object)scope2, (Object)scopes.get(0))));
        }
        node.addChildren(list, true);
    }

    @NotNull
    public static final VariableContext createVariableContext(@NotNull Scope scope2, @NotNull VariableContext parentContext, @Nullable CallFrame callFrame) {
        Intrinsics.checkNotNullParameter((Object)scope2, (String)"scope");
        Intrinsics.checkNotNullParameter((Object)parentContext, (String)"parentContext");
        if (callFrame == null || scope2.getType() == ScopeType.LIBRARY) {
            return new ParentlessVariableContext(parentContext, scope2, scope2.getType() == ScopeType.GLOBAL);
        }
        return new VariableContextWrapper(parentContext, scope2);
    }

    private static final String createScopeNodeName(Scope $this$createScopeNodeName) {
        switch (WhenMappings.$EnumSwitchMapping$0[$this$createScopeNodeName.getType().ordinal()]) {
            case 1: {
                String string2 = XDebuggerBundle.message((String)"scope.global", (Object[])new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(\"scope.global\")");
                return string2;
            }
            case 2: {
                String string3 = XDebuggerBundle.message((String)"scope.local", (Object[])new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(\"scope.local\")");
                return string3;
            }
            case 3: {
                String string4 = XDebuggerBundle.message((String)"scope.with", (Object[])new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"message(\"scope.with\")");
                return string4;
            }
            case 4: {
                String string5 = XDebuggerBundle.message((String)"scope.closure", (Object[])new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"message(\"scope.closure\")");
                return string5;
            }
            case 5: {
                String string6 = XDebuggerBundle.message((String)"scope.catch", (Object[])new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"message(\"scope.catch\")");
                return string6;
            }
            case 6: {
                String string7 = XDebuggerBundle.message((String)"scope.library", (Object[])new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"message(\"scope.library\")");
                return string7;
            }
            case 7: {
                String string8 = XDebuggerBundle.message((String)"scope.instance", (Object[])new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"message(\"scope.instance\")");
                return string8;
            }
            case 8: {
                String string9 = XDebuggerBundle.message((String)"scope.class", (Object[])new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"message(\"scope.class\")");
                return string9;
            }
            case 9: {
                String string10 = XDebuggerBundle.message((String)"scope.block", (Object[])new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string10, (String)"message(\"scope.block\")");
                return string10;
            }
            case 10: {
                String string11 = XDebuggerBundle.message((String)"scope.script", (Object[])new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string11, (String)"message(\"scope.script\")");
                return string11;
            }
            case 11: {
                String string12 = XDebuggerBundle.message((String)"scope.unknown", (Object[])new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string12, (String)"message(\"scope.unknown\")");
                return string12;
            }
        }
        throw new IllegalArgumentException($this$createScopeNodeName.getType().name());
    }

    public static final /* synthetic */ String access$createScopeNodeName(Scope $receiver) {
        return ScopeVariablesGroupKt.createScopeNodeName($receiver);
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ScopeType.values().length];
            try {
                nArray[ScopeType.GLOBAL.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ScopeType.LOCAL.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ScopeType.WITH.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ScopeType.CLOSURE.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ScopeType.CATCH.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ScopeType.LIBRARY.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ScopeType.INSTANCE.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ScopeType.CLASS.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ScopeType.BLOCK.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ScopeType.SCRIPT.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ScopeType.UNKNOWN.ordinal()] = 11;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

