/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.actions;

import com.intellij.internal.statistic.eventLog.events.EventPair;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.util.NlsActions;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.text.DateFormatUtil;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsCommitMetadata;
import com.intellij.vcs.log.VcsLogBundle;
import com.intellij.vcs.log.VcsLogDataKeys;
import com.intellij.vcs.log.data.LoadingDetails;
import com.intellij.vcs.log.graph.VisibleGraph;
import com.intellij.vcs.log.impl.VcsLogNavigationUtil;
import com.intellij.vcs.log.statistics.VcsLogUsageTriggerCollector;
import com.intellij.vcs.log.ui.VcsLogUiEx;
import com.intellij.vcs.log.ui.frame.CommitPresentationUtil;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u001e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0002J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0003J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\u0016\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u0019\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0014\u0010\u001a\u001a\u00020\b*\u00020\u00012\u0006\u0010\t\u001a\u00020\nH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u001b"}, d2={"Lcom/intellij/vcs/log/ui/actions/GoToParentOrChildAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "parent", "", "(Z)V", "getParent", "()Z", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "createGroup", "Lcom/intellij/openapi/actionSystem/ActionGroup;", "ui", "Lcom/intellij/vcs/log/ui/VcsLogUiEx;", "rows", "", "", "getActionText", "", "commitMetadata", "Lcom/intellij/vcs/log/VcsCommitMetadata;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "getRowsToJump", "update", "triggerUsage", "intellij.platform.vcs.log.impl"})
@SourceDebugExtension(value={"SMAP\nGoToParentOrChildAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GoToParentOrChildAction.kt\ncom/intellij/vcs/log/ui/actions/GoToParentOrChildAction\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,111:1\n1620#2,3:112\n*S KotlinDebug\n*F\n+ 1 GoToParentOrChildAction.kt\ncom/intellij/vcs/log/ui/actions/GoToParentOrChildAction\n*L\n69#1:112,3\n*E\n"})
public class GoToParentOrChildAction
extends DumbAwareAction {
    private final boolean parent;

    public GoToParentOrChildAction(boolean parent) {
        this.parent = parent;
    }

    public final boolean getParent() {
        return this.parent;
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.EDT;
    }

    public void update(@NotNull AnActionEvent e) {
        VcsLogUiEx ui2;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Object object = e.getData(VcsLogDataKeys.VCS_LOG_UI);
        VcsLogUiEx vcsLogUiEx = ui2 = object instanceof VcsLogUiEx ? (VcsLogUiEx)object : null;
        if (ui2 == null) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        e.getPresentation().setVisible(true);
        if (e.getInputEvent() instanceof KeyEvent) {
            e.getPresentation().setEnabled(ui2.getTable().isFocusOwner());
        } else {
            e.getPresentation().setEnabled(!((Collection)this.getRowsToJump(ui2)).isEmpty());
        }
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        this.triggerUsage(this, e);
        Object object = e.getRequiredData(VcsLogDataKeys.VCS_LOG_UI);
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type com.intellij.vcs.log.ui.VcsLogUiEx");
        VcsLogUiEx ui2 = (VcsLogUiEx)object;
        List<Integer> rows = this.getRowsToJump(ui2);
        if (rows.isEmpty()) {
            return;
        }
        if (rows.size() == 1) {
            VcsLogNavigationUtil.jumpToRow(ui2, ((Number)CollectionsKt.single(rows)).intValue(), false, true);
        } else {
            ListPopup listPopup = JBPopupFactory.getInstance().createActionGroupPopup(this.parent ? VcsLogBundle.message("action.go.to.select.parent.to.navigate", new Object[0]) : VcsLogBundle.message("action.go.to.select.child.to.navigate", new Object[0]), this.createGroup(ui2, rows), e.getDataContext(), JBPopupFactory.ActionSelectionAid.NUMBERING, false);
            Intrinsics.checkNotNullExpressionValue((Object)listPopup, (String)"getInstance().createActi\u2026tionAid.NUMBERING, false)");
            ListPopup popup2 = listPopup;
            popup2.showInBestPositionFor(e.getDataContext());
        }
    }

    /*
     * WARNING - void declaration
     */
    private final ActionGroup createGroup(VcsLogUiEx ui2, List<Integer> rows) {
        void destination$iv;
        void $this$mapTo$iv;
        Iterable iterable = rows;
        Collection collection = new ArrayList();
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            void row2;
            int n = ((Number)item$iv).intValue();
            void var14_13 = destination$iv;
            boolean bl = false;
            VcsCommitMetadata vcsCommitMetadata = ui2.getTable().getModel().getCommitMetadata((int)row2);
            Intrinsics.checkNotNullExpressionValue((Object)vcsCommitMetadata, (String)"ui.table.model.getCommitMetadata(row)");
            String text2 = this.getActionText(vcsCommitMetadata);
            Object[] objectArray = new Object[]{text2};
            String string2 = VcsLogBundle.message("action.go.to.navigate.to", objectArray);
            var14_13.add(new DumbAwareAction(text2, this, ui2, (int)row2, string2){
                final /* synthetic */ GoToParentOrChildAction this$0;
                final /* synthetic */ VcsLogUiEx $ui;
                final /* synthetic */ int $row;
                {
                    this.this$0 = $receiver;
                    this.$ui = $ui;
                    this.$row = $row;
                    super($text, $super_call_param$1, null);
                }

                public void actionPerformed(@NotNull AnActionEvent e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    GoToParentOrChildAction.access$triggerUsage(this.this$0, this, e);
                    VcsLogNavigationUtil.jumpToRow(this.$ui, this.$row, false, true);
                }
            });
        }
        List actions2 = (List)destination$iv;
        return (ActionGroup)new DefaultActionGroup(actions2);
    }

    private final void triggerUsage(DumbAwareAction $this$triggerUsage, AnActionEvent e) {
        VcsLogUsageTriggerCollector.triggerUsage(e, $this$triggerUsage, arg_0 -> GoToParentOrChildAction.triggerUsage$lambda$1((Function1)new Function1<List<EventPair<?>>, Unit>(this){
            final /* synthetic */ GoToParentOrChildAction this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(List<EventPair<?>> data2) {
                data2.add(VcsLogUsageTriggerCollector.PARENT_COMMIT.with((Object)this.this$0.getParent()));
            }
        }, arg_0));
    }

    @NlsActions.ActionText
    private final String getActionText(VcsCommitMetadata commitMetadata) {
        if (!(commitMetadata instanceof LoadingDetails)) {
            long time = commitMetadata.getAuthorTime();
            String commitMessage = "\"" + StringUtil.shortenTextWithEllipsis((String)commitMetadata.getSubject(), (int)40, (int)0, (String)"...") + "\"";
            Object[] objectArray = new Object[]{((Hash)commitMetadata.getId()).toShortString(), commitMessage, CommitPresentationUtil.getAuthorPresentation(commitMetadata), DateFormatUtil.formatDate((long)time), DateFormatUtil.formatTime((long)time)};
            String string2 = VcsLogBundle.message("action.go.to.select.hash.subject.author.date.time", objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(\"action.go.to.se\u2026matUtil.formatTime(time))");
            return string2;
        }
        String string3 = ((Hash)commitMetadata.getId()).toShortString();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"commitMetadata.id.toShortString()");
        return string3;
    }

    private final List<Integer> getRowsToJump(VcsLogUiEx ui2) {
        int[] selectedRows = ui2.getTable().getSelectedRows();
        if (selectedRows.length != 1) {
            return CollectionsKt.emptyList();
        }
        VisibleGraph<Integer> visibleGraph = ui2.getDataPack().getVisibleGraph();
        Intrinsics.checkNotNullExpressionValue((Object)selectedRows, (String)"selectedRows");
        List<Integer> list = visibleGraph.getRowInfo(ArraysKt.single((int[])selectedRows)).getAdjacentRows(this.parent);
        Intrinsics.checkNotNullExpressionValue(list, (String)"ui.dataPack.visibleGraph\u2026).getAdjacentRows(parent)");
        return CollectionsKt.sorted((Iterable)list);
    }

    private static final void triggerUsage$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    public static final /* synthetic */ void access$triggerUsage(GoToParentOrChildAction $this, DumbAwareAction $receiver, AnActionEvent e) {
        $this.triggerUsage($receiver, e);
    }
}

