/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.impl;

import com.intellij.ide.caches.CachesInvalidator;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.io.PathKt;
import com.intellij.vcs.log.VcsLogBundle;
import com.intellij.vcs.log.util.PersistentUtil;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.jetbrains.annotations.NotNull;

public final class VcsLogCachesInvalidator
extends CachesInvalidator {
    private static final Logger LOG = Logger.getInstance(VcsLogCachesInvalidator.class);

    public synchronized boolean isValid() {
        if (Files.exists(PersistentUtil.getCorruptionMarkerFile(), new LinkOption[0])) {
            try {
                ProjectUtil.clearCachesForAllProjectsStartingWith((String)"vcs-log-v");
            }
            catch (Throwable e) {
                LOG.error(e);
            }
            boolean deleted2 = FileUtil.deleteWithRenaming((Path)PersistentUtil.LOG_CACHE);
            if (!deleted2) {
                Path corruptionMarkerFile = PersistentUtil.getCorruptionMarkerFile();
                try {
                    PathKt.createFile((Path)corruptionMarkerFile);
                }
                catch (Exception e) {
                    LOG.warn((Throwable)e);
                }
            } else {
                LOG.info("Deleted Vcs Log caches at " + PersistentUtil.LOG_CACHE);
            }
            return deleted2;
        }
        return true;
    }

    public void invalidateCaches() {
        boolean isEmpty = true;
        if (Files.exists(PersistentUtil.LOG_CACHE, new LinkOption[0])) {
            try (DirectoryStream<Path> stream2 = Files.newDirectoryStream(PersistentUtil.LOG_CACHE);){
                if (stream2.iterator().hasNext()) {
                    isEmpty = false;
                }
            }
            catch (IOException stream2) {
                // empty catch block
            }
        }
        if (!isEmpty) {
            try {
                PathKt.createFile((Path)PersistentUtil.getCorruptionMarkerFile());
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
            }
        }
    }

    @NotNull
    public String getDescription() {
        String string2 = VcsLogBundle.message("vcs.log.clear.caches.checkbox.description", new Object[0]);
        if (string2 == null) {
            VcsLogCachesInvalidator.$$$reportNull$$$0(0);
        }
        return string2;
    }

    @NotNull
    public Boolean optionalCheckboxDefaultValue() {
        Boolean bl = Boolean.FALSE;
        if (bl == null) {
            VcsLogCachesInvalidator.$$$reportNull$$$0(1);
        }
        return bl;
    }

    @NotNull
    public static VcsLogCachesInvalidator getInstance() {
        VcsLogCachesInvalidator vcsLogCachesInvalidator = (VcsLogCachesInvalidator)((Object)EP_NAME.findExtensionOrFail(VcsLogCachesInvalidator.class));
        if (vcsLogCachesInvalidator == null) {
            VcsLogCachesInvalidator.$$$reportNull$$$0(2);
        }
        return vcsLogCachesInvalidator;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/vcs/log/impl/VcsLogCachesInvalidator";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescription";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "optionalCheckboxDefaultValue";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

