/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.commit;

import com.intellij.history.LocalHistory;
import com.intellij.history.LocalHistoryAction;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsRoot;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangeListManagerImpl;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.CommitContext;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vcs.checkin.CheckinEnvironment;
import com.intellij.openapi.vcs.update.RefreshVFsSynchronously;
import com.intellij.vcs.commit.AbstractCommitter;
import com.intellij.vcs.commit.ChangeListCommitState;
import com.intellij.vcs.commit.ChangeListDataCleaner;
import com.intellij.vcs.commit.CommittedChangesCacheListener;
import com.intellij.vcs.commit.LocalChangesCommitterKt;
import com.intellij.vcs.commit.SaveCommittingDocumentsVetoerKt;
import com.intellij.vcs.commit.VcsCommitter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u00002\u00020\u0001B,\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\r\b\u0002\u0010\b\u001a\u00070\t\u00a2\u0006\u0002\b\n\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\u0012\u001a\u00020\u0013H\u0014J\u000e\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015H\u0002J\u0016\u0010\u0017\u001a\u00020\u00132\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015H\u0002J\b\u0010\u0019\u001a\u00020\u0013H\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001e\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u000f@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0013\u0010\b\u001a\u00070\t\u00a2\u0006\u0002\b\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/intellij/vcs/commit/LocalChangesCommitter;", "Lcom/intellij/vcs/commit/VcsCommitter;", "project", "Lcom/intellij/openapi/project/Project;", "commitState", "Lcom/intellij/vcs/commit/ChangeListCommitState;", "commitContext", "Lcom/intellij/openapi/vcs/changes/CommitContext;", "localHistoryActionName", "", "Lorg/jetbrains/annotations/Nls;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/vcs/commit/ChangeListCommitState;Lcom/intellij/openapi/vcs/changes/CommitContext;Ljava/lang/String;)V", "getCommitState", "()Lcom/intellij/vcs/commit/ChangeListCommitState;", "<set-?>", "", "isSuccess", "()Z", "commit", "", "commitChanges", "", "Lcom/intellij/openapi/vcs/AbstractVcs;", "commitWithoutChanges", "committedVcses", "refreshChanges", "intellij.platform.vcs.impl"})
@SourceDebugExtension(value={"SMAP\nLocalChangesCommitter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LocalChangesCommitter.kt\ncom/intellij/vcs/commit/LocalChangesCommitter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,111:1\n1611#2:112\n1855#2:113\n1856#2:115\n1612#2:116\n1855#2,2:117\n1#3:114\n*S KotlinDebug\n*F\n+ 1 LocalChangesCommitter.kt\ncom/intellij/vcs/commit/LocalChangesCommitter\n*L\n59#1:112\n59#1:113\n59#1:115\n59#1:116\n60#1:117,2\n59#1:114\n*E\n"})
public class LocalChangesCommitter
extends VcsCommitter {
    @NotNull
    private final ChangeListCommitState commitState;
    @NotNull
    private final String localHistoryActionName;
    private boolean isSuccess;

    public LocalChangesCommitter(@NotNull Project project2, @NotNull ChangeListCommitState commitState, @NotNull CommitContext commitContext, @NotNull String localHistoryActionName) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)commitState, (String)"commitState");
        Intrinsics.checkNotNullParameter((Object)((Object)commitContext), (String)"commitContext");
        Intrinsics.checkNotNullParameter((Object)localHistoryActionName, (String)"localHistoryActionName");
        super(project2, commitState.getChanges(), commitState.getCommitMessage(), commitContext, true);
        this.commitState = commitState;
        this.localHistoryActionName = localHistoryActionName;
        this.addResultHandler(new CommittedChangesCacheListener(project2));
        this.addResultHandler(new ChangeListDataCleaner(this));
    }

    public /* synthetic */ LocalChangesCommitter(Project project2, ChangeListCommitState changeListCommitState, CommitContext commitContext, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            String string3 = VcsBundle.message("commit.changes", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(\"commit.changes\")");
            string2 = string3;
        }
        this(project2, changeListCommitState, commitContext, string2);
    }

    @NotNull
    public final ChangeListCommitState getCommitState() {
        return this.commitState;
    }

    public final boolean isSuccess() {
        return this.isSuccess;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void commit() {
        try {
            SaveCommittingDocumentsVetoerKt.vetoDocumentSaving(this.getProject(), (Collection<? extends Change>)this.getChanges(), (Function0<Unit>)((Function0)new Function0<Unit>(this){
                final /* synthetic */ LocalChangesCommitter this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                public final void invoke() {
                    Set committedVcses = LocalChangesCommitter.access$commitChanges(this.this$0);
                    LocalChangesCommitter.access$commitWithoutChanges(this.this$0, committedVcses);
                }
            }));
            this.isSuccess = this.getCommitErrors().isEmpty();
        }
        finally {
            this.refreshChanges();
        }
    }

    private final Set<AbstractVcs> commitChanges() {
        Set committedVcses = new LinkedHashSet();
        ChangesUtil.processChangesByVcs(this.getProject(), (Collection<? extends Change>)this.getChanges(), (arg_0, arg_1) -> LocalChangesCommitter.commitChanges$lambda$0(committedVcses, this, arg_0, arg_1));
        return committedVcses;
    }

    /*
     * WARNING - void declaration
     */
    private final void commitWithoutChanges(Set<? extends AbstractVcs> committedVcses) {
        void destination$iv;
        void $this$mapNotNullTo$iv;
        Iterable iterable = LocalChangesCommitterKt.getCommitWithoutChangesRoots(this.getCommitContext());
        Collection collection = new LinkedHashSet();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv = $this$mapNotNullTo$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv.iterator();
        while (iterator.hasNext()) {
            AbstractVcs it$iv;
            Object element$iv$iv;
            Object element$iv = element$iv$iv = iterator.next();
            boolean bl = false;
            VcsRoot it = (VcsRoot)element$iv;
            boolean bl2 = false;
            if (it.getVcs() == null) continue;
            boolean bl3 = false;
            destination$iv.add(it$iv);
        }
        Set commitWithoutChangesVcses = (Set)destination$iv;
        Iterable $this$forEach$iv = SetsKt.minus((Set)commitWithoutChangesVcses, (Iterable)committedVcses);
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv) {
            AbstractVcs it = (AbstractVcs)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            this.vcsCommit(it, CollectionsKt.emptyList());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void refreshChanges() {
        try {
            LocalHistoryAction refreshAction2 = (LocalHistoryAction)ActionsKt.runReadAction((Function0)((Function0)new Function0<LocalHistoryAction>(this){
                final /* synthetic */ LocalChangesCommitter this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                public final LocalHistoryAction invoke() {
                    return LocalHistory.getInstance().startAction(LocalChangesCommitter.access$getLocalHistoryActionName$p(this.this$0));
                }
            }));
            if (!((Collection)this.getPathsToRefresh()).isEmpty()) {
                ChangeListManagerImpl.getInstanceImpl(this.getProject()).showLocalChangesInvalidated();
            }
            List toRefresh = new ArrayList();
            ChangesUtil.processChangesByVcs(this.getProject(), (Collection<? extends Change>)this.getChanges(), (arg_0, arg_1) -> LocalChangesCommitter.refreshChanges$lambda$3(toRefresh, arg_0, arg_1));
            if (!((Collection)toRefresh).isEmpty()) {
                String string2 = VcsBundle.message("commit.dialog.refresh.files", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(\"commit.dialog.refresh.files\")");
                AbstractCommitter.Companion.progress$intellij_platform_vcs_impl(string2);
                RefreshVFsSynchronously.updateChanges(toRefresh);
            }
            refreshAction2.finish();
            VcsDirtyScopeManager.getInstance(this.getProject()).filePathsDirty((Collection<? extends FilePath>)this.getPathsToRefresh(), null);
            LocalHistory.getInstance().putSystemLabel(this.getProject(), this.localHistoryActionName + ": " + this.getCommitMessage());
        }
        finally {
            ChangeListManager.getInstance(this.getProject()).invokeAfterUpdate(true, () -> LocalChangesCommitter.refreshChanges$lambda$4(this));
        }
    }

    private static final void commitChanges$lambda$0(Set $committedVcses, LocalChangesCommitter this$0, AbstractVcs vcs, List vcsChanges) {
        Intrinsics.checkNotNullParameter((Object)$committedVcses, (String)"$committedVcses");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)vcs, (String)"vcs");
        Intrinsics.checkNotNullParameter((Object)vcsChanges, (String)"vcsChanges");
        ((Collection)$committedVcses).add(vcs);
        this$0.vcsCommit(vcs, vcsChanges);
    }

    private static final void refreshChanges$lambda$3(List $toRefresh, AbstractVcs vcs, List changes) {
        Intrinsics.checkNotNullParameter((Object)$toRefresh, (String)"$toRefresh");
        Intrinsics.checkNotNullParameter((Object)vcs, (String)"vcs");
        Intrinsics.checkNotNullParameter((Object)changes, (String)"changes");
        CheckinEnvironment environment = vcs.getCheckinEnvironment();
        if (environment != null && environment.isRefreshAfterCommitNeeded()) {
            $toRefresh.addAll(changes);
        }
    }

    private static final void refreshChanges$lambda$4(LocalChangesCommitter this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.fireAfterRefresh();
    }

    public static final /* synthetic */ Set access$commitChanges(LocalChangesCommitter $this) {
        return $this.commitChanges();
    }

    public static final /* synthetic */ void access$commitWithoutChanges(LocalChangesCommitter $this, Set committedVcses) {
        $this.commitWithoutChanges(committedVcses);
    }

    public static final /* synthetic */ String access$getLocalHistoryActionName$p(LocalChangesCommitter $this) {
        return $this.localHistoryActionName;
    }
}

