/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.commit;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.changes.ui.ChangesTree;
import com.intellij.openapi.vcs.changes.ui.ChangesViewContentManager;
import com.intellij.openapi.vcs.changes.ui.CurrentBranchComponent;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.ui.ExperimentalUI;
import com.intellij.ui.content.Content;
import com.intellij.util.ui.update.UiNotifyConnector;
import java.awt.Component;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u00002\u00020\u0001B>\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0013\u0010\u0006\u001a\u000f\u0012\u000b\u0012\t\u0018\u00010\u0005\u00a2\u0006\u0002\b\b0\u0007\u0012\u0012\u0010\t\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\u0007\u00a2\u0006\u0002\u0010\fJ\b\u0010\u0019\u001a\u00020\u001aH\u0016J\n\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0002J\b\u0010\u001d\u001a\u00020\u001aH\u0002J\b\u0010\u001e\u001a\u00020\u001aH\u0016J\b\u0010\u001f\u001a\u00020\u001aH\u0016R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0006\u001a\u000f\u0012\u000b\u0012\t\u0018\u00010\u0005\u00a2\u0006\u0002\b\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006 "}, d2={"Lcom/intellij/vcs/commit/CommitTabTitleUpdater;", "Lcom/intellij/openapi/Disposable;", "tree", "Lcom/intellij/openapi/vcs/changes/ui/ChangesTree;", "tabName", "", "defaultTitle", "Lkotlin/Function0;", "Lorg/jetbrains/annotations/Nls;", "pathsProvider", "", "Lcom/intellij/openapi/vcs/FilePath;", "(Lcom/intellij/openapi/vcs/changes/ui/ChangesTree;Ljava/lang/String;Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function0;)V", "branchComponent", "Lcom/intellij/openapi/vcs/changes/ui/CurrentBranchComponent;", "getDefaultTitle", "()Lkotlin/jvm/functions/Function0;", "project", "Lcom/intellij/openapi/project/Project;", "getProject", "()Lcom/intellij/openapi/project/Project;", "getTabName", "()Ljava/lang/String;", "getTree", "()Lcom/intellij/openapi/vcs/changes/ui/ChangesTree;", "dispose", "", "getTab", "Lcom/intellij/ui/content/Content;", "setDefaultTitle", "start", "updateTab", "intellij.platform.vcs.impl"})
public class CommitTabTitleUpdater
implements Disposable {
    @NotNull
    private final ChangesTree tree;
    @NotNull
    private final String tabName;
    @NotNull
    private final Function0<String> defaultTitle;
    @NotNull
    private final CurrentBranchComponent branchComponent;

    /*
     * WARNING - void declaration
     */
    public CommitTabTitleUpdater(@NotNull ChangesTree tree2, @NotNull String tabName, @NotNull Function0<String> defaultTitle, @NotNull Function0<? extends Iterable<? extends FilePath>> pathsProvider) {
        void it;
        CurrentBranchComponent currentBranchComponent;
        Intrinsics.checkNotNullParameter((Object)((Object)tree2), (String)"tree");
        Intrinsics.checkNotNullParameter((Object)tabName, (String)"tabName");
        Intrinsics.checkNotNullParameter(defaultTitle, (String)"defaultTitle");
        Intrinsics.checkNotNullParameter(pathsProvider, (String)"pathsProvider");
        this.tree = tree2;
        this.tabName = tabName;
        this.defaultTitle = defaultTitle;
        CurrentBranchComponent currentBranchComponent2 = currentBranchComponent = new CurrentBranchComponent(this.tree, pathsProvider);
        CommitTabTitleUpdater commitTabTitleUpdater = this;
        boolean bl = false;
        Disposer.register((Disposable)this, (Disposable)((Disposable)it));
        commitTabTitleUpdater.branchComponent = currentBranchComponent;
    }

    @NotNull
    public final ChangesTree getTree() {
        return this.tree;
    }

    @NotNull
    public final String getTabName() {
        return this.tabName;
    }

    @NotNull
    public final Function0<String> getDefaultTitle() {
        return this.defaultTitle;
    }

    @NotNull
    public final Project getProject() {
        Project project2 = this.tree.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"tree.project");
        return project2;
    }

    public void start() {
        UiNotifyConnector.doWhenFirstShown((Component)((Component)((Object)this.tree)), () -> CommitTabTitleUpdater.start$lambda$1(this), (Disposable)this);
        this.branchComponent.addChangeListener((Function0<Unit>)((Function0)new Function0<Unit>((Object)this){

            public final void invoke() {
                ((CommitTabTitleUpdater)this.receiver).updateTab();
            }
        }), this);
        Disposer.register((Disposable)this, () -> CommitTabTitleUpdater.start$lambda$2(this));
    }

    public void updateTab() {
        String string2;
        Content content = this.getTab();
        if (content == null) {
            return;
        }
        Content tab = content;
        String branch = this.branchComponent.getText();
        if (ExperimentalUI.isNewUI()) {
            int contentsCount;
            ToolWindow toolWindow = ChangesViewContentManager.Companion.getToolWindowFor(this.getProject(), this.tabName);
            int n = toolWindow != null && (toolWindow = toolWindow.getContentManager()) != null ? toolWindow.getContentCount() : (contentsCount = 0);
            string2 = contentsCount == 1 ? null : VcsBundle.message("tab.title.commit", new Object[0]);
        } else {
            String string3 = branch;
            boolean bl = string3 != null ? !StringsKt.isBlank((CharSequence)string3) : false;
            if (bl) {
                Object[] objectArray = new Object[]{branch};
                string2 = VcsBundle.message("tab.title.commit.to.branch", objectArray);
            } else {
                string2 = VcsBundle.message("tab.title.commit", new Object[0]);
            }
        }
        tab.setDisplayName(string2);
        tab.setDescription(this.branchComponent.getToolTipText());
    }

    private final void setDefaultTitle() {
        Content content = this.getTab();
        if (content == null) {
            return;
        }
        Content tab = content;
        tab.setDisplayName((String)this.defaultTitle.invoke());
        tab.setDescription(null);
    }

    public void dispose() {
    }

    private final Content getTab() {
        return ChangesViewContentManager.Companion.getInstance(this.getProject()).findContent(this.tabName);
    }

    private static final void start$lambda$1(CommitTabTitleUpdater this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.updateTab();
    }

    private static final void start$lambda$2(CommitTabTitleUpdater this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.setDefaultTitle();
    }
}

