/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.smartUpdate;

import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.smartUpdate.SmartUpdate;
import com.intellij.smartUpdate.SmartUpdateBundle;
import com.intellij.smartUpdate.SmartUpdateStep;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.ButtonKt;
import com.intellij.ui.dsl.builder.Cell;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZoneId;
import java.util.Date;
import javax.swing.JComponent;
import javax.swing.JSpinner;
import javax.swing.SpinnerDateModel;
import javax.swing.SpinnerModel;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0014J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/intellij/smartUpdate/SmartUpdateDialog;", "Lcom/intellij/openapi/ui/DialogWrapper;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "createCenterPanel", "Lcom/intellij/openapi/ui/DialogPanel;", "getScheduled", "Ljava/util/Date;", "time", "Ljava/time/LocalTime;", "intellij.smart.update"})
@SourceDebugExtension(value={"SMAP\nSmartUpdateDialog.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SmartUpdateDialog.kt\ncom/intellij/smartUpdate/SmartUpdateDialog\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,56:1\n29#2,3:57\n*S KotlinDebug\n*F\n+ 1 SmartUpdateDialog.kt\ncom/intellij/smartUpdate/SmartUpdateDialog\n*L\n27#1:57,3\n*E\n"})
public final class SmartUpdateDialog
extends DialogWrapper {
    @NotNull
    private final Project project;

    public SmartUpdateDialog(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        super(project2);
        this.project = project2;
        this.setTitle(SmartUpdateBundle.INSTANCE.message("dialog.title.smart.update", new Object[0]));
        this.init();
    }

    @NotNull
    protected DialogPanel createCenterPanel() {
        ComponentManager $this$service$iv = (ComponentManager)this.project;
        boolean $i$f$service = false;
        Class<SmartUpdate> serviceClass$iv = SmartUpdate.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw new IllegalStateException(("Cannot find service " + serviceClass$iv.getName() + " in " + $this$service$iv + " (classloader=" + serviceClass$iv.getClassLoader()).toString());
        }
        SmartUpdate smartUpdate = (SmartUpdate)object;
        SmartUpdate.Options options = smartUpdate.getState();
        return BuilderKt.panel((Function1)((Function1)new Function1<Panel, Unit>(smartUpdate, this, options){
            final /* synthetic */ SmartUpdate $smartUpdate;
            final /* synthetic */ SmartUpdateDialog this$0;
            final /* synthetic */ SmartUpdate.Options $options;
            {
                this.$smartUpdate = $smartUpdate;
                this.this$0 = $receiver;
                this.$options = $options;
                super(1);
            }

            public final void invoke(@NotNull Panel $this$panel) {
                Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
                for (SmartUpdateStep step2 : this.$smartUpdate.availableSteps()) {
                    JComponent it;
                    boolean enabled = step2.isEnabled(SmartUpdateDialog.access$getProject$p(this.this$0));
                    Panel.row$default((Panel)$this$panel, null, (Function1)((Function1)new Function1<Row, Unit>(step2, enabled, this.$options){
                        final /* synthetic */ SmartUpdateStep $step;
                        final /* synthetic */ boolean $enabled;
                        final /* synthetic */ SmartUpdate.Options $options;
                        {
                            this.$step = $step;
                            this.$enabled = $enabled;
                            this.$options = $options;
                            super(1);
                        }

                        public final void invoke(@NotNull Row $this$row) {
                            Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                            ButtonKt.bindSelected((Cell)$this$row.checkBox(this.$step.getStepName()).enabled(this.$enabled), this.$options.property(this.$step.getId()));
                        }
                    }), (int)1, null);
                    if (step2.getDetailsComponent(SmartUpdateDialog.access$getProject$p(this.this$0)) == null) continue;
                    boolean bl = false;
                    $this$panel.indent((Function1)new Function1<Panel, Unit>(it, enabled){
                        final /* synthetic */ JComponent $it;
                        final /* synthetic */ boolean $enabled;
                        {
                            this.$it = $it;
                            this.$enabled = $enabled;
                            super(1);
                        }

                        public final void invoke(@NotNull Panel $this$indent) {
                            Intrinsics.checkNotNullParameter((Object)$this$indent, (String)"$this$indent");
                            Panel.row$default((Panel)$this$indent, null, (Function1)((Function1)new Function1<Row, Unit>(this.$it, this.$enabled){
                                final /* synthetic */ JComponent $it;
                                final /* synthetic */ boolean $enabled;
                                {
                                    this.$it = $it;
                                    this.$enabled = $enabled;
                                    super(1);
                                }

                                public final void invoke(@NotNull Row $this$row) {
                                    Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                                    $this$row.cell(this.$it).enabled(this.$enabled);
                                }
                            }), (int)1, null);
                        }
                    });
                }
                Ref.ObjectRef scheduled = new Ref.ObjectRef();
                Panel.row$default((Panel)$this$panel, null, (Function1)((Function1)new Function1<Row, Unit>((Ref.ObjectRef<Cell<JBCheckBox>>)scheduled, this.$options){
                    final /* synthetic */ Ref.ObjectRef<Cell<JBCheckBox>> $scheduled;
                    final /* synthetic */ SmartUpdate.Options $options;
                    {
                        this.$scheduled = $scheduled;
                        this.$options = $options;
                        super(1);
                    }

                    public final void invoke(@NotNull Row $this$row) {
                        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                        this.$scheduled.element = ButtonKt.bindSelected((Cell)$this$row.checkBox(SmartUpdateBundle.INSTANCE.message("checkbox.schedule.update", new Object[0])), (Function0)((Function0)new Function0<Boolean>(this.$options){
                            final /* synthetic */ SmartUpdate.Options $options;
                            {
                                this.$options = $options;
                                super(0);
                            }

                            @NotNull
                            public final Boolean invoke() {
                                return this.$options.getScheduled();
                            }
                        }), (Function1)((Function1)new Function1<Boolean, Unit>(this.$options){
                            final /* synthetic */ SmartUpdate.Options $options;
                            {
                                this.$options = $options;
                                super(1);
                            }

                            public final void invoke(boolean it) {
                                this.$options.setScheduled(it);
                            }
                        }));
                    }
                }), (int)1, null);
                $this$panel.indent((Function1)new Function1<Panel, Unit>((Ref.ObjectRef<Cell<JBCheckBox>>)scheduled, this.this$0, this.$options){
                    final /* synthetic */ Ref.ObjectRef<Cell<JBCheckBox>> $scheduled;
                    final /* synthetic */ SmartUpdateDialog this$0;
                    final /* synthetic */ SmartUpdate.Options $options;
                    {
                        this.$scheduled = $scheduled;
                        this.this$0 = $receiver;
                        this.$options = $options;
                        super(1);
                    }

                    public final void invoke(@NotNull Panel $this$indent) {
                        Cell cell;
                        Intrinsics.checkNotNullParameter((Object)$this$indent, (String)"$this$indent");
                        SpinnerDateModel spinnerDateModel = new SpinnerDateModel();
                        SmartUpdateDialog smartUpdateDialog = this.this$0;
                        SmartUpdate.Options options = this.$options;
                        SpinnerDateModel $this$invoke_u24lambda_u240 = spinnerDateModel;
                        boolean bl = false;
                        $this$invoke_u24lambda_u240.setValue(SmartUpdateDialog.access$getScheduled(smartUpdateDialog, options.getScheduledTime()));
                        SpinnerModel spinnerModel = spinnerDateModel;
                        JSpinner spinner = new JSpinner(spinnerModel);
                        spinner.setEditor(new JSpinner.DateEditor(spinner, "hh:mm"));
                        Row row2 = Panel.row$default((Panel)$this$indent, null, (Function1)((Function1)new Function1<Row, Unit>(spinner){
                            final /* synthetic */ JSpinner $spinner;
                            {
                                this.$spinner = $spinner;
                                super(1);
                            }

                            public final void invoke(@NotNull Row $this$row) {
                                Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                                $this$row.label(SmartUpdateBundle.INSTANCE.message("label.every.day.at", new Object[0]));
                                $this$row.cell((JComponent)this.$spinner);
                            }
                        }), (int)1, null);
                        if (this.$scheduled.element == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"scheduled");
                            cell = null;
                        } else {
                            cell = (Cell)this.$scheduled.element;
                        }
                        row2.enabledIf(ButtonKt.getSelected((Cell)cell));
                    }
                });
            }
        }));
    }

    private final Date getScheduled(LocalTime time) {
        Instant instant = time.atDate(LocalDate.now()).atZone(ZoneId.systemDefault()).toInstant();
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"time.atDate(LocalDate.no\u2026temDefault()).toInstant()");
        Instant instant2 = instant;
        Date date = Date.from(instant2);
        Intrinsics.checkNotNullExpressionValue((Object)date, (String)"from(instant)");
        return date;
    }

    public static final /* synthetic */ Project access$getProject$p(SmartUpdateDialog $this) {
        return $this.project;
    }

    public static final /* synthetic */ Date access$getScheduled(SmartUpdateDialog $this, LocalTime time) {
        return $this.getScheduled(time);
    }
}

