/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.merge;

import com.intellij.CommonBundle;
import com.intellij.configurationStore.StoreReloadManager;
import com.intellij.diff.DiffEditorTitleCustomizer;
import com.intellij.diff.DiffManager;
import com.intellij.diff.DiffRequestFactory;
import com.intellij.diff.InvalidDiffRequestException;
import com.intellij.diff.merge.MergeRequest;
import com.intellij.diff.merge.MergeResult;
import com.intellij.diff.merge.MergeUtil;
import com.intellij.diff.util.DiffUserDataKeysEx;
import com.intellij.diff.util.DiffUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.BooleanGetter;
import com.intellij.openapi.util.io.FileTooBigException;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNodeRenderer;
import com.intellij.openapi.vcs.changes.ui.ChangesGroupingPolicyFactory;
import com.intellij.openapi.vcs.changes.ui.ChangesGroupingSupport;
import com.intellij.openapi.vcs.changes.ui.NoneChangesGroupingFactory;
import com.intellij.openapi.vcs.changes.ui.TreeModelBuilder;
import com.intellij.openapi.vcs.changes.ui.VcsTreeModelData;
import com.intellij.openapi.vcs.merge.MergeConflictsTreeTable;
import com.intellij.openapi.vcs.merge.MergeData;
import com.intellij.openapi.vcs.merge.MergeDialogCustomizer;
import com.intellij.openapi.vcs.merge.MergeProvider;
import com.intellij.openapi.vcs.merge.MergeProvider2;
import com.intellij.openapi.vcs.merge.MergeSession;
import com.intellij.openapi.vcs.merge.MergeSessionEx;
import com.intellij.openapi.vcs.merge.MergeUtils;
import com.intellij.openapi.vcs.merge.MultipleFileMergeDialog;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.DoubleClickListener;
import com.intellij.ui.TableSpeedSearch;
import com.intellij.ui.UIBundle;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.AlignX;
import com.intellij.ui.dsl.builder.AlignY;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.ButtonKt;
import com.intellij.ui.dsl.builder.Cell;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.ui.treeStructure.treetable.ListTreeTableModelOnColumns;
import com.intellij.ui.treeStructure.treetable.TreeTable;
import com.intellij.ui.treeStructure.treetable.TreeTableModel;
import com.intellij.ui.treeStructure.treetable.TreeTableTree;
import com.intellij.util.EditSourceOnDoubleClickHandler;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeUtil;
import com.intellij.vcsUtil.VcsUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.event.ChangeEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmSuppressWildcards;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u00b3\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\b*\u0001&\b\u0016\u0018\u0000 S2\u00020\u0001:\u0003RSTB-\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+H\u0002J\u0016\u0010,\u001a\u00020\u00122\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060-H\u0015J\u0010\u0010.\u001a\u00020)2\u0006\u0010/\u001a\u00020\u0006H\u0002J\u0013\u00100\u001a\b\u0012\u0004\u0012\u00020201H\u0014\u00a2\u0006\u0002\u00103J\b\u00104\u001a\u000205H\u0014J\u001b\u00106\u001a\u0010\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030701H\u0002\u00a2\u0006\u0002\u00108J\b\u00109\u001a\u00020)H\u0014J\b\u0010:\u001a\u00020;H\u0015J\n\u0010<\u001a\u0004\u0018\u000105H\u0016J\u000e\u0010=\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0002J\u0010\u0010>\u001a\u00020+2\u0006\u0010?\u001a\u00020@H\u0002J\u0018\u0010A\u001a\u00020)2\u0006\u0010/\u001a\u00020\u00062\u0006\u0010*\u001a\u00020+H\u0002J\u001e\u0010B\u001a\u00020)2\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010*\u001a\u00020+H\u0002J \u0010C\u001a\u00020)2\u0006\u0010/\u001a\u00020\u00062\u0006\u0010*\u001a\u00020+2\u0006\u0010D\u001a\u00020EH\u0003J\b\u0010F\u001a\u00020)H\u0002J\b\u0010G\u001a\u00020)H\u0002J\u0010\u0010H\u001a\u00020)2\u0006\u0010I\u001a\u00020\u0012H\u0002J#\u0010J\u001a\u0004\u0018\u0001HK\"\u0004\b\u0000\u0010K2\f\u0010L\u001a\b\u0012\u0004\u0012\u0002HK0MH\u0002\u00a2\u0006\u0002\u0010NJ\b\u0010O\u001a\u00020)H\u0002J\b\u0010P\u001a\u00020)H\u0002J\b\u0010Q\u001a\u00020)H\u0002R\u000e\u0010\f\u001a\u00020\rX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082.\u00a2\u0006\u0002\n\u0000R&\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0011\u001a\u00020\u00128B@BX\u0082\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u000e\u0010\u0018\u001a\u00020\rX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0015\u0010\u0019\u001a\t\u0018\u00010\u001a\u00a2\u0006\u0002\b\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00060\u001d\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020#X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00060\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010%\u001a\u00020&X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010'\u00a8\u0006U"}, d2={"Lcom/intellij/openapi/vcs/merge/MultipleFileMergeDialog;", "Lcom/intellij/openapi/ui/DialogWrapper;", "project", "Lcom/intellij/openapi/project/Project;", "files", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "mergeProvider", "Lcom/intellij/openapi/vcs/merge/MergeProvider;", "mergeDialogCustomizer", "Lcom/intellij/openapi/vcs/merge/MergeDialogCustomizer;", "(Lcom/intellij/openapi/project/Project;Ljava/util/List;Lcom/intellij/openapi/vcs/merge/MergeProvider;Lcom/intellij/openapi/vcs/merge/MergeDialogCustomizer;)V", "acceptTheirsButton", "Ljavax/swing/JButton;", "acceptYoursButton", "descriptionLabel", "Ljavax/swing/JLabel;", "value", "", "groupByDirectory", "getGroupByDirectory", "()Z", "setGroupByDirectory", "(Z)V", "mergeButton", "mergeSession", "Lcom/intellij/openapi/vcs/merge/MergeSession;", "Lorg/jetbrains/annotations/NotNull;", "processedFiles", "", "getProcessedFiles", "()Ljava/util/List;", "table", "Lcom/intellij/ui/treeStructure/treetable/TreeTable;", "tableModel", "Lcom/intellij/ui/treeStructure/treetable/ListTreeTableModelOnColumns;", "unresolvedFiles", "virtualFileRenderer", "com/intellij/openapi/vcs/merge/MultipleFileMergeDialog$virtualFileRenderer$1", "Lcom/intellij/openapi/vcs/merge/MultipleFileMergeDialog$virtualFileRenderer$1;", "acceptRevision", "", "resolution", "Lcom/intellij/openapi/vcs/merge/MergeSession$Resolution;", "beforeResolve", "", "checkMarkModifiedProject", "file", "createActions", "", "Ljavax/swing/Action;", "()[Ljavax/swing/Action;", "createCenterPanel", "Ljavax/swing/JComponent;", "createColumns", "Lcom/intellij/util/ui/ColumnInfo;", "()[Lcom/intellij/util/ui/ColumnInfo;", "dispose", "getDimensionServiceKey", "", "getPreferredFocusedComponent", "getSelectedFiles", "getSessionResolution", "result", "Lcom/intellij/diff/merge/MergeResult;", "markFileProcessed", "markFilesProcessed", "resolveFileViaContent", "data", "Lcom/intellij/openapi/vcs/merge/MergeData;", "selectFirstFile", "showMergeDialog", "toggleGroupByDirectory", "state", "tryCompute", "T", "task", "Lkotlin/Function0;", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "updateButtonState", "updateModelFromFiles", "updateTree", "ColumnInfoAdapter", "Companion", "ConflictData", "intellij.platform.vcs.impl"})
@SourceDebugExtension(value={"SMAP\nMultipleFileMergeDialog.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MultipleFileMergeDialog.kt\ncom/intellij/openapi/vcs/merge/MultipleFileMergeDialog\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,509:1\n1#2:510\n11536#3,4:511\n37#4,2:515\n1747#5,3:517\n1747#5,3:520\n1855#5,2:523\n1855#5,2:525\n*S KotlinDebug\n*F\n+ 1 MultipleFileMergeDialog.kt\ncom/intellij/openapi/vcs/merge/MultipleFileMergeDialog\n*L\n207#1:511,4\n211#1:515,2\n247#1:517,3\n248#1:520,3\n353#1:523,2\n358#1:525,2\n*E\n"})
public class MultipleFileMergeDialog
extends DialogWrapper {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final Project project;
    @NotNull
    private final MergeProvider mergeProvider;
    @NotNull
    private final MergeDialogCustomizer mergeDialogCustomizer;
    @NotNull
    private List<VirtualFile> unresolvedFiles;
    @Nullable
    private final MergeSession mergeSession;
    @NotNull
    private final List<VirtualFile> processedFiles;
    @NotNull
    private final TreeTable table;
    private JButton acceptYoursButton;
    private JButton acceptTheirsButton;
    private JButton mergeButton;
    @NotNull
    private final ListTreeTableModelOnColumns tableModel;
    private JLabel descriptionLabel;
    private boolean groupByDirectory;
    @NotNull
    private final virtualFileRenderer.1 virtualFileRenderer;
    @NotNull
    private static final Logger LOG;

    public MultipleFileMergeDialog(@Nullable Project project2, @NotNull List<? extends VirtualFile> files2, @NotNull MergeProvider mergeProvider, @NotNull MergeDialogCustomizer mergeDialogCustomizer) {
        Intrinsics.checkNotNullParameter(files2, (String)"files");
        Intrinsics.checkNotNullParameter((Object)mergeProvider, (String)"mergeProvider");
        Intrinsics.checkNotNullParameter((Object)mergeDialogCustomizer, (String)"mergeDialogCustomizer");
        super(project2);
        this.project = project2;
        this.mergeProvider = mergeProvider;
        this.mergeDialogCustomizer = mergeDialogCustomizer;
        this.unresolvedFiles = CollectionsKt.toMutableList((Collection)files2);
        MergeProvider mergeProvider2 = this.mergeProvider;
        MergeProvider2 mergeProvider22 = mergeProvider2 instanceof MergeProvider2 ? (MergeProvider2)mergeProvider2 : null;
        this.mergeSession = mergeProvider22 != null ? mergeProvider22.createMergeSession(files2) : null;
        this.processedFiles = new ArrayList();
        this.tableModel = new ListTreeTableModelOnColumns((TreeNode)new DefaultMutableTreeNode(), this.createColumns());
        Project project3 = this.project;
        mergeProvider2 = () -> MultipleFileMergeDialog.virtualFileRenderer$lambda$0(this);
        this.virtualFileRenderer = new ChangesBrowserNodeRenderer(this, project3, (BooleanGetter)mergeProvider2){
            final /* synthetic */ MultipleFileMergeDialog this$0;
            {
                this.this$0 = $receiver;
                super($super_call_param$1, $super_call_param$2, false);
            }

            protected boolean calcFocusedState() {
                return UIUtil.isAncestor((Component)this.this$0.getPeer().getWindow(), (Component)IdeFocusManager.getInstance((Project)this.getProject()).getFocusOwner());
            }
        };
        Project project4 = this.project;
        if (project4 != null) {
            Project it = project4;
            boolean bl = false;
            StoreReloadManager.Companion.getInstance(this.project).blockReloadingProjectOnExternalChanges();
        }
        this.setTitle(this.mergeDialogCustomizer.getMultipleFileDialogTitle());
        this.virtualFileRenderer.setFont(UIUtil.getListFont());
        this.table = new MergeConflictsTreeTable(this.tableModel);
        this.table.setTreeCellRenderer((TreeCellRenderer)((Object)this.virtualFileRenderer));
        ((MergeConflictsTreeTable)this.table).setRowHeight(this.virtualFileRenderer.getPreferredSize().height);
        ((MergeConflictsTreeTable)this.table).setPreferredScrollableViewportSize((Dimension)JBUI.size((int)600, (int)300));
        this.init();
        this.updateTree();
        ((MergeConflictsTreeTable)this.table).getTree().getSelectionModel().addTreeSelectionListener(arg_0 -> MultipleFileMergeDialog._init_$lambda$2(this, arg_0));
        this.updateButtonState();
        this.selectFirstFile();
        new DoubleClickListener(){

            protected boolean onDoubleClick(@NotNull MouseEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                TreeTableTree treeTableTree = ((MergeConflictsTreeTable)table).getTree();
                Intrinsics.checkNotNullExpressionValue((Object)treeTableTree, (String)"table.tree");
                if (EditSourceOnDoubleClickHandler.isToggleEvent((JTree)((JTree)treeTableTree), (MouseEvent)event)) {
                    return false;
                }
                this.showMergeDialog();
                return true;
            }
        }.installOn((Component)((MergeConflictsTreeTable)this.table).getTree());
        TableSpeedSearch.installOn((JTable)((JTable)this.table), MultipleFileMergeDialog::_init_$lambda$3);
        JLabel jLabel = this.descriptionLabel;
        if (jLabel == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"descriptionLabel");
            jLabel = null;
        }
        ModalityState modalityState = ModalityState.stateForComponent((Component)jLabel);
        Intrinsics.checkNotNullExpressionValue((Object)modalityState, (String)"stateForComponent(descriptionLabel)");
        ModalityState modalityState2 = modalityState;
        BackgroundTaskUtil.executeOnPooledThread((Disposable)this.getDisposable(), () -> MultipleFileMergeDialog._init_$lambda$4(this, modalityState2));
    }

    @NotNull
    public final List<VirtualFile> getProcessedFiles() {
        return this.processedFiles;
    }

    private final boolean getGroupByDirectory() {
        return this.project != null ? VcsConfiguration.getInstance((Project)this.project).GROUP_MULTIFILE_MERGE_BY_DIRECTORY : this.groupByDirectory;
    }

    private final void setGroupByDirectory(boolean value2) {
        if (this.project != null) {
            VcsConfiguration.getInstance((Project)this.project).GROUP_MULTIFILE_MERGE_BY_DIRECTORY = value2;
        } else {
            this.groupByDirectory = value2;
        }
    }

    private final void selectFirstFile() {
        if (!this.getGroupByDirectory()) {
            this.table.getSelectionModel().setSelectionInterval(0, 0);
        } else {
            TreeUtil.promiseSelectFirstLeaf((JTree)((JTree)this.table.getTree()));
        }
    }

    @NotNull
    protected JComponent createCenterPanel() {
        DialogPanel dialogPanel;
        DialogPanel it = dialogPanel = BuilderKt.panel((Function1)((Function1)new Function1<Panel, Unit>(this){
            final /* synthetic */ MultipleFileMergeDialog this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull Panel $this$panel) {
                Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
                Panel.row$default((Panel)$this$panel, null, (Function1)((Function1)new Function1<Row, Unit>(this.this$0){
                    final /* synthetic */ MultipleFileMergeDialog this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(@NotNull Row $this$row) {
                        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                        String string2 = VcsBundle.message("merge.loading.merge.details", new Object[0]);
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(\"merge.loading.merge.details\")");
                        MultipleFileMergeDialog.access$setDescriptionLabel$p(this.this$0, (JLabel)$this$row.label(string2).getComponent());
                    }
                }), (int)1, null);
                Panel.row$default((Panel)$this$panel, null, (Function1)((Function1)new Function1<Row, Unit>(this.this$0){
                    final /* synthetic */ MultipleFileMergeDialog this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(@NotNull Row $this$row) {
                        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                        $this$row.scrollCell((JComponent)MultipleFileMergeDialog.access$getTable$p(this.this$0)).align(Align.FILL).resizableColumn();
                        $this$row.panel((Function1)new Function1<Panel, Unit>(this.this$0){
                            final /* synthetic */ MultipleFileMergeDialog this$0;
                            {
                                this.this$0 = $receiver;
                                super(1);
                            }

                            public final void invoke(@NotNull Panel $this$panel) {
                                Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
                                Panel.row$default((Panel)$this$panel, null, (Function1)((Function1)new Function1<Row, Unit>(this.this$0){
                                    final /* synthetic */ MultipleFileMergeDialog this$0;
                                    {
                                        this.this$0 = $receiver;
                                        super(1);
                                    }

                                    public final void invoke(@NotNull Row $this$row) {
                                        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                                        String string2 = VcsBundle.message("multiple.file.merge.accept.yours", new Object[0]);
                                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(\"multiple.file.merge.accept.yours\")");
                                        MultipleFileMergeDialog.access$setAcceptYoursButton$p(this.this$0, (JButton)$this$row.button(string2, (Function1)new Function1<ActionEvent, Unit>(this.this$0){
                                            final /* synthetic */ MultipleFileMergeDialog this$0;
                                            {
                                                this.this$0 = $receiver;
                                                super(1);
                                            }

                                            public final void invoke(@NotNull ActionEvent it) {
                                                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                                                MultipleFileMergeDialog.access$acceptRevision(this.this$0, MergeSession.Resolution.AcceptedYours);
                                            }
                                        }).align((Align)AlignX.FILL.INSTANCE).getComponent());
                                    }
                                }), (int)1, null);
                                Panel.row$default((Panel)$this$panel, null, (Function1)((Function1)new Function1<Row, Unit>(this.this$0){
                                    final /* synthetic */ MultipleFileMergeDialog this$0;
                                    {
                                        this.this$0 = $receiver;
                                        super(1);
                                    }

                                    public final void invoke(@NotNull Row $this$row) {
                                        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                                        String string2 = VcsBundle.message("multiple.file.merge.accept.theirs", new Object[0]);
                                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(\"multiple.file.merge.accept.theirs\")");
                                        MultipleFileMergeDialog.access$setAcceptTheirsButton$p(this.this$0, (JButton)$this$row.button(string2, (Function1)new Function1<ActionEvent, Unit>(this.this$0){
                                            final /* synthetic */ MultipleFileMergeDialog this$0;
                                            {
                                                this.this$0 = $receiver;
                                                super(1);
                                            }

                                            public final void invoke(@NotNull ActionEvent it) {
                                                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                                                MultipleFileMergeDialog.access$acceptRevision(this.this$0, MergeSession.Resolution.AcceptedTheirs);
                                            }
                                        }).align((Align)AlignX.FILL.INSTANCE).getComponent());
                                    }
                                }), (int)1, null);
                                Panel.row$default((Panel)$this$panel, null, (Function1)((Function1)new Function1<Row, Unit>(this.this$0){
                                    final /* synthetic */ MultipleFileMergeDialog this$0;
                                    {
                                        this.this$0 = $receiver;
                                        super(1);
                                    }

                                    public final void invoke(@NotNull Row $this$row) {
                                        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                                        String string2 = VcsBundle.message("multiple.file.merge.merge", new Object[0]);
                                        AbstractAction mergeAction2 = new AbstractAction(this.this$0, string2){
                                            final /* synthetic */ MultipleFileMergeDialog this$0;
                                            {
                                                this.this$0 = $receiver;
                                                super($super_call_param$1);
                                            }

                                            public void actionPerformed(@NotNull ActionEvent e) {
                                                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                                                MultipleFileMergeDialog.access$showMergeDialog(this.this$0);
                                            }
                                        };
                                        mergeAction2.putValue("DefaultAction", true);
                                        JButton jButton = MultipleFileMergeDialog.access$createJButtonForAction(this.this$0, mergeAction2);
                                        Intrinsics.checkNotNullExpressionValue((Object)jButton, (String)"createJButtonForAction(mergeAction)");
                                        MultipleFileMergeDialog.access$setMergeButton$p(this.this$0, jButton);
                                        JButton jButton2 = MultipleFileMergeDialog.access$getMergeButton$p(this.this$0);
                                        if (jButton2 == null) {
                                            Intrinsics.throwUninitializedPropertyAccessException((String)"mergeButton");
                                            jButton2 = null;
                                        }
                                        $this$row.cell((JComponent)jButton2).align((Align)AlignX.FILL.INSTANCE);
                                    }
                                }), (int)1, null);
                            }
                        }).align((Align)AlignY.TOP.INSTANCE);
                    }
                }), (int)1, null).resizableRow();
                if (MultipleFileMergeDialog.access$getProject$p(this.this$0) != null) {
                    Panel.row$default((Panel)$this$panel, null, (Function1)((Function1)new Function1<Row, Unit>(this.this$0){
                        final /* synthetic */ MultipleFileMergeDialog this$0;
                        {
                            this.this$0 = $receiver;
                            super(1);
                        }

                        public final void invoke(@NotNull Row $this$row) {
                            Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                            String string2 = VcsBundle.message("multiple.file.merge.group.by.directory.checkbox", new Object[0]);
                            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(\"multiple.file.m\u2026p.by.directory.checkbox\")");
                            ButtonKt.selected((Cell)$this$row.checkBox(string2), (boolean)MultipleFileMergeDialog.access$getGroupByDirectory(this.this$0)).applyToComponent((Function1)new Function1<JBCheckBox, Unit>(this.this$0){
                                final /* synthetic */ MultipleFileMergeDialog this$0;
                                {
                                    this.this$0 = $receiver;
                                    super(1);
                                }

                                public final void invoke(@NotNull JBCheckBox $this$applyToComponent) {
                                    Intrinsics.checkNotNullParameter((Object)$this$applyToComponent, (String)"$this$applyToComponent");
                                    $this$applyToComponent.addChangeListener(arg_0 -> createCenterPanel.1.invoke$lambda$0(this.this$0, $this$applyToComponent, arg_0));
                                }

                                private static final void invoke$lambda$0(MultipleFileMergeDialog this$0, JBCheckBox $this_applyToComponent, ChangeEvent it) {
                                    Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
                                    Intrinsics.checkNotNullParameter((Object)$this_applyToComponent, (String)"$this_applyToComponent");
                                    MultipleFileMergeDialog.access$toggleGroupByDirectory(this$0, $this_applyToComponent.isSelected());
                                }
                            });
                        }
                    }), (int)1, null);
                }
            }
        }));
        boolean bl = false;
        it.setMinimumSize((Dimension)JBUI.size((int)200, (int)150));
        return (JComponent)dialogPanel;
    }

    /*
     * WARNING - void declaration
     */
    private final ColumnInfo<?, ?>[] createColumns() {
        ColumnInfo[] mergeInfoColumns;
        ArrayList<createColumns.1> columns = new ArrayList<createColumns.1>();
        String string2 = VcsBundle.message("multiple.file.merge.column.name", new Object[0]);
        columns.add(new ColumnInfo<DefaultMutableTreeNode, Object>(string2){

            public Object valueOf(@NotNull DefaultMutableTreeNode node) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                return node.getUserObject();
            }

            @NotNull
            public Class<?> getColumnClass() {
                return TreeTableModel.class;
            }
        });
        MergeSession mergeSession = this.mergeSession;
        Object object = mergeInfoColumns = mergeSession != null ? mergeSession.getMergeInfoColumns() : null;
        if (mergeInfoColumns != null) {
            List<String> customColumnNames = null;
            customColumnNames = this.mergeDialogCustomizer.getColumnNames();
            if (customColumnNames != null && customColumnNames.size() != mergeInfoColumns.length) {
                LOG.error("Custom column names (" + customColumnNames + ") don't match default columns (" + mergeInfoColumns + ")");
                customColumnNames = null;
            }
            ColumnInfo[] $this$mapIndexedTo$iv = mergeInfoColumns;
            boolean $i$f$mapIndexedTo = false;
            int index$iv = 0;
            for (ColumnInfo item$iv : $this$mapIndexedTo$iv) {
                void index;
                void columnInfo;
                int n = index$iv++;
                ColumnInfo columnInfo2 = item$iv;
                int n2 = n;
                Collection collection = columns;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)columnInfo, (String)"columnInfo");
                List<String> list = customColumnNames;
                if (list == null || (list = list.get((int)index)) == null) {
                    list = columnInfo.getName();
                }
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"customColumnNames?.get(index) ?: columnInfo.name");
                collection.add(new ColumnInfoAdapter((ColumnInfo<Object, Object>)columnInfo, (String)((Object)list)));
            }
        }
        Collection $this$toTypedArray$iv = columns;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new ColumnInfo[0]);
    }

    private final void toggleGroupByDirectory(boolean state) {
        block2: {
            DefaultMutableTreeNode node;
            if (this.getGroupByDirectory() == state) {
                return;
            }
            this.setGroupByDirectory(state);
            VirtualFile firstSelectedFile = (VirtualFile)CollectionsKt.firstOrNull(this.getSelectedFiles());
            this.updateTree();
            if (firstSelectedFile == null) break block2;
            Object object = this.tableModel.getRoot();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type javax.swing.tree.DefaultMutableTreeNode");
            DefaultMutableTreeNode defaultMutableTreeNode = node = TreeUtil.findNodeWithObject((DefaultMutableTreeNode)((DefaultMutableTreeNode)object), (Object)firstSelectedFile);
            if (defaultMutableTreeNode != null) {
                DefaultMutableTreeNode it = defaultMutableTreeNode;
                boolean bl = false;
                TreeUtil.selectNode((JTree)((JTree)this.table.getTree()), (TreeNode)node);
            }
        }
    }

    private final void updateTree() {
        block0: {
            ChangesGroupingPolicyFactory factory = this.project != null && this.getGroupByDirectory() ? ChangesGroupingSupport.Companion.getFactory("directory") : (ChangesGroupingPolicyFactory)NoneChangesGroupingFactory.INSTANCE;
            DefaultTreeModel defaultTreeModel = TreeModelBuilder.buildFromVirtualFiles(this.project, factory, (Collection<? extends VirtualFile>)this.unresolvedFiles);
            Intrinsics.checkNotNullExpressionValue((Object)defaultTreeModel, (String)"buildFromVirtualFiles(pr\u2026factory, unresolvedFiles)");
            DefaultTreeModel model2 = defaultTreeModel;
            Object object = model2.getRoot();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type javax.swing.tree.TreeNode");
            this.tableModel.setRoot((TreeNode)object);
            TreeUtil.expandAll((JTree)((JTree)this.table.getTree()));
            TableModel tableModel = this.table.getModel();
            AbstractTableModel abstractTableModel = tableModel instanceof AbstractTableModel ? (AbstractTableModel)tableModel : null;
            if (abstractTableModel == null) break block0;
            abstractTableModel.fireTableDataChanged();
        }
    }

    private final void updateButtonState() {
        JButton jButton;
        boolean haveUnacceptableFiles;
        boolean haveUnmergeableFiles;
        boolean haveSelection;
        block10: {
            boolean bl;
            List<VirtualFile> selectedFiles;
            block9: {
                selectedFiles = this.getSelectedFiles();
                haveSelection = CollectionsKt.any((Iterable)selectedFiles);
                Iterable $this$any$iv = selectedFiles;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        VirtualFile it = (VirtualFile)element$iv;
                        boolean bl2 = false;
                        MergeSession mergeSession = this.mergeSession;
                        boolean bl3 = mergeSession != null ? !mergeSession.canMerge(it) : false;
                        if (!bl3) continue;
                        bl = true;
                        break block9;
                    }
                    bl = false;
                }
            }
            haveUnmergeableFiles = bl;
            Iterable $this$any$iv = selectedFiles;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                v3 = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    VirtualFile it = (VirtualFile)element$iv;
                    boolean bl4 = false;
                    if (!(this.mergeSession != null && !(this.mergeSession instanceof MergeSessionEx) && !this.mergeSession.canMerge(it))) continue;
                    v3 = true;
                    break block10;
                }
                v3 = haveUnacceptableFiles = false;
            }
        }
        if ((jButton = this.acceptYoursButton) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"acceptYoursButton");
            jButton = null;
        }
        jButton.setEnabled(haveSelection && !haveUnacceptableFiles);
        JButton jButton2 = this.acceptTheirsButton;
        if (jButton2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"acceptTheirsButton");
            jButton2 = null;
        }
        jButton2.setEnabled(haveSelection && !haveUnacceptableFiles);
        JButton jButton3 = this.mergeButton;
        if (jButton3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mergeButton");
            jButton3 = null;
        }
        jButton3.setEnabled(haveSelection && !haveUnmergeableFiles);
    }

    private final List<VirtualFile> getSelectedFiles() {
        List<VirtualFile> list = VcsTreeModelData.selected((JTree)this.table.getTree()).userObjects(VirtualFile.class);
        Intrinsics.checkNotNullExpressionValue(list, (String)"selected(table.tree).use\u2026(VirtualFile::class.java)");
        return list;
    }

    @NotNull
    protected Action[] createActions() {
        this.getCancelAction().putValue("Name", CommonBundle.getCloseButtonText());
        Action[] actionArray = new Action[1];
        Intrinsics.checkNotNullExpressionValue((Object)this.getCancelAction(), (String)"cancelAction");
        return actionArray;
    }

    protected void dispose() {
        Project project2 = this.project;
        if (project2 != null) {
            Project it = project2;
            boolean bl = false;
            StoreReloadManager.Companion.getInstance(this.project).unblockReloadingProjectOnExternalChanges();
        }
        super.dispose();
    }

    @NonNls
    @NotNull
    protected String getDimensionServiceKey() {
        return "MultipleFileMergeDialog";
    }

    @JvmSuppressWildcards
    protected boolean beforeResolve(@NotNull Collection<VirtualFile> files2) {
        Intrinsics.checkNotNullParameter(files2, (String)"files");
        return true;
    }

    private final void acceptRevision(MergeSession.Resolution resolution) {
        boolean bl;
        boolean bl2 = bl = resolution == MergeSession.Resolution.AcceptedYours || resolution == MergeSession.Resolution.AcceptedTheirs;
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        FileDocumentManager.getInstance().saveAllDocuments();
        List<VirtualFile> files2 = this.getSelectedFiles();
        Project project2 = this.project;
        String string3 = VcsBundle.message("multiple.file.merge.dialog.progress.title.resolving.conflicts", new Object[0]);
        ProgressManager.getInstance().run((Task)new Task.Modal(this, files2, resolution, project2, string3){
            final /* synthetic */ MultipleFileMergeDialog this$0;
            final /* synthetic */ List<VirtualFile> $files;
            final /* synthetic */ MergeSession.Resolution $resolution;
            {
                this.this$0 = $receiver;
                this.$files = $files;
                this.$resolution = $resolution;
                super($super_call_param$1, $super_call_param$2, false);
            }

            public void run(@NotNull ProgressIndicator indicator) {
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                if (!this.this$0.beforeResolve((Collection<VirtualFile>)this.$files)) {
                    return;
                }
                try {
                    if (MultipleFileMergeDialog.access$getMergeSession$p(this.this$0) instanceof MergeSessionEx) {
                        ((MergeSessionEx)MultipleFileMergeDialog.access$getMergeSession$p(this.this$0)).acceptFilesRevisions(this.$files, this.$resolution);
                        for (VirtualFile file : this.$files) {
                            MultipleFileMergeDialog.access$checkMarkModifiedProject(this.this$0, file);
                        }
                        MultipleFileMergeDialog.access$markFilesProcessed(this.this$0, this.$files, this.$resolution);
                    } else {
                        for (VirtualFile file : this.$files) {
                            MergeData data2;
                            Intrinsics.checkNotNullExpressionValue((Object)MultipleFileMergeDialog.access$getMergeProvider$p(this.this$0).loadRevisions(file), (String)"mergeProvider.loadRevisions(file)");
                            ApplicationManager.getApplication().invokeAndWait(() -> acceptRevision.1.run$lambda$0(this.this$0, file, this.$resolution, data2), indicator.getModalityState());
                            MultipleFileMergeDialog.access$checkMarkModifiedProject(this.this$0, file);
                            MultipleFileMergeDialog.access$markFileProcessed(this.this$0, file, this.$resolution);
                        }
                    }
                }
                catch (Exception e) {
                    MultipleFileMergeDialog.access$getLOG$cp().warn((Throwable)e);
                    ApplicationManager.getApplication().invokeAndWait(() -> acceptRevision.1.run$lambda$1(this.this$0, e), indicator.getModalityState());
                }
            }

            private static final void run$lambda$0(MultipleFileMergeDialog this$0, VirtualFile $file, MergeSession.Resolution $resolution, MergeData $data) {
                Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
                Intrinsics.checkNotNullParameter((Object)$file, (String)"$file");
                Intrinsics.checkNotNullParameter((Object)((Object)$resolution), (String)"$resolution");
                Intrinsics.checkNotNullParameter((Object)$data, (String)"$data");
                MultipleFileMergeDialog.access$resolveFileViaContent(this$0, $file, $resolution, $data);
            }

            private static final void run$lambda$1(MultipleFileMergeDialog this$0, Exception $e) {
                Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
                Intrinsics.checkNotNullParameter((Object)$e, (String)"$e");
                Object[] objectArray = new Object[]{$e.getMessage()};
                Messages.showErrorDialog((Component)this$0.getContentPanel(), (String)VcsBundle.message("multiple.file.merge.dialog.message.error.saving.merged.data", objectArray));
            }
        });
        this.updateModelFromFiles();
    }

    @RequiresEdt
    private final void resolveFileViaContent(VirtualFile file, MergeSession.Resolution resolution, MergeData data2) {
        if (!DiffUtil.makeWritable((Project)this.project, (VirtualFile)file)) {
            Object[] objectArray = new Object[]{file.getPresentableUrl()};
            throw new IOException(UIBundle.message((String)"file.is.read.only.message.text", (Object[])objectArray));
        }
        boolean isCurrent = resolution == MergeSession.Resolution.AcceptedYours;
        String string2 = isCurrent ? VcsBundle.message("multiple.file.merge.dialog.command.name.accept.yours", new Object[0]) : VcsBundle.message("multiple.file.merge.dialog.command.name.accept.theirs", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"if (isCurrent) VcsBundle\u2026mand.name.accept.theirs\")");
        String message2 = string2;
        WriteCommandAction.writeCommandAction((Project)this.project).withName(message2).run(() -> MultipleFileMergeDialog.resolveFileViaContent$lambda$11(isCurrent, file, data2));
    }

    private final void markFilesProcessed(List<? extends VirtualFile> files2, MergeSession.Resolution resolution) {
        this.unresolvedFiles.removeAll((Collection)files2);
        if (this.mergeSession instanceof MergeSessionEx) {
            ((MergeSessionEx)this.mergeSession).conflictResolvedForFiles(files2, resolution);
        } else if (this.mergeSession != null) {
            Iterable $this$forEach$iv = files2;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                VirtualFile it = (VirtualFile)element$iv;
                boolean bl = false;
                this.mergeSession.conflictResolvedForFile(it, resolution);
            }
        } else {
            Iterable $this$forEach$iv = files2;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                VirtualFile it = (VirtualFile)element$iv;
                boolean bl = false;
                this.mergeProvider.conflictResolvedForFile(it);
            }
        }
        this.processedFiles.addAll((Collection<VirtualFile>)files2);
        if (this.project != null) {
            VcsDirtyScopeManager.getInstance(this.project).filesDirty((Collection<? extends VirtualFile>)files2, CollectionsKt.emptyList());
        }
    }

    private final void markFileProcessed(VirtualFile file, MergeSession.Resolution resolution) {
        this.markFilesProcessed(CollectionsKt.listOf((Object)file), resolution);
    }

    private final void updateModelFromFiles() {
        if (this.unresolvedFiles.isEmpty()) {
            this.doCancelAction();
        } else {
            int selIndex = this.table.getSelectionModel().getMinSelectionIndex();
            this.updateTree();
            if (selIndex >= this.table.getRowCount()) {
                selIndex = this.table.getRowCount() - 1;
            }
            this.table.getSelectionModel().setSelectionInterval(selIndex, selIndex);
            this.table.requestFocusInWindow();
        }
    }

    private final void showMergeDialog() {
        DiffRequestFactory diffRequestFactory = DiffRequestFactory.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)diffRequestFactory, (String)"getInstance()");
        DiffRequestFactory requestFactory = diffRequestFactory;
        List<VirtualFile> files2 = this.getSelectedFiles();
        if (files2.isEmpty()) {
            return;
        }
        if (!this.beforeResolve((Collection<VirtualFile>)files2)) {
            return;
        }
        for (VirtualFile file : files2) {
            Intrinsics.checkNotNullExpressionValue((Object)VcsUtil.getFilePath(file), (String)"getFilePath(file)");
            ConflictData conflictData = null;
            try {
                FilePath filePath;
                Object object = ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> MultipleFileMergeDialog.showMergeDialog$lambda$14(this, file, filePath), VcsBundle.message("multiple.file.merge.dialog.progress.title.loading.revisions", new Object[0]), true, this.project);
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getInstance().runProcess\u2026visions\"), true, project)");
                conflictData = (ConflictData)object;
            }
            catch (VcsException ex) {
                Object[] objectArray = new Object[]{ex.getMessage()};
                Messages.showErrorDialog((Component)this.getContentPanel(), (String)VcsBundle.message("multiple.file.merge.dialog.error.loading.revisions.to.merge", objectArray));
                break;
            }
            MergeData mergeData = conflictData.getMergeData();
            byte[][] byArrayArray = new byte[][]{mergeData.CURRENT, mergeData.ORIGINAL, mergeData.LAST};
            List byteContents = CollectionsKt.listOf((Object[])((Object[])byArrayArray));
            List<String> contentTitles = conflictData.getContentTitles();
            String title2 = conflictData.getTitle();
            Function1 callback2 = (Function1)new Function1<MergeResult, Unit>(file, this){
                final /* synthetic */ VirtualFile $file;
                final /* synthetic */ MultipleFileMergeDialog this$0;
                {
                    this.$file = $file;
                    this.this$0 = $receiver;
                    super(1);
                }

                public final void invoke(@NotNull MergeResult result2) {
                    Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
                    Document document2 = FileDocumentManager.getInstance().getCachedDocument(this.$file);
                    if (document2 != null) {
                        FileDocumentManager.getInstance().saveDocument(document2);
                    }
                    MultipleFileMergeDialog.access$checkMarkModifiedProject(this.this$0, this.$file);
                    if (result2 != MergeResult.CANCEL) {
                        ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> showMergeDialog.callback.1.invoke$lambda$0(this.this$0, this.$file, result2), VcsBundle.message("multiple.file.merge.dialog.progress.title.resolving.conflicts", new Object[0]), true, MultipleFileMergeDialog.access$getProject$p(this.this$0), this.this$0.getContentPanel());
                    }
                }

                private static final void invoke$lambda$0(MultipleFileMergeDialog this$0, VirtualFile $file, MergeResult $result) {
                    Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
                    Intrinsics.checkNotNullParameter((Object)$file, (String)"$file");
                    Intrinsics.checkNotNullParameter((Object)$result, (String)"$result");
                    MultipleFileMergeDialog.access$markFileProcessed(this$0, $file, MultipleFileMergeDialog.access$getSessionResolution(this$0, $result));
                }
            };
            MergeRequest request = null;
            try {
                if (this.mergeProvider.isBinary(file)) {
                    MergeRequest mergeRequest = requestFactory.createBinaryMergeRequest(this.project, file, byteContents, title2, contentTitles, arg_0 -> MultipleFileMergeDialog.showMergeDialog$lambda$15(callback2, arg_0));
                    Intrinsics.checkNotNullExpressionValue((Object)mergeRequest, (String)"requestFactory.createBin\u2026 contentTitles, callback)");
                    request = mergeRequest;
                } else {
                    MergeRequest mergeRequest = requestFactory.createMergeRequest(this.project, file, byteContents, title2, contentTitles, arg_0 -> MultipleFileMergeDialog.showMergeDialog$lambda$16(callback2, arg_0));
                    Intrinsics.checkNotNullExpressionValue((Object)mergeRequest, (String)"requestFactory.createMer\u2026 contentTitles, callback)");
                    request = mergeRequest;
                }
                MergeUtils.putRevisionInfos(request, mergeData);
            }
            catch (InvalidDiffRequestException e) {
                if (e.getCause() instanceof FileTooBigException) {
                    Messages.showErrorDialog((Component)this.getContentPanel(), (String)VcsBundle.message("multiple.file.merge.dialog.message.file.too.big.to.be.loaded", new Object[0]), (String)VcsBundle.message("multiple.file.merge.dialog.title.can.t.show.merge.dialog", new Object[0]));
                    break;
                }
                LOG.error((Throwable)e);
                Messages.showErrorDialog((Component)this.getContentPanel(), (String)e.getMessage(), (String)VcsBundle.message("multiple.file.merge.dialog.title.can.t.show.merge.dialog", new Object[0]));
                break;
            }
            MergeDialogCustomizer.DiffEditorTitleCustomizerList $this$showMergeDialog_u24lambda_u2417 = conflictData.getContentTitleCustomizers();
            boolean bl = false;
            Object[] objectArray = new DiffEditorTitleCustomizer[]{$this$showMergeDialog_u24lambda_u2417.getLeftTitleCustomizer(), $this$showMergeDialog_u24lambda_u2417.getCenterTitleCustomizer(), $this$showMergeDialog_u24lambda_u2417.getRightTitleCustomizer()};
            request.putUserData(DiffUserDataKeysEx.EDITORS_TITLE_CUSTOMIZER, (Object)CollectionsKt.listOf((Object[])objectArray));
            DiffManager.getInstance().showMerge(this.project, request);
        }
        this.updateModelFromFiles();
    }

    private final MergeSession.Resolution getSessionResolution(MergeResult result2) {
        return switch (WhenMappings.$EnumSwitchMapping$0[result2.ordinal()]) {
            case 1 -> MergeSession.Resolution.AcceptedYours;
            case 2 -> MergeSession.Resolution.AcceptedTheirs;
            case 3 -> MergeSession.Resolution.Merged;
            default -> throw new IllegalArgumentException(result2.name());
        };
    }

    private final void checkMarkModifiedProject(VirtualFile file) {
        MergeUtil.reportProjectFileChangeIfNeeded((Project)this.project, (VirtualFile)file);
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return (JComponent)this.table;
    }

    private final <T> T tryCompute(Function0<? extends T> task2) {
        try {
            return (T)task2.invoke();
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (VcsException e) {
            LOG.warn((Throwable)e);
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
        }
        return null;
    }

    private static final boolean virtualFileRenderer$lambda$0(MultipleFileMergeDialog this$0) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        return !this$0.getGroupByDirectory();
    }

    private static final void _init_$lambda$2(MultipleFileMergeDialog this$0, TreeSelectionEvent it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.updateButtonState();
    }

    private static final String _init_$lambda$3(Object it) {
        VirtualFile virtualFile = it instanceof VirtualFile ? (VirtualFile)it : null;
        return virtualFile != null ? virtualFile.getName() : null;
    }

    private static final void _init_$lambda$4(MultipleFileMergeDialog this$0, ModalityState $modalityState) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$modalityState, (String)"$modalityState");
        String description2 = this$0.mergeDialogCustomizer.getMultipleFileMergeDescription((Collection<VirtualFile>)this$0.unresolvedFiles);
        ActionsKt.runInEdt((ModalityState)$modalityState, (Function0)((Function0)new Function0<Unit>(this$0, description2){
            final /* synthetic */ MultipleFileMergeDialog this$0;
            final /* synthetic */ String $description;
            {
                this.this$0 = $receiver;
                this.$description = $description;
                super(0);
            }

            public final void invoke() {
                JLabel jLabel = MultipleFileMergeDialog.access$getDescriptionLabel$p(this.this$0);
                if (jLabel == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"descriptionLabel");
                    jLabel = null;
                }
                jLabel.setText(this.$description);
            }
        }));
    }

    private static final void resolveFileViaContent$lambda$11(boolean $isCurrent, VirtualFile $file, MergeData $data) {
        Intrinsics.checkNotNullParameter((Object)$file, (String)"$file");
        Intrinsics.checkNotNullParameter((Object)$data, (String)"$data");
        if ($isCurrent) {
            $file.setBinaryContent($data.CURRENT);
        } else {
            $file.setBinaryContent($data.LAST);
        }
    }

    private static final ConflictData showMergeDialog$lambda$14(MultipleFileMergeDialog this$0, VirtualFile $file, FilePath $filePath) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$file, (String)"$file");
        Intrinsics.checkNotNullParameter((Object)$filePath, (String)"$filePath");
        MergeData mergeData = this$0.mergeProvider.loadRevisions($file);
        Intrinsics.checkNotNullExpressionValue((Object)mergeData, (String)"mergeProvider.loadRevisions(file)");
        MergeData mergeData2 = mergeData;
        String title2 = (String)this$0.tryCompute((Function0)new Function0<String>(this$0, $file){
            final /* synthetic */ MultipleFileMergeDialog this$0;
            final /* synthetic */ VirtualFile $file;
            {
                this.this$0 = $receiver;
                this.$file = $file;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return MultipleFileMergeDialog.access$getMergeDialogCustomizer$p(this.this$0).getMergeWindowTitle(this.$file);
            }
        });
        Object[] objectArray = new String[]{this$0.tryCompute((Function0)new Function0<String>(this$0, $file){
            final /* synthetic */ MultipleFileMergeDialog this$0;
            final /* synthetic */ VirtualFile $file;
            {
                this.this$0 = $receiver;
                this.$file = $file;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return MultipleFileMergeDialog.access$getMergeDialogCustomizer$p(this.this$0).getLeftPanelTitle(this.$file);
            }
        }), this$0.tryCompute((Function0)new Function0<String>(this$0, $file){
            final /* synthetic */ MultipleFileMergeDialog this$0;
            final /* synthetic */ VirtualFile $file;
            {
                this.this$0 = $receiver;
                this.$file = $file;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return MultipleFileMergeDialog.access$getMergeDialogCustomizer$p(this.this$0).getCenterPanelTitle(this.$file);
            }
        }), this$0.tryCompute((Function0)new Function0<String>(this$0, $file, mergeData2){
            final /* synthetic */ MultipleFileMergeDialog this$0;
            final /* synthetic */ VirtualFile $file;
            final /* synthetic */ MergeData $mergeData;
            {
                this.this$0 = $receiver;
                this.$file = $file;
                this.$mergeData = $mergeData;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return MultipleFileMergeDialog.access$getMergeDialogCustomizer$p(this.this$0).getRightPanelTitle(this.$file, this.$mergeData.LAST_REVISION_NUMBER);
            }
        })};
        List conflictTitles2 = CollectionsKt.listOf((Object[])objectArray);
        MergeDialogCustomizer.DiffEditorTitleCustomizerList diffEditorTitleCustomizerList = (MergeDialogCustomizer.DiffEditorTitleCustomizerList)this$0.tryCompute((Function0)new Function0<MergeDialogCustomizer.DiffEditorTitleCustomizerList>(this$0, $filePath){
            final /* synthetic */ MultipleFileMergeDialog this$0;
            final /* synthetic */ FilePath $filePath;
            {
                this.this$0 = $receiver;
                this.$filePath = $filePath;
                super(0);
            }

            @NotNull
            public final MergeDialogCustomizer.DiffEditorTitleCustomizerList invoke() {
                return MultipleFileMergeDialog.access$getMergeDialogCustomizer$p(this.this$0).getTitleCustomizerList(this.$filePath);
            }
        });
        if (diffEditorTitleCustomizerList == null) {
            diffEditorTitleCustomizerList = MergeDialogCustomizer.Companion.getDEFAULT_CUSTOMIZER_LIST();
        }
        MergeDialogCustomizer.DiffEditorTitleCustomizerList titleCustomizer2 = diffEditorTitleCustomizerList;
        return new ConflictData(mergeData2, title2, conflictTitles2, titleCustomizer2);
    }

    private static final void showMergeDialog$lambda$15(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void showMergeDialog$lambda$16(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    public static final /* synthetic */ void access$setDescriptionLabel$p(MultipleFileMergeDialog $this, JLabel jLabel) {
        $this.descriptionLabel = jLabel;
    }

    public static final /* synthetic */ void access$setAcceptYoursButton$p(MultipleFileMergeDialog $this, JButton jButton) {
        $this.acceptYoursButton = jButton;
    }

    public static final /* synthetic */ void access$acceptRevision(MultipleFileMergeDialog $this, MergeSession.Resolution resolution) {
        $this.acceptRevision(resolution);
    }

    public static final /* synthetic */ void access$setAcceptTheirsButton$p(MultipleFileMergeDialog $this, JButton jButton) {
        $this.acceptTheirsButton = jButton;
    }

    public static final /* synthetic */ void access$setMergeButton$p(MultipleFileMergeDialog $this, JButton jButton) {
        $this.mergeButton = jButton;
    }

    public static final /* synthetic */ JButton access$createJButtonForAction(MultipleFileMergeDialog $this, Action p0) {
        return $this.createJButtonForAction(p0);
    }

    public static final /* synthetic */ JButton access$getMergeButton$p(MultipleFileMergeDialog $this) {
        return $this.mergeButton;
    }

    public static final /* synthetic */ Project access$getProject$p(MultipleFileMergeDialog $this) {
        return $this.project;
    }

    public static final /* synthetic */ boolean access$getGroupByDirectory(MultipleFileMergeDialog $this) {
        return $this.getGroupByDirectory();
    }

    public static final /* synthetic */ void access$toggleGroupByDirectory(MultipleFileMergeDialog $this, boolean state) {
        $this.toggleGroupByDirectory(state);
    }

    public static final /* synthetic */ MergeSession access$getMergeSession$p(MultipleFileMergeDialog $this) {
        return $this.mergeSession;
    }

    public static final /* synthetic */ void access$checkMarkModifiedProject(MultipleFileMergeDialog $this, VirtualFile file) {
        $this.checkMarkModifiedProject(file);
    }

    public static final /* synthetic */ void access$markFilesProcessed(MultipleFileMergeDialog $this, List files2, MergeSession.Resolution resolution) {
        $this.markFilesProcessed(files2, resolution);
    }

    public static final /* synthetic */ MergeProvider access$getMergeProvider$p(MultipleFileMergeDialog $this) {
        return $this.mergeProvider;
    }

    public static final /* synthetic */ void access$markFileProcessed(MultipleFileMergeDialog $this, VirtualFile file, MergeSession.Resolution resolution) {
        $this.markFileProcessed(file, resolution);
    }

    public static final /* synthetic */ Logger access$getLOG$cp() {
        return LOG;
    }

    public static final /* synthetic */ void access$resolveFileViaContent(MultipleFileMergeDialog $this, VirtualFile file, MergeSession.Resolution resolution, MergeData data2) {
        $this.resolveFileViaContent(file, resolution, data2);
    }

    public static final /* synthetic */ MergeSession.Resolution access$getSessionResolution(MultipleFileMergeDialog $this, MergeResult result2) {
        return $this.getSessionResolution(result2);
    }

    public static final /* synthetic */ JLabel access$getDescriptionLabel$p(MultipleFileMergeDialog $this) {
        return $this.descriptionLabel;
    }

    public static final /* synthetic */ MergeDialogCustomizer access$getMergeDialogCustomizer$p(MultipleFileMergeDialog $this) {
        return $this.mergeDialogCustomizer;
    }

    static {
        Logger logger = Logger.getInstance(MultipleFileMergeDialog.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(MultipleFileMergeDialog::class.java)");
        LOG = logger;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B&\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0001\u0012\u000b\u0010\u0005\u001a\u00070\u0006\u00a2\u0006\u0002\b\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\t\u001a\u00020\nH\u0016J\u000f\u0010\u000b\u001a\t\u0018\u00010\u0006\u00a2\u0006\u0002\b\fH\u0016J\u0012\u0010\r\u001a\f0\u0006\u00a2\u0006\u0002\b\u000e\u00a2\u0006\u0002\b\fH\u0016J\u0017\u0010\u000f\u001a\t\u0018\u00010\u0003\u00a2\u0006\u0002\b\f2\u0006\u0010\u0010\u001a\u00020\u0002H\u0016R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0005\u001a\u00070\u0006\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/openapi/vcs/merge/MultipleFileMergeDialog$ColumnInfoAdapter;", "Lcom/intellij/util/ui/ColumnInfo;", "Ljavax/swing/tree/DefaultMutableTreeNode;", "", "base", "columnName", "", "Lcom/intellij/openapi/util/NlsContexts$ColumnName;", "(Lcom/intellij/util/ui/ColumnInfo;Ljava/lang/String;)V", "getAdditionalWidth", "", "getMaxStringValue", "Lorg/jetbrains/annotations/Nullable;", "getTooltipText", "Lcom/intellij/openapi/util/NlsContexts$Tooltip;", "valueOf", "node", "intellij.platform.vcs.impl"})
    @SourceDebugExtension(value={"SMAP\nMultipleFileMergeDialog.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MultipleFileMergeDialog.kt\ncom/intellij/openapi/vcs/merge/MultipleFileMergeDialog$ColumnInfoAdapter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,509:1\n1#2:510\n*E\n"})
    private static final class ColumnInfoAdapter
    extends ColumnInfo<DefaultMutableTreeNode, Object> {
        @NotNull
        private final ColumnInfo<Object, Object> base;
        @NotNull
        private final String columnName;

        public ColumnInfoAdapter(@NotNull ColumnInfo<Object, Object> base, @NotNull String columnName) {
            Intrinsics.checkNotNullParameter(base, (String)"base");
            Intrinsics.checkNotNullParameter((Object)columnName, (String)"columnName");
            super(columnName);
            this.base = base;
            this.columnName = columnName;
        }

        @Nullable
        public Object valueOf(@NotNull DefaultMutableTreeNode node) {
            Object object;
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Object object2 = node.getUserObject();
            VirtualFile virtualFile = object2 instanceof VirtualFile ? (VirtualFile)object2 : null;
            if (virtualFile != null) {
                VirtualFile it = virtualFile;
                boolean bl = false;
                object = this.base.valueOf((Object)it);
            } else {
                object = null;
            }
            return object;
        }

        @Nullable
        public String getMaxStringValue() {
            return this.base.getMaxStringValue();
        }

        public int getAdditionalWidth() {
            return this.base.getAdditionalWidth();
        }

        @NotNull
        public String getTooltipText() {
            String string2 = this.base.getTooltipText();
            if (string2 == null) {
                string2 = this.columnName;
            }
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"base.tooltipText ?: columnName");
            return string2;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/openapi/vcs/merge/MultipleFileMergeDialog$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "intellij.platform.vcs.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B9\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\r\u0010\u0004\u001a\t\u0018\u00010\u0005\u00a2\u0006\u0002\b\u0006\u0012\u0013\u0010\u0007\u001a\u000f\u0012\u000b\u0012\t\u0018\u00010\u0005\u00a2\u0006\u0002\b\t0\b\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\u0010\u0010\u0016\u001a\t\u0018\u00010\u0005\u00a2\u0006\u0002\b\u0006H\u00c6\u0003J\u0016\u0010\u0017\u001a\u000f\u0012\u000b\u0012\t\u0018\u00010\u0005\u00a2\u0006\u0002\b\t0\bH\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u000bH\u00c6\u0003JE\u0010\u0019\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000f\b\u0002\u0010\u0004\u001a\t\u0018\u00010\u0005\u00a2\u0006\u0002\b\u00062\u0015\b\u0002\u0010\u0007\u001a\u000f\u0012\u000b\u0012\t\u0018\u00010\u0005\u00a2\u0006\u0002\b\t0\b2\b\b\u0002\u0010\n\u001a\u00020\u000bH\u00c6\u0001J\u0013\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001d\u001a\u00020\u001eH\u00d6\u0001J\t\u0010\u001f\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001e\u0010\u0007\u001a\u000f\u0012\u000b\u0012\t\u0018\u00010\u0005\u00a2\u0006\u0002\b\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0018\u0010\u0004\u001a\t\u0018\u00010\u0005\u00a2\u0006\u0002\b\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006 "}, d2={"Lcom/intellij/openapi/vcs/merge/MultipleFileMergeDialog$ConflictData;", "", "mergeData", "Lcom/intellij/openapi/vcs/merge/MergeData;", "title", "", "Lcom/intellij/openapi/util/NlsContexts$DialogTitle;", "contentTitles", "", "Lcom/intellij/openapi/util/NlsContexts$Label;", "contentTitleCustomizers", "Lcom/intellij/openapi/vcs/merge/MergeDialogCustomizer$DiffEditorTitleCustomizerList;", "(Lcom/intellij/openapi/vcs/merge/MergeData;Ljava/lang/String;Ljava/util/List;Lcom/intellij/openapi/vcs/merge/MergeDialogCustomizer$DiffEditorTitleCustomizerList;)V", "getContentTitleCustomizers", "()Lcom/intellij/openapi/vcs/merge/MergeDialogCustomizer$DiffEditorTitleCustomizerList;", "getContentTitles", "()Ljava/util/List;", "getMergeData", "()Lcom/intellij/openapi/vcs/merge/MergeData;", "getTitle", "()Ljava/lang/String;", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.platform.vcs.impl"})
    private static final class ConflictData {
        @NotNull
        private final MergeData mergeData;
        @Nullable
        private final String title;
        @NotNull
        private final List<String> contentTitles;
        @NotNull
        private final MergeDialogCustomizer.DiffEditorTitleCustomizerList contentTitleCustomizers;

        public ConflictData(@NotNull MergeData mergeData, @Nullable String title2, @NotNull List<String> contentTitles, @NotNull MergeDialogCustomizer.DiffEditorTitleCustomizerList contentTitleCustomizers) {
            Intrinsics.checkNotNullParameter((Object)mergeData, (String)"mergeData");
            Intrinsics.checkNotNullParameter(contentTitles, (String)"contentTitles");
            Intrinsics.checkNotNullParameter((Object)contentTitleCustomizers, (String)"contentTitleCustomizers");
            this.mergeData = mergeData;
            this.title = title2;
            this.contentTitles = contentTitles;
            this.contentTitleCustomizers = contentTitleCustomizers;
        }

        @NotNull
        public final MergeData getMergeData() {
            return this.mergeData;
        }

        @Nullable
        public final String getTitle() {
            return this.title;
        }

        @NotNull
        public final List<String> getContentTitles() {
            return this.contentTitles;
        }

        @NotNull
        public final MergeDialogCustomizer.DiffEditorTitleCustomizerList getContentTitleCustomizers() {
            return this.contentTitleCustomizers;
        }

        @NotNull
        public final MergeData component1() {
            return this.mergeData;
        }

        @Nullable
        public final String component2() {
            return this.title;
        }

        @NotNull
        public final List<String> component3() {
            return this.contentTitles;
        }

        @NotNull
        public final MergeDialogCustomizer.DiffEditorTitleCustomizerList component4() {
            return this.contentTitleCustomizers;
        }

        @NotNull
        public final ConflictData copy(@NotNull MergeData mergeData, @Nullable String title2, @NotNull List<String> contentTitles, @NotNull MergeDialogCustomizer.DiffEditorTitleCustomizerList contentTitleCustomizers) {
            Intrinsics.checkNotNullParameter((Object)mergeData, (String)"mergeData");
            Intrinsics.checkNotNullParameter(contentTitles, (String)"contentTitles");
            Intrinsics.checkNotNullParameter((Object)contentTitleCustomizers, (String)"contentTitleCustomizers");
            return new ConflictData(mergeData, title2, contentTitles, contentTitleCustomizers);
        }

        public static /* synthetic */ ConflictData copy$default(ConflictData conflictData, MergeData mergeData, String string2, List list, MergeDialogCustomizer.DiffEditorTitleCustomizerList diffEditorTitleCustomizerList, int n, Object object) {
            if ((n & 1) != 0) {
                mergeData = conflictData.mergeData;
            }
            if ((n & 2) != 0) {
                string2 = conflictData.title;
            }
            if ((n & 4) != 0) {
                list = conflictData.contentTitles;
            }
            if ((n & 8) != 0) {
                diffEditorTitleCustomizerList = conflictData.contentTitleCustomizers;
            }
            return conflictData.copy(mergeData, string2, list, diffEditorTitleCustomizerList);
        }

        @NotNull
        public String toString() {
            return "ConflictData(mergeData=" + this.mergeData + ", title=" + this.title + ", contentTitles=" + this.contentTitles + ", contentTitleCustomizers=" + this.contentTitleCustomizers + ")";
        }

        public int hashCode() {
            int result2 = this.mergeData.hashCode();
            result2 = result2 * 31 + (this.title == null ? 0 : this.title.hashCode());
            result2 = result2 * 31 + ((Object)this.contentTitles).hashCode();
            result2 = result2 * 31 + this.contentTitleCustomizers.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ConflictData)) {
                return false;
            }
            ConflictData conflictData = (ConflictData)other;
            if (!Intrinsics.areEqual((Object)this.mergeData, (Object)conflictData.mergeData)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.title, (Object)conflictData.title)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.contentTitles, conflictData.contentTitles)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.contentTitleCustomizers, (Object)conflictData.contentTitleCustomizers);
        }
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[MergeResult.values().length];
            try {
                nArray[MergeResult.LEFT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MergeResult.RIGHT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MergeResult.RESOLVED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

