/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.actions;

import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vcs.changes.actions.RollbackDeletionAction;
import com.intellij.openapi.vcs.changes.actions.RollbackFilesAction;
import com.intellij.openapi.vcs.changes.ui.ChangesListView;
import com.intellij.openapi.vcs.changes.ui.RollbackChangesDialog;
import com.intellij.openapi.vcs.changes.ui.RollbackProgressModifier;
import com.intellij.openapi.vcs.rollback.RollbackEnvironment;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.vcs.commit.CommitMode;
import com.intellij.vcs.commit.CommitModeManager;
import com.intellij.vcsUtil.RollbackUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RollbackAction
extends DumbAwareAction {
    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            RollbackAction.$$$reportNull$$$0(0);
        }
        return actionUpdateThread;
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            RollbackAction.$$$reportNull$$$0(1);
        }
        e.getPresentation().setEnabledAndVisible(false);
        Project project2 = (Project)e.getData(CommonDataKeys.PROJECT);
        if (project2 == null || !ProjectLevelVcsManager.getInstance(project2).hasActiveVcss()) {
            return;
        }
        if (RollbackFilesAction.Manager.isPreferCheckboxesOverSelection() && CommitModeManager.getInstance(project2).getCurrentCommitMode() instanceof CommitMode.NonModalCommitMode && "ChangesViewPopup".equals(e.getPlace())) {
            return;
        }
        e.getPresentation().setVisible(true);
        e.getPresentation().setEnabled(RollbackAction.hasReversibleFiles(e));
        e.getPresentation().setText(RollbackUtil.getRollbackOperationName(project2) + "\u2026");
    }

    private static boolean hasReversibleFiles(@NotNull AnActionEvent e) {
        Project project2;
        ChangeListManager clmManager;
        if (e == null) {
            RollbackAction.$$$reportNull$$$0(2);
        }
        if (!(clmManager = ChangeListManager.getInstance(project2 = (Project)e.getRequiredData(CommonDataKeys.PROJECT))).getAllChanges().isEmpty()) {
            return true;
        }
        List missingFiles = (List)e.getData(ChangesListView.MISSING_FILES_DATA_KEY);
        if (!ContainerUtil.isEmpty((Collection)missingFiles)) {
            return true;
        }
        Set<VirtualFile> modifiedWithoutEditing = RollbackAction.getModifiedWithoutEditing(e, project2);
        return !ContainerUtil.isEmpty(modifiedWithoutEditing);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            RollbackAction.$$$reportNull$$$0(3);
        }
        if (!RollbackFilesAction.Manager.checkClmActive(e)) {
            return;
        }
        Project project2 = (Project)e.getRequiredData(CommonDataKeys.PROJECT);
        List missingFiles = (List)e.getData(ChangesListView.MISSING_FILES_DATA_KEY);
        List changes = RollbackAction.getSelectedChanges(e);
        Set<VirtualFile> modifiedWithoutEditing = RollbackAction.getModifiedWithoutEditing(e, project2);
        if (modifiedWithoutEditing != null) {
            changes = ContainerUtil.filter(changes, change -> !modifiedWithoutEditing.contains(change.getVirtualFile()));
        }
        FileDocumentManager.getInstance().saveAllDocuments();
        boolean hasChanges = false;
        if (!ContainerUtil.isEmpty((Collection)missingFiles)) {
            hasChanges = true;
            new RollbackDeletionAction().actionPerformed(e);
        }
        if (!ContainerUtil.isEmpty(modifiedWithoutEditing)) {
            hasChanges = true;
            RollbackAction.rollbackModifiedWithoutEditing(project2, modifiedWithoutEditing);
        }
        if (!changes.isEmpty()) {
            RollbackChangesDialog.rollbackChanges(project2, changes);
        } else if (!hasChanges) {
            RollbackChangesDialog.rollbackChanges(project2);
        }
    }

    @NotNull
    private static Collection<Change> getSelectedChanges(@NotNull AnActionEvent e) {
        if (e == null) {
            RollbackAction.$$$reportNull$$$0(4);
        }
        Project project2 = (Project)e.getRequiredData(CommonDataKeys.PROJECT);
        ChangesListView changesView = (ChangesListView)((Object)e.getData(ChangesListView.DATA_KEY));
        if (RollbackFilesAction.Manager.isPreferCheckboxesOverSelection() && changesView != null) {
            List list = ContainerUtil.filterIsInstance(changesView.getInclusionModel().getInclusion(), Change.class);
            if (list == null) {
                RollbackAction.$$$reportNull$$$0(5);
            }
            return list;
        }
        Change[] changes = (Change[])e.getData(VcsDataKeys.CHANGES);
        if (changes != null) {
            List<Change> list = Arrays.asList(changes);
            if (list == null) {
                RollbackAction.$$$reportNull$$$0(6);
            }
            return list;
        }
        Object[] files2 = (VirtualFile[])e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY);
        if (!ArrayUtil.isEmpty((Object[])files2)) {
            ChangeListManager clmManager = ChangeListManager.getInstance(project2);
            ArrayList<Change> result2 = new ArrayList<Change>();
            for (Object vf : files2) {
                result2.addAll(clmManager.getChangesIn((VirtualFile)vf));
            }
            ArrayList<Change> arrayList = result2;
            if (arrayList == null) {
                RollbackAction.$$$reportNull$$$0(7);
            }
            return arrayList;
        }
        List<Change> list = Collections.emptyList();
        if (list == null) {
            RollbackAction.$$$reportNull$$$0(8);
        }
        return list;
    }

    @Nullable
    private static Set<VirtualFile> getModifiedWithoutEditing(AnActionEvent e, Project project2) {
        List selectedModifiedWithoutEditing = (List)e.getData(VcsDataKeys.MODIFIED_WITHOUT_EDITING_DATA_KEY);
        if (!ContainerUtil.isEmpty((Collection)selectedModifiedWithoutEditing)) {
            return new HashSet<VirtualFile>(selectedModifiedWithoutEditing);
        }
        Object[] virtualFiles2 = (VirtualFile[])e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY);
        if (!ArrayUtil.isEmpty((Object[])virtualFiles2)) {
            HashSet<VirtualFile> modifiedWithoutEditing = new HashSet<VirtualFile>(ChangeListManager.getInstance(project2).getModifiedWithoutEditing());
            HashSet files2 = ContainerUtil.newHashSet((Object[])virtualFiles2);
            modifiedWithoutEditing.retainAll(files2);
            return modifiedWithoutEditing;
        }
        return null;
    }

    private static void rollbackModifiedWithoutEditing(Project project2, Set<? extends VirtualFile> modifiedWithoutEditing) {
        String operationName = StringUtil.decapitalize((String)UIUtil.removeMnemonic((String)RollbackUtil.getRollbackOperationName(project2)));
        String message2 = modifiedWithoutEditing.size() == 1 ? VcsBundle.message("rollback.modified.without.editing.confirm.single", operationName, modifiedWithoutEditing.iterator().next().getPresentableUrl()) : VcsBundle.message("rollback.modified.without.editing.confirm.multiple", operationName, modifiedWithoutEditing.size());
        int rc = Messages.showYesNoDialog((Project)project2, (String)message2, (String)VcsBundle.message("changes.action.rollback.title", operationName), (Icon)Messages.getQuestionIcon());
        if (rc != 0) {
            return;
        }
        ArrayList exceptions2 = new ArrayList();
        ProgressManager progressManager = ProgressManager.getInstance();
        Runnable action2 = () -> {
            ProgressIndicator indicator = progressManager.getProgressIndicator();
            try {
                ChangesUtil.processVirtualFilesByVcs(project2, modifiedWithoutEditing, (vcs, items2) -> {
                    RollbackEnvironment rollbackEnvironment = vcs.getRollbackEnvironment();
                    if (rollbackEnvironment != null) {
                        if (indicator != null) {
                            indicator.setText(VcsBundle.message("progress.text.performing", vcs.getDisplayName(), StringUtil.toLowerCase((String)UIUtil.removeMnemonic((String)rollbackEnvironment.getRollbackOperationName()))));
                            indicator.setIndeterminate(false);
                        }
                        rollbackEnvironment.rollbackModifiedWithoutCheckout(items2, exceptions2, new RollbackProgressModifier(items2.size(), indicator));
                        if (indicator != null) {
                            indicator.setText2("");
                        }
                    }
                });
            }
            catch (ProcessCanceledException processCanceledException) {
                // empty catch block
            }
            if (!exceptions2.isEmpty()) {
                AbstractVcsHelper.getInstance(project2).showErrors(exceptions2, VcsBundle.message("rollback.modified.without.checkout.error.tab", operationName));
            }
            VfsUtil.markDirty((boolean)true, (boolean)false, (VirtualFile[])VfsUtilCore.toVirtualFileArray((Collection)modifiedWithoutEditing));
            VirtualFileManager.getInstance().asyncRefresh(() -> {
                for (VirtualFile virtualFile : modifiedWithoutEditing) {
                    VcsDirtyScopeManager.getInstance(project2).fileDirty(virtualFile);
                }
            });
        };
        progressManager.runProcessWithProgressSynchronously(action2, operationName, true, project2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/changes/actions/RollbackAction";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/changes/actions/RollbackAction";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedChanges";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "hasReversibleFiles";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getSelectedChanges";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string2);
            case 1, 2, 3, 4 -> new IllegalArgumentException(string2);
        };
    }
}

