/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.markdown.utils;

import com.intellij.markdown.utils.lang.HtmlSyntaxHighlighter;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.intellij.markdown.IElementType;
import org.intellij.markdown.MarkdownTokenTypes;
import org.intellij.markdown.ast.ASTNode;
import org.intellij.markdown.ast.ASTUtilKt;
import org.intellij.markdown.html.GeneratingProvider;
import org.intellij.markdown.html.HtmlGenerator;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J$\u0010\u0005\u001a\u00020\u00062\n\u0010\u0007\u001a\u00060\bR\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/intellij/markdown/utils/CodeFenceSyntaxHighlighterGeneratingProvider;", "Lorg/intellij/markdown/html/GeneratingProvider;", "htmlSyntaxHighlighter", "Lcom/intellij/markdown/utils/lang/HtmlSyntaxHighlighter;", "(Lcom/intellij/markdown/utils/lang/HtmlSyntaxHighlighter;)V", "processNode", "", "visitor", "Lorg/intellij/markdown/html/HtmlGenerator$HtmlGeneratingVisitor;", "Lorg/intellij/markdown/html/HtmlGenerator;", "text", "", "node", "Lorg/intellij/markdown/ast/ASTNode;", "intellij.platform.markdown.utils"})
@ApiStatus.Internal
public final class CodeFenceSyntaxHighlighterGeneratingProvider
implements GeneratingProvider {
    @NotNull
    private final HtmlSyntaxHighlighter htmlSyntaxHighlighter;

    public CodeFenceSyntaxHighlighterGeneratingProvider(@NotNull HtmlSyntaxHighlighter htmlSyntaxHighlighter) {
        Intrinsics.checkNotNullParameter((Object)htmlSyntaxHighlighter, (String)"htmlSyntaxHighlighter");
        this.htmlSyntaxHighlighter = htmlSyntaxHighlighter;
    }

    public void processNode(@NotNull HtmlGenerator.HtmlGeneratingVisitor visitor, @NotNull String text2, @NotNull ASTNode node) {
        HtmlChunk.Element element;
        Intrinsics.checkNotNullParameter((Object)visitor, (String)"visitor");
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        String languageCodeBlock = null;
        StringBuilder codeFenceRawContent = new StringBuilder();
        Iterator iterator = node.getChildren().iterator();
        while (iterator.hasNext()) {
            ASTNode child = (ASTNode)iterator.next();
            IElementType iElementType = child.getType();
            if (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownTokenTypes.FENCE_LANG)) {
                languageCodeBlock = ((Object)StringsKt.trim((CharSequence)((Object)HtmlGenerator.Companion.leafText$default((HtmlGenerator.Companion)HtmlGenerator.Companion, (String)text2, (ASTNode)child, (boolean)false, (int)4, null)).toString())).toString();
                iterator.next();
                continue;
            }
            if (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownTokenTypes.CODE_FENCE_CONTENT) ? true : Intrinsics.areEqual((Object)iElementType, (Object)MarkdownTokenTypes.EOL)) {
                CharSequence textInNode = ASTUtilKt.getTextInNode((ASTNode)child, (CharSequence)text2);
                codeFenceRawContent.append(HtmlGenerator.Companion.trimIndents(textInNode, 0));
                continue;
            }
            if (!Intrinsics.areEqual((Object)iElementType, (Object)MarkdownTokenTypes.CODE_FENCE_END)) continue;
        }
        String string2 = codeFenceRawContent.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"codeFenceRawContent.toString()");
        HtmlChunk coloredContent = this.htmlSyntaxHighlighter.color(languageCodeBlock, string2);
        HtmlChunk.Element it = HtmlChunk.tag((String)"code");
        boolean bl = false;
        if (languageCodeBlock == null) {
            element = it;
        } else {
            String[] stringArray = new String[]{" "};
            element = it.setClass("language-" + CollectionsKt.joinToString$default((Iterable)StringsKt.split$default((CharSequence)languageCodeBlock, (String[])stringArray, (boolean)false, (int)0, (int)6, null), (CharSequence)"-", null, null, (int)0, null, null, (int)62, null));
        }
        Intrinsics.checkNotNullExpressionValue((Object)element, (String)"tag(\"code\").let {\n      \u2026separator = \"-\")}\")\n    }");
        HtmlChunk.Element codeHtmlChunk = element;
        HtmlChunk.Element element2 = new HtmlBuilder().append(coloredContent).wrapWith(codeHtmlChunk);
        Intrinsics.checkNotNullExpressionValue((Object)element2, (String)"HtmlBuilder().append(col\u2026).wrapWith(codeHtmlChunk)");
        HtmlChunk.Element html = element2;
        String string3 = html.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"html.toString()");
        visitor.consumeHtml((CharSequence)string3);
    }
}

