/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.highlighter;

import com.intellij.ide.highlighter.XmlFileHighlighter;
import com.intellij.lexer.HtmlHighlightingLexer;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.editor.HighlighterColors;
import com.intellij.openapi.editor.XmlHighlighterColors;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.fileTypes.SyntaxHighlighterBase;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

public class HtmlFileHighlighter
extends SyntaxHighlighterBase {
    private static final MultiMap<IElementType, TextAttributesKey> ourMap = MultiMap.create();

    @NotNull
    public Lexer getHighlightingLexer() {
        return new HtmlHighlightingLexer(FileTypeRegistry.getInstance().findFileTypeByName("CSS"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public TextAttributesKey @NotNull [] getTokenHighlights(IElementType tokenType) {
        Class<?> clazz = ((Object)((Object)this)).getClass();
        // MONITORENTER : clazz
        TextAttributesKey[] textAttributesKeyArray = SyntaxHighlighterBase.pack((TextAttributesKey)XmlHighlighterColors.HTML_CODE, (TextAttributesKey[])ourMap.get((Object)tokenType).toArray(TextAttributesKey.EMPTY_ARRAY));
        // MONITOREXIT : clazz
        if (textAttributesKeyArray != null) return textAttributesKeyArray;
        HtmlFileHighlighter.$$$reportNull$$$0(0);
        return textAttributesKeyArray;
    }

    static {
        ourMap.putValue((Object)XmlTokenType.XML_TAG_CHARACTERS, (Object)XmlHighlighterColors.HTML_TAG);
        for (IElementType type2 : (IElementType[])ContainerUtil.ar((Object[])new IElementType[]{XmlTokenType.XML_COMMENT_START, XmlTokenType.XML_COMMENT_END, XmlTokenType.XML_COMMENT_CHARACTERS, XmlTokenType.XML_CONDITIONAL_COMMENT_END, XmlTokenType.XML_CONDITIONAL_COMMENT_END_START, XmlTokenType.XML_CONDITIONAL_COMMENT_START, XmlTokenType.XML_CONDITIONAL_COMMENT_START_END})) {
            ourMap.putValue((Object)type2, (Object)XmlHighlighterColors.HTML_COMMENT);
        }
        for (IElementType type2 : (IElementType[])ContainerUtil.ar((Object[])new IElementType[]{XmlTokenType.XML_START_TAG_START, XmlTokenType.XML_END_TAG_START, XmlTokenType.XML_TAG_END, XmlTokenType.XML_EMPTY_ELEMENT_END, XmlTokenType.TAG_WHITE_SPACE})) {
            ourMap.putValue((Object)type2, (Object)XmlHighlighterColors.HTML_TAG);
        }
        ourMap.putValues((Object)XmlTokenType.XML_TAG_NAME, Arrays.asList(XmlHighlighterColors.HTML_TAG, XmlHighlighterColors.HTML_TAG_NAME));
        ourMap.putValues((Object)XmlTokenType.XML_NAME, Arrays.asList(XmlHighlighterColors.HTML_TAG, XmlHighlighterColors.HTML_ATTRIBUTE_NAME));
        for (IElementType type2 : (IElementType[])ContainerUtil.ar((Object[])new IElementType[]{XmlTokenType.XML_EQ, XmlTokenType.XML_ATTRIBUTE_VALUE_TOKEN, XmlTokenType.XML_ATTRIBUTE_VALUE_START_DELIMITER, XmlTokenType.XML_ATTRIBUTE_VALUE_END_DELIMITER})) {
            ourMap.putValues((Object)type2, Arrays.asList(XmlHighlighterColors.HTML_TAG, XmlHighlighterColors.HTML_ATTRIBUTE_VALUE));
        }
        for (IElementType type2 : (IElementType[])ContainerUtil.ar((Object[])new IElementType[]{XmlTokenType.XML_PI_START, XmlTokenType.XML_PI_END, XmlTokenType.XML_DOCTYPE_START, XmlTokenType.XML_DOCTYPE_END, XmlTokenType.XML_DOCTYPE_PUBLIC})) {
            ourMap.putValue((Object)type2, (Object)XmlHighlighterColors.HTML_TAG);
        }
        ourMap.putValues((Object)XmlTokenType.XML_PI_TARGET, Arrays.asList(XmlHighlighterColors.HTML_TAG, XmlHighlighterColors.HTML_TAG_NAME));
        ourMap.putValue((Object)XmlTokenType.XML_CHAR_ENTITY_REF, (Object)XmlHighlighterColors.HTML_ENTITY_REFERENCE);
        ourMap.putValue((Object)XmlTokenType.XML_ENTITY_REF_TOKEN, (Object)XmlHighlighterColors.HTML_ENTITY_REFERENCE);
        ourMap.putValue((Object)XmlTokenType.XML_BAD_CHARACTER, (Object)HighlighterColors.BAD_CHARACTER);
        XmlFileHighlighter.registerAdditionalHighlighters(ourMap);
        XmlFileHighlighter.EMBEDDED_HIGHLIGHTERS.addExtensionPointListener((ExtensionPointListener)new XmlFileHighlighter.EmbeddedTokenHighlighterExtensionPointListener(ourMap), null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/highlighter/HtmlFileHighlighter", "getTokenHighlights"));
    }
}

