/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.analysis;

import com.intellij.codeInsight.editorActions.XmlEditUtil;
import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInsight.template.impl.ConstantNode;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.html.HtmlTag;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.xml.XmlChildRole;
import com.intellij.psi.xml.XmlTag;
import com.intellij.xml.XmlAttributeDescriptor;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.XmlExtension;
import com.intellij.xml.psi.XmlPsiBundle;
import com.intellij.xml.util.HtmlUtil;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InsertRequiredAttributeFix
extends LocalQuickFixAndIntentionActionOnPsiElement
implements HighPriorityAction {
    private final String myAttrName;
    private final String[] myValues;
    @NonNls
    private static final String NAME_TEMPLATE_VARIABLE = "name";

    public InsertRequiredAttributeFix(@NotNull XmlTag tag, @NotNull String attrName, String ... values2) {
        if (tag == null) {
            InsertRequiredAttributeFix.$$$reportNull$$$0(0);
        }
        if (attrName == null) {
            InsertRequiredAttributeFix.$$$reportNull$$$0(1);
        }
        if (values2 == null) {
            InsertRequiredAttributeFix.$$$reportNull$$$0(2);
        }
        super((PsiElement)tag);
        this.myAttrName = attrName;
        this.myValues = values2;
    }

    @NotNull
    public String getText() {
        String string2 = XmlPsiBundle.message("xml.quickfix.insert.required.attribute.text", this.myAttrName);
        if (string2 == null) {
            InsertRequiredAttributeFix.$$$reportNull$$$0(3);
        }
        return string2;
    }

    @NotNull
    public String getFamilyName() {
        String string2 = XmlPsiBundle.message("xml.quickfix.insert.required.attribute.family", new Object[0]);
        if (string2 == null) {
            InsertRequiredAttributeFix.$$$reportNull$$$0(4);
        }
        return string2;
    }

    public void invoke(@NotNull Project project2, @NotNull PsiFile file, @Nullable Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        boolean anchorIsEmptyTag;
        if (project2 == null) {
            InsertRequiredAttributeFix.$$$reportNull$$$0(5);
        }
        if (file == null) {
            InsertRequiredAttributeFix.$$$reportNull$$$0(6);
        }
        if (startElement == null) {
            InsertRequiredAttributeFix.$$$reportNull$$$0(7);
        }
        if (endElement == null) {
            InsertRequiredAttributeFix.$$$reportNull$$$0(8);
        }
        XmlTag myTag = (XmlTag)startElement;
        ASTNode treeElement = SourceTreeToPsiMap.psiElementToTree((PsiElement)myTag);
        XmlElementDescriptor descriptor = myTag.getDescriptor();
        if (descriptor == null) {
            return;
        }
        XmlAttributeDescriptor attrDescriptor = descriptor.getAttributeDescriptor(this.myAttrName, myTag);
        boolean indirectSyntax = XmlExtension.getExtension(myTag.getContainingFile()).isIndirectSyntax(attrDescriptor);
        boolean insertShorthand = myTag instanceof HtmlTag && attrDescriptor != null && HtmlUtil.isBooleanAttribute(attrDescriptor, myTag);
        PsiElement anchor = SourceTreeToPsiMap.treeElementToPsi((ASTNode)XmlChildRole.EMPTY_TAG_END_FINDER.findChild(treeElement));
        boolean bl = anchorIsEmptyTag = anchor != null;
        if (anchor == null) {
            anchor = SourceTreeToPsiMap.treeElementToPsi((ASTNode)XmlChildRole.START_TAG_END_FINDER.findChild(treeElement));
        }
        if (anchor == null) {
            return;
        }
        Template template = TemplateManager.getInstance((Project)project2).createTemplate("", "");
        String valuePostfix = "\"";
        if (indirectSyntax) {
            if (anchorIsEmptyTag) {
                template.addTextSegment(">");
            }
            template.addTextSegment("<jsp:attribute name=\"" + this.myAttrName + "\">");
        } else {
            template.addTextSegment(" " + this.myAttrName);
            if (!insertShorthand) {
                String quote = XmlEditUtil.getAttributeQuote(file);
                XmlExtension.AttributeValuePresentation presentation2 = XmlExtension.getExtension(file).getAttributeValuePresentation(myTag, this.myAttrName, quote);
                valuePostfix = presentation2.getPostfix();
                template.addTextSegment("=" + presentation2.getPrefix());
            }
        }
        ConstantNode expression = new ConstantNode("").withLookupStrings(this.myValues);
        if (!insertShorthand) {
            template.addVariable(NAME_TEMPLATE_VARIABLE, (Expression)expression, (Expression)expression, true);
        }
        if (indirectSyntax) {
            template.addTextSegment("</jsp:attribute>");
            template.addEndVariable();
            if (anchorIsEmptyTag) {
                template.addTextSegment("</" + myTag.getName() + ">");
            }
        } else if (!insertShorthand) {
            template.addTextSegment(valuePostfix);
        }
        int textOffset = anchor.getTextOffset();
        if (!anchorIsEmptyTag && indirectSyntax) {
            ++textOffset;
        }
        editor.getCaretModel().moveToOffset(textOffset);
        if (anchorIsEmptyTag && indirectSyntax) {
            editor.getDocument().deleteString(textOffset, textOffset + 2);
        }
        TemplateManager.getInstance((Project)project2).startTemplate(editor, template);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attrName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "values";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/analysis/InsertRequiredAttributeFix";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startElement";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "endElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/analysis/InsertRequiredAttributeFix";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 3, 4 -> new IllegalStateException(string2);
        };
    }
}

