/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.nlp.patterns;

import ai.grazie.nlp.patterns.MatchPattern;
import ai.grazie.nlp.patterns.Pattern;
import ai.grazie.nlp.utils.RangesKt;
import ai.grazie.text.ExtensionsKt;
import ai.grazie.text.TextRange;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\r\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\bf\u0018\u0000 \u00152\u00020\u0001:\u0004\u0013\u0014\u0015\u0016J\u0010\u0010\u0002\u001a\u00020\u00002\u0006\u0010\u0003\u001a\u00020\u0004H\u0016J\b\u0010\u0005\u001a\u00020\u0000H\u0016J\u0010\u0010\u0006\u001a\u00020\u00002\u0006\u0010\u0003\u001a\u00020\u0004H\u0016J\b\u0010\u0007\u001a\u00020\u0000H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\u0000H\u0016J\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\n\u001a\u00020\u000bH&J\u0010\u0010\u0011\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\u0012\u001a\u00020\u0000H\u0016\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0017\u00c0\u0006\u0001"}, d2={"Lai/grazie/nlp/patterns/Pattern;", "Lai/grazie/nlp/patterns/MatchPattern;", "after", "pattern", "Lkotlin/text/Regex;", "afterWordBoundary", "before", "beforeWordBoundary", "contains", "", "text", "", "exclude", "other", "find", "", "Lai/grazie/text/TextRange;", "matches", "withWordBoundariesAround", "After", "Before", "Companion", "Exclusion", "nlp-patterns"})
@SourceDebugExtension(value={"SMAP\nPattern.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Pattern.kt\nai/grazie/nlp/patterns/Pattern\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,92:1\n1747#2,3:93\n*S KotlinDebug\n*F\n+ 1 Pattern.kt\nai/grazie/nlp/patterns/Pattern\n*L\n14#1:93,3\n*E\n"})
public interface Pattern
extends MatchPattern {
    public static final /* synthetic */ Companion Companion;

    @NotNull
    public List<TextRange> find(@NotNull CharSequence var1);

    default public boolean contains(@NotNull CharSequence text2) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        return !((Collection)this.find(text2)).isEmpty();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    default public boolean matches(@NotNull CharSequence text2) {
        TextRange it;
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        List<TextRange> ranges = this.find(text2);
        if (((Collection)ranges).isEmpty()) return false;
        boolean bl = true;
        if (!bl) return false;
        Iterable $this$any$iv = ranges;
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator = $this$any$iv.iterator();
        do {
            if (!iterator.hasNext()) return false;
            Object element$iv = iterator.next();
            it = (TextRange)element$iv;
            boolean bl2 = false;
        } while (!it.covers(ExtensionsKt.getRange(text2)));
        return true;
    }

    @NotNull
    default public Pattern exclude(@NotNull Pattern other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return new Exclusion(this, other);
    }

    @NotNull
    default public Pattern before(@NotNull Regex pattern2) {
        Intrinsics.checkNotNullParameter((Object)pattern2, (String)"pattern");
        return new Before(this, pattern2);
    }

    @NotNull
    default public Pattern beforeWordBoundary() {
        return new Before(this, ai.grazie.nlp.patterns.Pattern$Companion.trailingWordBoundary);
    }

    @NotNull
    default public Pattern after(@NotNull Regex pattern2) {
        Intrinsics.checkNotNullParameter((Object)pattern2, (String)"pattern");
        return new After(this, pattern2);
    }

    @NotNull
    default public Pattern afterWordBoundary() {
        return new After(this, ai.grazie.nlp.patterns.Pattern$Companion.leadingWordBoundary);
    }

    @NotNull
    default public Pattern withWordBoundariesAround() {
        return this.beforeWordBoundary().afterWordBoundary();
    }

    static {
        Companion = ai.grazie.nlp.patterns.Pattern$Companion.$$INSTANCE;
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u0011\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0011"}, d2={"Lai/grazie/nlp/patterns/Pattern$After;", "Lai/grazie/nlp/patterns/Pattern;", "pattern", "prev", "Lkotlin/text/Regex;", "(Lai/grazie/nlp/patterns/Pattern;Lkotlin/text/Regex;)V", "getPattern", "()Lai/grazie/nlp/patterns/Pattern;", "getPrev", "()Lkotlin/text/Regex;", "find", "", "Lai/grazie/text/TextRange;", "text", "", "matches", "", "nlp-patterns"})
    @SourceDebugExtension(value={"SMAP\nPattern.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Pattern.kt\nai/grazie/nlp/patterns/Pattern$After\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,92:1\n766#2:93\n857#2,2:94\n*S KotlinDebug\n*F\n+ 1 Pattern.kt\nai/grazie/nlp/patterns/Pattern$After\n*L\n83#1:93\n83#1:94,2\n*E\n"})
    private static final class After
    implements Pattern {
        @NotNull
        private final Pattern pattern;
        @NotNull
        private final Regex prev;

        public After(@NotNull Pattern pattern2, @NotNull Regex prev) {
            Intrinsics.checkNotNullParameter((Object)pattern2, (String)"pattern");
            Intrinsics.checkNotNullParameter((Object)prev, (String)"prev");
            this.pattern = pattern2;
            this.prev = prev;
        }

        @NotNull
        public final Pattern getPattern() {
            return this.pattern;
        }

        @NotNull
        public final Regex getPrev() {
            return this.prev;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public List<TextRange> find(@NotNull CharSequence text2) {
            void $this$filterTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
            List<TextRange> ranges = this.pattern.find(text2);
            if (ranges.isEmpty()) {
                return CollectionsKt.emptyList();
            }
            Set prefixMatchEnds2 = SequencesKt.toSet((Sequence)SequencesKt.map((Sequence)Regex.findAll$default((Regex)this.prev, (CharSequence)text2, (int)0, (int)2, null), (Function1)find.prefixMatchEnds.1.INSTANCE));
            Iterable $this$filter$iv = ranges;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                TextRange range = (TextRange)element$iv$iv;
                boolean bl = false;
                if (!prefixMatchEnds2.contains(range.getStart())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            return (List)destination$iv$iv;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean matches(@NotNull CharSequence text2) {
            Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
            if (!this.pattern.matches(text2)) return false;
            MatchResult matchResult = this.prev.matchAt(text2, 0);
            MatchResult matchResult2 = matchResult;
            if (matchResult == null) return false;
            IntRange intRange = matchResult2.getRange();
            matchResult2 = intRange;
            if (intRange == null) return false;
            if (RangesKt.getLength((IntRange)matchResult2) != 0) return false;
            return true;
        }
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0011"}, d2={"Lai/grazie/nlp/patterns/Pattern$Before;", "Lai/grazie/nlp/patterns/Pattern;", "pattern", "next", "Lkotlin/text/Regex;", "(Lai/grazie/nlp/patterns/Pattern;Lkotlin/text/Regex;)V", "getNext", "()Lkotlin/text/Regex;", "getPattern", "()Lai/grazie/nlp/patterns/Pattern;", "find", "", "Lai/grazie/text/TextRange;", "text", "", "matches", "", "nlp-patterns"})
    @SourceDebugExtension(value={"SMAP\nPattern.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Pattern.kt\nai/grazie/nlp/patterns/Pattern$Before\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,92:1\n766#2:93\n857#2,2:94\n*S KotlinDebug\n*F\n+ 1 Pattern.kt\nai/grazie/nlp/patterns/Pattern$Before\n*L\n69#1:93\n69#1:94,2\n*E\n"})
    private static final class Before
    implements Pattern {
        @NotNull
        private final Pattern pattern;
        @NotNull
        private final Regex next;

        public Before(@NotNull Pattern pattern2, @NotNull Regex next) {
            Intrinsics.checkNotNullParameter((Object)pattern2, (String)"pattern");
            Intrinsics.checkNotNullParameter((Object)next, (String)"next");
            this.pattern = pattern2;
            this.next = next;
        }

        @NotNull
        public final Pattern getPattern() {
            return this.pattern;
        }

        @NotNull
        public final Regex getNext() {
            return this.next;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public List<TextRange> find(@NotNull CharSequence text2) {
            void $this$filterTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
            List<TextRange> ranges = this.pattern.find(text2);
            if (ranges.isEmpty()) {
                return CollectionsKt.emptyList();
            }
            Iterable $this$filter$iv = ranges;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                TextRange range = (TextRange)element$iv$iv;
                boolean bl = false;
                if (!this.next.matchesAt(text2, range.getEndExclusive())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            return (List)destination$iv$iv;
        }

        @Override
        public boolean matches(@NotNull CharSequence text2) {
            Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
            return this.pattern.matches(text2) && this.next.matchesAt(text2, text2.length());
        }
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lai/grazie/nlp/patterns/Pattern$Companion;", "", "()V", "boundaryCommonChars", "", "leadingWordBoundary", "Lkotlin/text/Regex;", "nonMiddleApostrophe", "trailingWordBoundary", "nlp-patterns"})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;
        @NotNull
        private static final String boundaryCommonChars = "\"\\s\\u00A0\\.\u201c\u201d\u00ab\u00bb`\u2018\u2019/:=\u2013\u2014\u2015-";
        @NotNull
        private static final String nonMiddleApostrophe = "(^|[^\\p{L}])'";
        @NotNull
        private static final Regex leadingWordBoundary;
        @NotNull
        private static final Regex trailingWordBoundary;

        private Companion() {
        }

        static {
            $$INSTANCE = new Companion();
            leadingWordBoundary = new Regex("^|[({\\[\"\\s\\u00A0\\.\u201c\u201d\u00ab\u00bb`\u2018\u2019/:=\u2013\u2014\u2015-]|((^|[^\\p{L}])')");
            trailingWordBoundary = new Regex("$|[)}\\],:;!?'\"\\s\\u00A0\\.\u201c\u201d\u00ab\u00bb`\u2018\u2019/:=\u2013\u2014\u2015-]");
        }
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tH\u0016R\u000e\u0010\u0003\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lai/grazie/nlp/patterns/Pattern$Exclusion;", "Lai/grazie/nlp/patterns/Pattern;", "main", "exclude", "(Lai/grazie/nlp/patterns/Pattern;Lai/grazie/nlp/patterns/Pattern;)V", "find", "", "Lai/grazie/text/TextRange;", "text", "", "matches", "", "nlp-patterns"})
    public static final class Exclusion
    implements Pattern {
        @NotNull
        private final Pattern main;
        @NotNull
        private final Pattern exclude;

        public Exclusion(@NotNull Pattern main2, @NotNull Pattern exclude2) {
            Intrinsics.checkNotNullParameter((Object)main2, (String)"main");
            Intrinsics.checkNotNullParameter((Object)exclude2, (String)"exclude");
            this.main = main2;
            this.exclude = exclude2;
        }

        @Override
        @NotNull
        public List<TextRange> find(@NotNull CharSequence text2) {
            Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
            List<TextRange> matches = this.main.find(text2);
            Set exclusion = CollectionsKt.toSet((Iterable)this.exclude.find(text2));
            return CollectionsKt.minus((Iterable)matches, (Iterable)exclusion);
        }

        @Override
        public boolean matches(@NotNull CharSequence text2) {
            Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
            return this.main.matches(text2) && !this.exclude.matches(text2);
        }
    }
}

