/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.notebooks.ui.visualization;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorFontType;
import com.intellij.openapi.editor.impl.view.FontLayoutService;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.notebooks.ui.visualization.NotebookEditorAppearance;
import org.jetbrains.plugins.notebooks.ui.visualization.NotebookLineMarkerRenderer;
import org.jetbrains.plugins.notebooks.ui.visualization.NotebookUtilKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/jetbrains/plugins/notebooks/ui/visualization/NotebookCellLineNumbersLineMarkerRenderer;", "Lorg/jetbrains/plugins/notebooks/ui/visualization/NotebookLineMarkerRenderer;", "highlighter", "Lcom/intellij/openapi/editor/markup/RangeHighlighter;", "(Lcom/intellij/openapi/editor/markup/RangeHighlighter;)V", "paint", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "g", "Ljava/awt/Graphics;", "r", "Ljava/awt/Rectangle;", "intellij.notebooks.ui"})
@SourceDebugExtension(value={"SMAP\nNotebookLineMarkerRenderer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NotebookLineMarkerRenderer.kt\norg/jetbrains/plugins/notebooks/ui/visualization/NotebookCellLineNumbersLineMarkerRenderer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,145:1\n1#2:146\n*E\n"})
public final class NotebookCellLineNumbersLineMarkerRenderer
extends NotebookLineMarkerRenderer {
    @NotNull
    private final RangeHighlighter highlighter;

    public NotebookCellLineNumbersLineMarkerRenderer(@NotNull RangeHighlighter highlighter) {
        Intrinsics.checkNotNullParameter((Object)highlighter, (String)"highlighter");
        super(null, 1, null);
        this.highlighter = highlighter;
    }

    /*
     * WARNING - void declaration
     */
    public void paint(@NotNull Editor editor, @NotNull Graphics g, @NotNull Rectangle r) {
        void it;
        void $this$paint_u24lambda_u240;
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Intrinsics.checkNotNullParameter((Object)r, (String)"r");
        if (!editor.getSettings().isLineNumbersShown()) {
            return;
        }
        IntRange lines = new IntRange(editor.getDocument().getLineNumber(this.highlighter.getStartOffset()), editor.getDocument().getLineNumber(this.highlighter.getEndOffset()));
        int visualLineStart = editor.xyToVisualPosition((Point)new Point((int)0, (int)g.getClip().getBounds().y)).line;
        Rectangle rectangle = g.getClip().getBounds();
        int n = 0;
        Object object = editor;
        boolean bl = false;
        int n2 = $this$paint_u24lambda_u240.y + $this$paint_u24lambda_u240.height;
        int n3 = n2;
        int n4 = n;
        int visualLineEnd = object.xyToVisualPosition((Point)new Point((int)n4, (int)n3)).line;
        int logicalLineStart = editor.visualToLogicalPosition((VisualPosition)new VisualPosition((int)visualLineStart, (int)0)).line;
        int logicalLineEnd = editor.visualToLogicalPosition((VisualPosition)new VisualPosition((int)visualLineEnd, (int)0)).line;
        Font font = editor.getColorsScheme().getFont(EditorFontType.PLAIN);
        object = g;
        boolean bl2 = false;
        ((Graphics)object).setFont(it.deriveFont(Math.max(1.0f, it.getSize2D() - 1.0f)));
        g.setColor(editor.getColorsScheme().getColor(EditorColors.LINE_NUMBERS_COLOR));
        NotebookEditorAppearance notebookAppearance = NotebookUtilKt.getNotebookAppearance(editor);
        int previousVisualLine = -1;
        int logicalLine = Math.max(logicalLineStart, lines.getFirst() + 1);
        int n5 = Math.min(logicalLineEnd, lines.getLast());
        if (logicalLine <= n5) {
            while (true) {
                int visualLine;
                if (previousVisualLine != (visualLine = editor.logicalToVisualPosition((LogicalPosition)new LogicalPosition((int)logicalLine, (int)0)).line)) {
                    previousVisualLine = visualLine;
                    if (visualLine >= visualLineStart) {
                        if (visualLine > visualLineEnd) break;
                        int yTop = editor.visualLineToY(visualLine);
                        int lineNumber = logicalLine - lines.getFirst();
                        String text = String.valueOf(lineNumber);
                        int n6 = r.width;
                        FontLayoutService fontLayoutService = FontLayoutService.Companion.getInstance();
                        FontMetrics fontMetrics = g.getFontMetrics();
                        Intrinsics.checkNotNullExpressionValue((Object)fontMetrics, (String)"g.fontMetrics");
                        int left = n6 - fontLayoutService.stringWidth(fontMetrics, text) - notebookAppearance.getLINE_NUMBERS_MARGIN() - notebookAppearance.getLeftBorderWidth();
                        g.drawString(text, left, yTop + editor.getAscent());
                    }
                }
                if (logicalLine == n5) break;
                ++logicalLine;
            }
        }
    }
}

