/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog;

import com.intellij.application.Topics;
import com.intellij.internal.statistic.DeviceIdManager;
import com.intellij.internal.statistic.config.EventLogOptions;
import com.intellij.internal.statistic.eventLog.AnonymizedIdsCache;
import com.intellij.internal.statistic.eventLog.AtomicLazyValue;
import com.intellij.internal.statistic.eventLog.EventLogConfigOptionsListener;
import com.intellij.internal.statistic.eventLog.EventLogConfigOptionsService;
import com.intellij.internal.statistic.eventLog.EventLogConfiguration;
import com.intellij.internal.statistic.eventLog.EventLogRecorderConfigOptionsListener;
import com.intellij.internal.statistic.eventLog.MachineId;
import com.intellij.internal.statistic.eventLog.fus.MachineIdManager;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.util.MathUtil;
import com.intellij.util.messages.Topic;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\n\u0018\u0000 (2\u00020\u0001:\u0001(B!\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007J\u000e\u0010\u001c\u001a\u00020\u00032\u0006\u0010\u001d\u001a\u00020\u0003J\u0018\u0010\u001c\u001a\u00020\u00032\u0006\u0010\u001d\u001a\u00020\u00032\b\b\u0002\u0010\u001e\u001a\u00020\u001fJ\u001a\u0010 \u001a\u00020\u00032\u0006\u0010\u001d\u001a\u00020\u00032\b\b\u0002\u0010\u001e\u001a\u00020\u001fH\u0007J\b\u0010!\u001a\u00020\u000bH\u0002J\u001a\u0010\"\u001a\u00020\u00122\b\u0010#\u001a\u0004\u0018\u00010\u00032\u0006\u0010$\u001a\u00020\u000bH\u0002J\b\u0010%\u001a\u00020\u0003H\u0002J\b\u0010&\u001a\u00020\u001aH\u0002J\f\u0010'\u001a\u00020\u000b*\u00020\u0003H\u0002R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0011\u001a\u00020\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00120\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0017\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\rR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0010\u00a8\u0006)"}, d2={"Lcom/intellij/internal/statistic/eventLog/EventLogRecorderConfiguration;", "", "recorderId", "", "eventLogConfiguration", "Lcom/intellij/internal/statistic/eventLog/EventLogConfiguration;", "sessionId", "(Ljava/lang/String;Lcom/intellij/internal/statistic/eventLog/EventLogConfiguration;Ljava/lang/String;)V", "anonymizedCache", "Lcom/intellij/internal/statistic/eventLog/AnonymizedIdsCache;", "bucket", "", "getBucket", "()I", "deviceId", "getDeviceId", "()Ljava/lang/String;", "machineId", "Lcom/intellij/internal/statistic/eventLog/MachineId;", "getMachineId", "()Lcom/intellij/internal/statistic/eventLog/MachineId;", "machineIdReference", "Lcom/intellij/internal/statistic/eventLog/AtomicLazyValue;", "maxFilesToSend", "getMaxFilesToSend", "salt", "", "getSessionId", "anonymize", "data", "short", "", "anonymizeSkipCache", "computeMaxFilesToSend", "generateMachineId", "machineIdSalt", "value", "getOrGenerateDeviceId", "getOrGenerateSalt", "asBucket", "Companion", "intellij.platform.statistics"})
@SourceDebugExtension(value={"SMAP\nEventLogConfiguration.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EventLogConfiguration.kt\ncom/intellij/internal/statistic/eventLog/EventLogRecorderConfiguration\n+ 2 KtUtils.kt\ncom/intellij/util/KotlinUtils\n*L\n1#1,273:1\n22#2:274\n*S KotlinDebug\n*F\n+ 1 EventLogConfiguration.kt\ncom/intellij/internal/statistic/eventLog/EventLogRecorderConfiguration\n*L\n210#1:274\n*E\n"})
public final class EventLogRecorderConfiguration {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String recorderId;
    @NotNull
    private final EventLogConfiguration eventLogConfiguration;
    @NotNull
    private final String sessionId;
    @NotNull
    private final String deviceId;
    private final int bucket;
    @NotNull
    private final byte[] salt;
    @NotNull
    private final AnonymizedIdsCache anonymizedCache;
    @NotNull
    private final AtomicLazyValue<MachineId> machineIdReference;
    private final int maxFilesToSend;
    private static final int DEFAULT_MAX_FILES_TO_SEND = 5;

    public EventLogRecorderConfiguration(@NotNull String recorderId, @NotNull EventLogConfiguration eventLogConfiguration, @NotNull String sessionId) {
        Intrinsics.checkNotNullParameter((Object)recorderId, (String)"recorderId");
        Intrinsics.checkNotNullParameter((Object)eventLogConfiguration, (String)"eventLogConfiguration");
        Intrinsics.checkNotNullParameter((Object)sessionId, (String)"sessionId");
        this.recorderId = recorderId;
        this.eventLogConfiguration = eventLogConfiguration;
        this.sessionId = sessionId;
        this.deviceId = this.getOrGenerateDeviceId();
        this.bucket = this.asBucket(this.deviceId);
        this.salt = this.getOrGenerateSalt();
        this.anonymizedCache = new AnonymizedIdsCache();
        this.maxFilesToSend = this.computeMaxFilesToSend();
        this.machineIdReference = new AtomicLazyValue((Function0)new Function0<MachineId>(){

            @NotNull
            public final MachineId invoke() {
                EventLogOptions eventLogOptions = EventLogConfigOptionsService.getInstance().getOptions(recorderId);
                Intrinsics.checkNotNullExpressionValue((Object)eventLogOptions, (String)"getInstance().getOptions(recorderId)");
                EventLogOptions configOptions = eventLogOptions;
                return this.generateMachineId(configOptions.getMachineIdSalt(), configOptions.getMachineIdRevision());
            }
        });
        Topic<EventLogConfigOptionsListener> topic = EventLogConfigOptionsService.TOPIC;
        Intrinsics.checkNotNullExpressionValue(topic, (String)"TOPIC");
        String string = this.recorderId;
        Topics.subscribe(topic, null, (Object)new EventLogRecorderConfigOptionsListener(string){

            @Override
            public void onMachineIdConfigurationChanged(@Nullable String salt, int revision) {
                machineIdReference.updateAndGet((Function1)new Function1<MachineId, MachineId>(salt, revision, this){
                    final /* synthetic */ String $salt;
                    final /* synthetic */ int $revision;
                    final /* synthetic */ EventLogRecorderConfiguration this$0;
                    {
                        this.$salt = $salt;
                        this.$revision = $revision;
                        this.this$0 = $receiver;
                        super(1);
                    }

                    @NotNull
                    public final MachineId invoke(@NotNull MachineId prevValue) {
                        Intrinsics.checkNotNullParameter((Object)prevValue, (String)"prevValue");
                        return this.$salt != null && this.$revision != -1 && this.$revision > prevValue.getRevision() ? EventLogRecorderConfiguration.access$generateMachineId(this.this$0, this.$salt, this.$revision) : prevValue;
                    }
                });
            }
        });
    }

    public /* synthetic */ EventLogRecorderConfiguration(String string, EventLogConfiguration eventLogConfiguration, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            string2 = EventLogConfiguration.Companion.generateSessionId$intellij_platform_statistics();
        }
        this(string, eventLogConfiguration, string2);
    }

    @NotNull
    public final String getSessionId() {
        return this.sessionId;
    }

    @NotNull
    public final String getDeviceId() {
        return this.deviceId;
    }

    public final int getBucket() {
        return this.bucket;
    }

    @NotNull
    public final MachineId getMachineId() {
        return this.machineIdReference.getValue();
    }

    public final int getMaxFilesToSend() {
        return this.maxFilesToSend;
    }

    private final MachineId generateMachineId(String machineIdSalt, int value) {
        String salt;
        String string = machineIdSalt;
        if (string == null) {
            string = "";
        }
        if (Intrinsics.areEqual((Object)(salt = string), (Object)"disabled")) {
            return MachineId.DISABLED;
        }
        int revision = value >= 0 ? value : 0;
        String string2 = MachineIdManager.INSTANCE.getAnonymizedMachineId("JetBrains" + this.recorderId, salt);
        if (string2 == null) {
            return MachineId.UNKNOWN;
        }
        String machineId = string2;
        return new MachineId(machineId, revision);
    }

    @NotNull
    public final String anonymize(@NotNull String data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return this.anonymize(data, false);
    }

    @NotNull
    public final String anonymize(@NotNull String data, boolean bl) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        if (StringsKt.isBlank((CharSequence)data)) {
            return data;
        }
        return this.anonymizedCache.computeIfAbsent(data, (Function1<? super String, String>)((Function1)new Function1<String, String>(this, bl){
            final /* synthetic */ EventLogRecorderConfiguration this$0;
            final /* synthetic */ boolean $short;
            {
                this.this$0 = $receiver;
                this.$short = $short;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final String invoke(@NotNull String it) {
                String string;
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                String string2 = EventLogConfiguration.Companion.hashSha256(EventLogRecorderConfiguration.access$getSalt$p(this.this$0), it);
                boolean condition$iv = this.$short;
                boolean $i$f$applyIf = false;
                if (condition$iv) {
                    void $this$applyIf$iv;
                    void $this$invoke_u24lambda_u240 = $this$applyIf$iv;
                    boolean bl = false;
                    String string3 = $this$invoke_u24lambda_u240.substring(0, 12);
                    string = string3;
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                } else {
                    string = string2;
                }
                return string;
            }
        }));
    }

    public static /* synthetic */ String anonymize$default(EventLogRecorderConfiguration eventLogRecorderConfiguration, String string, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return eventLogRecorderConfiguration.anonymize(string, bl);
    }

    /*
     * WARNING - void declaration
     */
    @TestOnly
    @NotNull
    public final String anonymizeSkipCache(@NotNull String data, boolean bl) {
        String string;
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        if (StringsKt.isBlank((CharSequence)data)) {
            return data;
        }
        String $this$applyIf$iv = EventLogConfiguration.Companion.hashSha256(this.salt, data);
        boolean $i$f$applyIf = false;
        if (bl) {
            String $this$anonymizeSkipCache_u24lambda_u240 = $this$applyIf$iv;
            boolean bl2 = false;
            String string2 = $this$anonymizeSkipCache_u24lambda_u240.substring(0, 12);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
        } else {
            void var3_3;
            string = var3_3;
        }
        return string;
    }

    public static /* synthetic */ String anonymizeSkipCache$default(EventLogRecorderConfiguration eventLogRecorderConfiguration, String string, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return eventLogRecorderConfiguration.anonymizeSkipCache(string, bl);
    }

    private final int asBucket(String $this$asBucket) {
        return MathUtil.nonNegativeAbs((int)$this$asBucket.hashCode()) % 256;
    }

    private final String getOrGenerateDeviceId() {
        String property;
        String string;
        Application app = ApplicationManager.getApplication();
        if (app != null && app.isHeadlessEnvironment() && (string = System.getProperty(property = this.eventLogConfiguration.getHeadlessDeviceIdProperty$intellij_platform_statistics(this.recorderId))) != null) {
            String it = string;
            boolean bl = false;
            return it;
        }
        try {
            String string2 = DeviceIdManager.getOrGenerateId(new DeviceIdManager.DeviceIdToken(){}, this.recorderId);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getOrGenerateId(object :\u2026ceIdToken {}, recorderId)");
            return string2;
        }
        catch (DeviceIdManager.InvalidDeviceIdTokenException e) {
            EventLogConfiguration.Companion.getLOG$intellij_platform_statistics().warn("Failed retrieving device id for " + this.recorderId);
            return "000000000000000-0000-0000-0000-000000000000";
        }
    }

    private final byte[] getOrGenerateSalt() {
        String property;
        String string;
        Application app = ApplicationManager.getApplication();
        if (app != null && app.isHeadlessEnvironment() && (string = System.getProperty(property = this.eventLogConfiguration.getHeadlessSaltProperty$intellij_platform_statistics(this.recorderId))) != null) {
            String it = string;
            boolean bl = false;
            byte[] byArray = it.getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
            return byArray;
        }
        return EventLogConfiguration.Companion.getOrGenerateSaltFromPrefs(this.recorderId);
    }

    private final int computeMaxFilesToSend() {
        Application app = ApplicationManager.getApplication();
        if (app != null && app.isHeadlessEnvironment()) {
            Integer value;
            String property = this.eventLogConfiguration.getHeadlessMaxFilesToSendProperty$intellij_platform_statistics(this.recorderId);
            String string = System.getProperty(property);
            Integer n = value = string != null ? StringsKt.toIntOrNull((String)string) : null;
            if (value != null) {
                int n2 = -1;
                if (value == n2 || value >= 0) {
                    return value;
                }
            }
        }
        return 5;
    }

    public static final /* synthetic */ byte[] access$getSalt$p(EventLogRecorderConfiguration $this) {
        return $this.salt;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/intellij/internal/statistic/eventLog/EventLogRecorderConfiguration$Companion;", "", "()V", "DEFAULT_MAX_FILES_TO_SEND", "", "intellij.platform.statistics"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

