/*
 * Decompiled with CFR 0.152.
 */
package org.jdom;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.jdom.Content;
import org.jdom.DescendantIterator;
import org.jdom.filter2.Filter;
import org.jdom.util.IteratorIterable;
import org.jetbrains.annotations.NotNull;

final class FilterIterator<T>
implements IteratorIterable<T> {
    private final DescendantIterator iterator;
    private final Filter<T> filter;
    private T nextObject;
    private boolean canRemove = false;

    FilterIterator(DescendantIterator iterator2, Filter<T> filter2) {
        if (filter2 == null) {
            throw new NullPointerException("Cannot specify a null Filter for a FilterIterator");
        }
        this.iterator = iterator2;
        this.filter = filter2;
    }

    @Override
    @NotNull
    public Iterator<T> iterator() {
        return new FilterIterator<T>(this.iterator.iterator(), this.filter);
    }

    @Override
    public boolean hasNext() {
        this.canRemove = false;
        if (this.nextObject != null) {
            return true;
        }
        while (this.iterator.hasNext()) {
            Content obj = this.iterator.next();
            T f = this.filter.filter(obj);
            if (f == null) continue;
            this.nextObject = f;
            return true;
        }
        return false;
    }

    @Override
    public T next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        T obj = this.nextObject;
        this.nextObject = null;
        this.canRemove = true;
        return obj;
    }

    @Override
    public void remove() {
        if (!this.canRemove) {
            throw new IllegalStateException("remove() can only be called on the FilterIterator immediately after a successful call to next(). A call to remove() immediately after a call to hasNext() or remove() will also fail.");
        }
        this.canRemove = false;
        this.iterator.remove();
    }
}

