/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution;

import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import org.jetbrains.annotations.NotNull;

public enum Platform {
    WINDOWS('\\', ';', "\r\n"),
    UNIX('/', ':', "\n");

    public final char fileSeparator;
    public final char pathSeparator;
    @NotNull
    public final String lineSeparator;

    private Platform(@NotNull char fileSeparator, char pathSeparator, String lineSeparator) {
        if (lineSeparator == null) {
            Platform.$$$reportNull$$$0(0);
        }
        this.fileSeparator = fileSeparator;
        this.pathSeparator = pathSeparator;
        this.lineSeparator = lineSeparator;
    }

    @NlsSafe
    @NotNull
    public static Platform current() {
        Platform platform = SystemInfo.isWindows ? WINDOWS : UNIX;
        if (platform == null) {
            Platform.$$$reportNull$$$0(1);
        }
        return platform;
    }

    @NotNull
    public String toSystemDependentName(@NotNull String filePath) {
        if (filePath == null) {
            Platform.$$$reportNull$$$0(2);
        }
        String string2 = FileUtil.toSystemDependentName((String)filePath, (char)this.fileSeparator);
        if (string2 == null) {
            Platform.$$$reportNull$$$0(3);
        }
        return string2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lineSeparator";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/Platform";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/Platform";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "current";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "toSystemDependentName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 3: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "toSystemDependentName";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 1: 
            case 3: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

