/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.qodana.cloud.authorization;

import com.intellij.codeWithMe.ClientId;
import com.intellij.collaboration.auth.OAuthCallbackHandlerBase;
import com.intellij.collaboration.auth.services.OAuthService;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.util.Url;
import com.intellij.util.Urls;
import com.intellij.util.io.NettyKt;
import io.netty.handler.codec.http.HttpRequest;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.ide.BuiltInServerManager;
import org.jetbrains.ide.HttpRequestHandler;
import org.jetbrains.qodana.cloud.QodanaCloudUrls;
import org.jetbrains.qodana.cloud.authorization.QodanaCloudOAuthService;
import org.jetbrains.qodana.registry.QodanaRegistry;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0014J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0014J\f\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\fH\u0016\u00a8\u0006\r"}, d2={"Lorg/jetbrains/qodana/cloud/authorization/QodanaCloudOAuthCallbackHandler;", "Lcom/intellij/collaboration/auth/OAuthCallbackHandlerBase;", "()V", "handleAcceptCode", "Lcom/intellij/collaboration/auth/OAuthCallbackHandlerBase$AcceptCodeHandleResult;", "isAccepted", "", "isOriginAllowed", "Lorg/jetbrains/ide/HttpRequestHandler$OriginCheckResult;", "request", "Lio/netty/handler/codec/http/HttpRequest;", "oauthService", "Lcom/intellij/collaboration/auth/services/OAuthService;", "intellij.qodana"})
@SourceDebugExtension(value={"SMAP\nQodanaCloudOAuthCallbackHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 QodanaCloudOAuthCallbackHandler.kt\norg/jetbrains/qodana/cloud/authorization/QodanaCloudOAuthCallbackHandler\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,33:1\n43#2,3:34\n*S KotlinDebug\n*F\n+ 1 QodanaCloudOAuthCallbackHandler.kt\norg/jetbrains/qodana/cloud/authorization/QodanaCloudOAuthCallbackHandler\n*L\n14#1:34,3\n*E\n"})
public final class QodanaCloudOAuthCallbackHandler
extends OAuthCallbackHandlerBase {
    @NotNull
    public OAuthService<?> oauthService() {
        boolean $i$f$service = false;
        Class<QodanaCloudOAuthService> serviceClass$iv = QodanaCloudOAuthService.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ")");
        }
        return (OAuthService)object;
    }

    @NotNull
    protected OAuthCallbackHandlerBase.AcceptCodeHandleResult handleAcceptCode(boolean isAccepted) {
        Url websiteUrl = Urls.newFromEncoded((String)QodanaCloudUrls.INSTANCE.getWebsiteUrl());
        Url url = QodanaRegistry.INSTANCE.isQodanaLicenseAgreementCallbackEnabled() ? websiteUrl.resolve("/ideauth").addParameters(MapsKt.mapOf((Pair)TuplesKt.to((Object)"port", (Object)String.valueOf(BuiltInServerManager.Companion.getInstance().getPort())))) : websiteUrl;
        Intrinsics.checkNotNullExpressionValue((Object)url, (String)"if (QodanaRegistry.isQod\u2026 {\n      websiteUrl\n    }");
        Url redirectUrl = url;
        return (OAuthCallbackHandlerBase.AcceptCodeHandleResult)new OAuthCallbackHandlerBase.AcceptCodeHandleResult.Redirect(redirectUrl);
    }

    @NotNull
    protected HttpRequestHandler.OriginCheckResult isOriginAllowed(@NotNull HttpRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        if (Intrinsics.areEqual((Object)NettyKt.getReferrer((HttpRequest)request), (Object)QodanaCloudUrls.INSTANCE.getJbaAuthReferrer())) {
            return HttpRequestHandler.OriginCheckResult.ALLOW;
        }
        return super.isOriginAllowed(request);
    }
}

