/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.packaging.pyproject;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.packaging.PyRequirement;
import com.jetbrains.python.packaging.PyRequirementParser;
import com.jetbrains.python.packaging.management.PythonPackageManager;
import com.jetbrains.python.packaging.management.PythonPackageManagerExt;
import com.jetbrains.python.packaging.pyproject.PyInstallPackageQuickFix;
import com.jetbrains.python.packaging.pyproject.PyInstallProjectAsEditableQuickfix;
import com.jetbrains.python.sdk.PySdkExtKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.toml.lang.psi.ElementTypesKt;
import org.toml.lang.psi.TomlArray;
import org.toml.lang.psi.TomlKey;
import org.toml.lang.psi.TomlKeyValue;
import org.toml.lang.psi.TomlLiteral;
import org.toml.lang.psi.TomlVisitor;
import org.toml.lang.psi.ext.TomlKeyKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lcom/jetbrains/python/packaging/pyproject/PyprojectPackageInspection;", "Lcom/intellij/codeInspection/LocalInspectionTool;", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "intellij.python.community.impl"})
public final class PyprojectPackageInspection
extends LocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        return (PsiElementVisitor)new TomlVisitor(holder){
            final /* synthetic */ ProblemsHolder $holder;
            {
                this.$holder = $holder;
            }

            public void visitLiteral(@NotNull TomlLiteral element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                if (element.getParent() instanceof TomlArray && ElementTypesKt.getTOML_STRING_LITERALS().contains(PsiTreeUtilKt.getElementType((PsiElement)element.getFirstChild()))) {
                    PsiElement $this$parentOfType_u24default$iv = (PsiElement)element;
                    boolean withSelf$iv = false;
                    boolean $i$f$parentOfType = false;
                    TomlKeyValue tomlKeyValue = (TomlKeyValue)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType_u24default$iv, TomlKeyValue.class, (boolean)true);
                    if (Intrinsics.areEqual((Object)(tomlKeyValue != null && (tomlKeyValue = tomlKeyValue.getKey()) != null ? TomlKeyKt.getName((TomlKey)tomlKeyValue) : null), (Object)"dependencies")) {
                        String string = element.getText();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"element.text");
                        String elementText = StringsKt.removeSurrounding((String)StringsKt.removeSurrounding((String)string, (CharSequence)"'"), (CharSequence)"\"");
                        PyRequirement pyRequirement = PyRequirementParser.fromLine(elementText);
                        if (pyRequirement == null) {
                            return;
                        }
                        PyRequirement requirement = pyRequirement;
                        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)element.getOriginalElement());
                        if (module == null) {
                            return;
                        }
                        Module module2 = module;
                        Project project = element.getProject();
                        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"element.project");
                        Sdk sdk2 = PySdkExtKt.getPythonSdk(module2);
                        if (sdk2 == null) {
                            return;
                        }
                        PythonPackageManager packageManager = PythonPackageManager.Companion.forSdk(project, sdk2);
                        String string2 = requirement.getName();
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"requirement.name");
                        if (!PythonPackageManagerExt.isInstalled(packageManager, string2)) {
                            PsiElement psiElement = (PsiElement)element;
                            Object[] objectArray = new Object[]{requirement.getName()};
                            String string3 = PyBundle.message("python.pyproject.package.not.installed", objectArray);
                            objectArray = new LocalQuickFix[2];
                            String string4 = requirement.getName();
                            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"requirement.name");
                            objectArray[0] = new PyInstallPackageQuickFix(string4);
                            objectArray[1] = new PyInstallProjectAsEditableQuickfix();
                            this.$holder.registerProblem(psiElement, string3, (LocalQuickFix[])objectArray);
                        }
                    }
                }
            }
        };
    }
}

