/*
 * Decompiled with CFR 0.152.
 */
package org.editorconfig.configmanagement;

import com.intellij.application.options.CodeStyle;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.lang.Language;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.editorconfig.Utils;
import org.editorconfig.configmanagement.EditorConfigEncodingCache;
import org.editorconfig.language.messages.EditorConfigBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u0000 \u000e2\u00020\u0001:\u0003\r\u000e\u000fB\u0005\u00a2\u0006\u0002\u0010\u0002J-\u0010\u0003\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a2\u0006\u0002\u0010\f\u00a8\u0006\u0010"}, d2={"Lorg/editorconfig/configmanagement/EditorConfigEncodingInspection;", "Lcom/intellij/codeInspection/LocalInspectionTool;", "()V", "checkFile", "", "Lcom/intellij/codeInspection/ProblemDescriptor;", "file", "Lcom/intellij/psi/PsiFile;", "manager", "Lcom/intellij/codeInspection/InspectionManager;", "isOnTheFly", "", "(Lcom/intellij/psi/PsiFile;Lcom/intellij/codeInspection/InspectionManager;Z)[Lcom/intellij/codeInspection/ProblemDescriptor;", "ApplyEditorConfigEncodingQuickFix", "Companion", "IgnoreFileQuickFix", "intellij.editorconfig"})
public final class EditorConfigEncodingInspection
extends LocalInspectionTool {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Nullable
    public ProblemDescriptor[] checkFile(@NotNull PsiFile file, @NotNull InspectionManager manager, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        if (!Intrinsics.areEqual((Object)file, (Object)EditorConfigEncodingInspection.Companion.getMainPsi(file))) {
            return null;
        }
        Project project = manager.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"manager.project");
        Project project2 = project;
        VirtualFile virtualFile = file.getVirtualFile();
        if (virtualFile != null && Utils.isEnabled(CodeStyle.getSettings((Project)project2)) && virtualFile.isWritable()) {
            if (EditorConfigEncodingInspection.Companion.isHardcodedCharsetOrFailed(virtualFile)) {
                return null;
            }
            EditorConfigEncodingCache encodingCache = EditorConfigEncodingCache.Companion.getInstance();
            if (encodingCache.isIgnored(virtualFile)) {
                return null;
            }
            Project project3 = file.getProject();
            VirtualFile virtualFile2 = file.getVirtualFile();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"file.virtualFile");
            EditorConfigEncodingCache.CharsetData charsetData = encodingCache.getCharsetData(project3, virtualFile2, false);
            if (charsetData != null && !Intrinsics.areEqual((Object)virtualFile.getCharset(), (Object)charsetData.getCharset())) {
                ProblemDescriptor[] problemDescriptorArray = new ProblemDescriptor[1];
                PsiElement psiElement = (PsiElement)file;
                String string = charsetData.getCharset().displayName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"charsetData.charset.displayName()");
                LocalQuickFix[] localQuickFixArray = new LocalQuickFix[]{new ApplyEditorConfigEncodingQuickFix(), new IgnoreFileQuickFix()};
                ProblemDescriptor problemDescriptor = manager.createProblemDescriptor(psiElement, EditorConfigBundle.message("inspection.file.encoding.mismatch.descriptor", string), localQuickFixArray, ProblemHighlightType.WARNING, isOnTheFly, false);
                Intrinsics.checkNotNullExpressionValue((Object)problemDescriptor, (String)"manager.createProblemDes\u2026Fly,\n              false)");
                problemDescriptorArray[0] = problemDescriptor;
                return problemDescriptorArray;
            }
        }
        return null;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/editorconfig/configmanagement/EditorConfigEncodingInspection$ApplyEditorConfigEncodingQuickFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "()V", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "getFamilyName", "", "intellij.editorconfig"})
    private static final class ApplyEditorConfigEncodingQuickFix
    implements LocalQuickFix {
        @NotNull
        public String getFamilyName() {
            return EditorConfigBundle.message("inspection.file.encoding.apply");
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
            VirtualFile file = descriptor2.getPsiElement().getContainingFile().getVirtualFile();
            Document document = FileDocumentManager.getInstance().getCachedDocument(file);
            if (document != null) {
                EditorConfigEncodingCache editorConfigEncodingCache = EditorConfigEncodingCache.Companion.getInstance();
                Intrinsics.checkNotNullExpressionValue((Object)file, (String)"file");
                editorConfigEncodingCache.computeAndCacheEncoding(project, file);
                try {
                    LoadTextUtil.write((Project)project, (VirtualFile)file, (Object)file, (String)document.getText(), (long)document.getModificationStamp());
                }
                catch (IOException e) {
                    String string = EditorConfigBundle.message("inspection.file.encoding.save.error");
                    String string2 = e.getLocalizedMessage();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"e.localizedMessage");
                    Companion.showError(project, string, string2);
                }
            }
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0002J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J*\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u000b\u0010\u000e\u001a\u00070\u000f\u00a2\u0006\u0002\b\u00102\u000b\u0010\u0011\u001a\u00070\u000f\u00a2\u0006\u0002\b\u0010H\u0002\u00a8\u0006\u0012"}, d2={"Lorg/editorconfig/configmanagement/EditorConfigEncodingInspection$Companion;", "", "()V", "getMainPsi", "Lcom/intellij/psi/PsiFile;", "psiFile", "isHardcodedCharsetOrFailed", "", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "showError", "", "project", "Lcom/intellij/openapi/project/Project;", "title", "", "Lorg/jetbrains/annotations/Nls;", "message", "intellij.editorconfig"})
    public static final class Companion {
        private Companion() {
        }

        private final boolean isHardcodedCharsetOrFailed(VirtualFile virtualFile) {
            boolean bl;
            FileType fileType = virtualFile.getFileType();
            Intrinsics.checkNotNullExpressionValue((Object)fileType, (String)"virtualFile.fileType");
            FileType fileType2 = fileType;
            try {
                String charsetName = fileType2.getCharset(virtualFile, virtualFile.contentsToByteArray());
                bl = charsetName != null;
            }
            catch (IOException e) {
                bl = true;
            }
            return bl;
        }

        private final PsiFile getMainPsi(PsiFile psiFile) {
            Language language = psiFile.getViewProvider().getBaseLanguage();
            Intrinsics.checkNotNullExpressionValue((Object)language, (String)"psiFile.viewProvider.baseLanguage");
            Language baseLanguage = language;
            PsiFile psiFile2 = psiFile.getViewProvider().getPsi(baseLanguage);
            Intrinsics.checkNotNullExpressionValue((Object)psiFile2, (String)"psiFile.viewProvider.getPsi(baseLanguage)");
            return psiFile2;
        }

        private final void showError(Project project, String title, String message2) {
            NotificationGroup group = NotificationGroupManager.getInstance().getNotificationGroup("editorconfig");
            Notifications.Bus.notify((Notification)group.createNotification(title, message2, NotificationType.ERROR), (Project)project);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/editorconfig/configmanagement/EditorConfigEncodingInspection$IgnoreFileQuickFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "()V", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "getFamilyName", "", "intellij.editorconfig"})
    private static final class IgnoreFileQuickFix
    implements LocalQuickFix {
        @NotNull
        public String getFamilyName() {
            return EditorConfigBundle.message("inspection.file.encoding.ignore");
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
            VirtualFile file = descriptor2.getPsiElement().getContainingFile().getVirtualFile();
            EditorConfigEncodingCache editorConfigEncodingCache = EditorConfigEncodingCache.Companion.getInstance();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"file");
            editorConfigEncodingCache.setIgnored(file);
        }
    }
}

