/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.security.extension.go;

import com.goide.psi.GoFile;
import com.goide.psi.GoFunctionOrMethodDeclaration;
import com.goide.psi.GoMethodDeclaration;
import com.goide.psi.GoType;
import com.goide.psi.GoTypeReferenceExpression;
import com.goide.psi.impl.GoElementFactory;
import com.goide.psi.impl.GoPsiImplUtil;
import com.goide.util.GoUtil;
import com.goide.vgo.project.VgoDependency;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.security.extension.go.UtilsKt;
import org.jetbrains.security.model.LibraryDependency;
import org.jetbrains.security.package.Package;
import org.jetbrains.security.problems.vulnerabilities.VulnerablePath;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\n\u0010\t\u001a\u0004\u0018\u00010\nH\u0016J\u0013\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u00d6\u0003J\u001a\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001J\t\u0010\u0017\u001a\u00020\u0010H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/security/extension/go/GoLibraryDependency;", "Lorg/jetbrains/security/model/LibraryDependency;", "dep", "Lcom/goide/vgo/project/VgoDependency;", "(Lcom/goide/vgo/project/VgoDependency;)V", "getDep", "()Lcom/goide/vgo/project/VgoDependency;", "component1", "copy", "createPackage", "Lorg/jetbrains/security/package/Package;", "equals", "", "other", "", "getVulnerableElementQualifiedName", "", "project", "Lcom/intellij/openapi/project/Project;", "path", "Lorg/jetbrains/security/problems/vulnerabilities/VulnerablePath;", "hashCode", "", "toString", "intellij.packageChecker"})
public final class GoLibraryDependency
implements LibraryDependency {
    @NotNull
    private final VgoDependency dep;

    public GoLibraryDependency(@NotNull VgoDependency dep) {
        Intrinsics.checkNotNullParameter((Object)dep, (String)"dep");
        this.dep = dep;
    }

    @NotNull
    public final VgoDependency getDep() {
        return this.dep;
    }

    @Override
    @Nullable
    public String getVulnerableElementQualifiedName(@NotNull Project project, @NotNull VulnerablePath path) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        VirtualFile virtualFile = this.dep.getRoot();
        if (virtualFile == null || (virtualFile = virtualFile.findFileByRelativePath(path.getFileName())) == null) {
            return null;
        }
        VirtualFile vulnerableFile = virtualFile;
        PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(vulnerableFile);
        GoFile goFile = psiFile instanceof GoFile ? (GoFile)psiFile : null;
        if (goFile == null) {
            return null;
        }
        GoFile goFile2 = goFile;
        String string = GoUtil.getImportPath((PsiElement)((PsiElement)goFile2), (PsiElement)((PsiElement)goFile2));
        if (string == null) {
            return null;
        }
        String importPath = string;
        if (Intrinsics.areEqual((Object)path.getFunctionName(), (Object)"func")) {
            GoFunctionOrMethodDeclaration goFunctionOrMethodDeclaration = GoElementFactory.createFunctionOrMethodDeclaration((Project)project, (String)("func " + path.getFunctionParams() + "{}"), (PsiElement)((PsiElement)goFile2));
            Intrinsics.checkNotNullExpressionValue((Object)goFunctionOrMethodDeclaration, (String)"createFunctionOrMethodDe\u2026ionParams + \"{}\", goFile)");
            GoFunctionOrMethodDeclaration declaration = goFunctionOrMethodDeclaration;
            GoMethodDeclaration goMethodDeclaration = declaration instanceof GoMethodDeclaration ? (GoMethodDeclaration)declaration : null;
            if (goMethodDeclaration == null) {
                return null;
            }
            GoMethodDeclaration methodDeclaration = goMethodDeclaration;
            PsiElement psiElement = methodDeclaration.getIdentifier();
            String string2 = psiElement != null ? psiElement.getText() : null;
            if (string2 == null) {
                return null;
            }
            String methodName = string2;
            GoTypeReferenceExpression goTypeReferenceExpression = GoPsiImplUtil.findTypeReference((GoType)methodDeclaration.getReceiverType());
            String receiverTypeName = goTypeReferenceExpression != null ? goTypeReferenceExpression.getText() : null;
            return importPath + "." + receiverTypeName + "." + methodName;
        }
        return importPath + "." + path.getFunctionName();
    }

    @Override
    @Nullable
    public Package createPackage() {
        return UtilsKt.toPackage(this.dep);
    }

    @NotNull
    public final VgoDependency component1() {
        return this.dep;
    }

    @NotNull
    public final GoLibraryDependency copy(@NotNull VgoDependency dep) {
        Intrinsics.checkNotNullParameter((Object)dep, (String)"dep");
        return new GoLibraryDependency(dep);
    }

    public static /* synthetic */ GoLibraryDependency copy$default(GoLibraryDependency goLibraryDependency, VgoDependency vgoDependency, int n, Object object) {
        if ((n & 1) != 0) {
            vgoDependency = goLibraryDependency.dep;
        }
        return goLibraryDependency.copy(vgoDependency);
    }

    @NotNull
    public String toString() {
        return "GoLibraryDependency(dep=" + this.dep + ")";
    }

    public int hashCode() {
        return this.dep.hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof GoLibraryDependency)) {
            return false;
        }
        GoLibraryDependency goLibraryDependency = (GoLibraryDependency)other;
        return Intrinsics.areEqual((Object)this.dep, (Object)goLibraryDependency.dep);
    }
}

