---- RetrieveAllSchemas ----
select schema_object_id id, schema_name name, schema_owner owner, #V6: schema_is_virtual #: false #. is_virtual, schema_comment comment from sys.exa_schemas
  union all
select 0, 'SYS', null, false, null
  union all
select 0, 'EXA_STATISTICS', null, false , null

---- RetrieveVSchemaProperties ----
select property_name prop_name, property_value prop_value
from sys.exa_all_virtual_schema_properties
where schema_object_id = :schema_id

---- RetrieveVSchemaExtProperties ----
select adapter_script, last_refresh, last_refresh_by
from sys.exa_virtual_schemas
where schema_object_id = :schema_id

---- RetrieveAllObjects ----
select object_name name, object_id id, object_comment comment, object_type type
from sys.exa_all_objects
where root_id = :schema_id

---- RetrieveAllSysObjects ----
select object_name name, 0, object_comment comment, object_type type
from sys.exa_syscat
where schema_name = :schema_name

---- RetrieveUsers ----
select user_name name, user_comment comment, created is null is_system
from sys.exa_all_users

---- RetrieveRoles ----
select role_name name, role_comment comment, created is null is_system
from sys.exa_all_roles

---- RetrievePrivileges ----
select privilege
from sys.exa_session_privs p(privilege)
where privilege in ('SELECT ANY DICTIONARY')

---- RetrieveConnections ----
select connection_name name, connection_comment comment,
#[SEL_ANY_DICT]: connection_string, user_name
from sys.exa_dba_connections
#: null connection_string, null user_name
from sys.exa_all_connections
#.

---- RetrieveColumns ----
select column_table table_name , column_object_type = 'TABLE' is_table,
       column_name name, column_type type, column_ordinal_position pos,
       column_is_nullable is_nullable, column_is_distribution_key is_dist_key,
       column_default def, column_identity ident, column_comment comment
from sys.exa_all_columns
where column_schema = :schema_name
order by table_name

---- RetrieveConstraints ----
select constraint_table table_name, constraint_type = 'PRIMARY KEY' is_pk,
       constraint_name name, column_name, ordinal_position pos,
       referenced_schema ref_schema, referenced_table ref_table, referenced_column ref_column
from sys.exa_all_constraint_columns
where constraint_schema = :schema_name AND constraint_type <> 'NOT NULL'
order by table_name, constraint_name, ordinal_position

---- RetrieveScripts ----
select script_name name, script_type type, script_language lang,
      #V6: script_input_type #: null #. input_type, script_result_type result_type, script_text text
from sys.exa_all_scripts
where script_schema = :schema_name

---- RetrieveViews ----
select view_name name, view_text text
from sys.exa_all_views
where view_schema = :schema_name

---- RetrieveFunctions ----
select function_name name, function_text text
from sys.exa_all_functions
where function_schema = :schema_name

