/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.reporting;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.reporting.Base64GzipCompressor;
import com.intellij.reporting.ReporterKt;
import com.intellij.reporting.StatsSender;
import com.intellij.reporting.StatsServerInfo;
import com.intellij.util.io.HttpRequests;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\rH\u0002J\n\u0010\u000e\u001a\u0004\u0018\u00010\nH\u0002J\u0018\u0010\u000f\u001a\u00020\r2\u0006\u0010\u000b\u001a\u00020\u00062\b\b\u0002\u0010\f\u001a\u00020\rR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/reporting/StatsSender;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "infoUrl", "", "executeRequest", "", "info", "Lcom/intellij/reporting/StatsServerInfo;", "text", "compress", "", "requestServerUrl", "send", "intellij.platform.ide.impl"})
public final class StatsSender {
    private static final String infoUrl = "https://www.jetbrains.com/config/features-service-status.json";
    private static final Logger LOG;
    public static final StatsSender INSTANCE;

    private final StatsServerInfo requestServerUrl() {
        try {
            StatsServerInfo info = (StatsServerInfo)ReporterKt.access$getGson$p().fromJson(HttpRequests.request((String)infoUrl).readString(), StatsServerInfo.class);
            if (info.isServiceAlive()) {
                return info;
            }
        }
        catch (Exception e) {
            LOG.debug((Throwable)e);
        }
        return null;
    }

    public final boolean send(@NotNull String text, boolean compress) {
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        StatsServerInfo statsServerInfo = this.requestServerUrl();
        if (statsServerInfo == null) {
            return false;
        }
        StatsServerInfo info = statsServerInfo;
        try {
            this.executeRequest(info, text, compress);
            return true;
        }
        catch (Exception e) {
            LOG.debug((Throwable)e);
            return false;
        }
    }

    public static /* synthetic */ boolean send$default(StatsSender statsSender, String string, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        return statsSender.send(string, bl);
    }

    private final void executeRequest(StatsServerInfo info, String text, boolean compress) {
        if (compress) {
            byte[] data = Base64GzipCompressor.INSTANCE.compress(text);
            HttpRequests.post((String)info.urlForZipBase64Content, null).tuner((HttpRequests.ConnectionTuner)executeRequest.1.INSTANCE).write(data);
            return;
        }
        HttpRequests.post((String)info.url, (String)"text/html").write(text);
    }

    private StatsSender() {
    }

    static {
        StatsSender statsSender;
        INSTANCE = statsSender = new StatsSender();
        Logger logger = Logger.getInstance(StatsSender.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getInstance(StatsSender::class.java)");
        LOG = logger;
    }
}

