/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.reference.impl.providers;

import com.intellij.codeInsight.daemon.quickFix.FileReferenceQuickFixProvider;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleSourceOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.roots.impl.DirectoryIndex;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceHelper;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.Query;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.java.JavaModuleSourceRootTypes;

public class PsiFileReferenceHelper
extends FileReferenceHelper {
    @Override
    @NotNull
    public List<? extends LocalQuickFix> registerFixes(FileReference reference2) {
        List<? extends LocalQuickFix> list2 = FileReferenceQuickFixProvider.registerQuickFix(reference2);
        if (list2 == null) {
            PsiFileReferenceHelper.$$$reportNull$$$0(0);
        }
        return list2;
    }

    @Override
    public PsiFileSystemItem findRoot(Project project, @NotNull VirtualFile file2) {
        ProjectFileIndex index;
        VirtualFile contentRootForFile;
        if (file2 == null) {
            PsiFileReferenceHelper.$$$reportNull$$$0(1);
        }
        if ((contentRootForFile = (index = ProjectRootManager.getInstance((Project)project).getFileIndex()).getSourceRootForFile(file2)) == null) {
            contentRootForFile = index.getContentRootForFile(file2);
        }
        if (contentRootForFile != null) {
            return PsiManager.getInstance((Project)project).findDirectory(contentRootForFile);
        }
        return null;
    }

    @Override
    @NotNull
    public Collection<PsiFileSystemItem> getRoots(@NotNull Module module) {
        if (module == null) {
            PsiFileReferenceHelper.$$$reportNull$$$0(2);
        }
        Collection<PsiFileSystemItem> collection = PsiFileReferenceHelper.getContextsForModule(module, "", module.getModuleWithDependenciesScope());
        if (collection == null) {
            PsiFileReferenceHelper.$$$reportNull$$$0(3);
        }
        return collection;
    }

    @Override
    @NotNull
    public Collection<PsiFileSystemItem> getContexts(Project project, @NotNull VirtualFile file2) {
        PsiFileSystemItem parent;
        PsiFileSystemItem item;
        if (file2 == null) {
            PsiFileReferenceHelper.$$$reportNull$$$0(4);
        }
        if ((item = this.getPsiFileSystemItem(project, file2)) != null && (parent = item.getParent()) != null) {
            Module module;
            String path;
            ProjectFileIndex index = ProjectRootManager.getInstance((Project)project).getFileIndex();
            VirtualFile parentFile = parent.getVirtualFile();
            assert (parentFile != null);
            VirtualFile root = index.getSourceRootForFile(parentFile);
            if (root != null && (path = VfsUtilCore.getRelativePath((VirtualFile)parentFile, (VirtualFile)root, (char)'.')) != null && (module = ModuleUtilCore.findModuleForFile((VirtualFile)file2, (Project)project)) != null) {
                OrderEntry orderEntry = ModuleRootManager.getInstance((Module)module).getFileIndex().getOrderEntryForFile(file2);
                if (orderEntry instanceof ModuleSourceOrderEntry) {
                    block0: for (ContentEntry e : ((ModuleSourceOrderEntry)orderEntry).getRootModel().getContentEntries()) {
                        for (SourceFolder sf : e.getSourceFolders(JavaModuleSourceRootTypes.SOURCES)) {
                            String s;
                            if (!root.equals(sf.getFile()) || (s = sf.getPackagePrefix()).isEmpty()) continue;
                            path = s + "." + path;
                            continue block0;
                        }
                    }
                }
                Collection<PsiFileSystemItem> collection = PsiFileReferenceHelper.getContextsForModule(module, path, module.getModuleWithDependenciesScope());
                if (collection == null) {
                    PsiFileReferenceHelper.$$$reportNull$$$0(5);
                }
                return collection;
            }
            Set<PsiFileSystemItem> set = Collections.singleton(parent);
            if (set == null) {
                PsiFileReferenceHelper.$$$reportNull$$$0(6);
            }
            return set;
        }
        List<PsiFileSystemItem> list2 = Collections.emptyList();
        if (list2 == null) {
            PsiFileReferenceHelper.$$$reportNull$$$0(7);
        }
        return list2;
    }

    @Override
    public boolean isMine(Project project, @NotNull VirtualFile file2) {
        if (file2 == null) {
            PsiFileReferenceHelper.$$$reportNull$$$0(8);
        }
        ProjectFileIndex index = ProjectRootManager.getInstance((Project)project).getFileIndex();
        return index.isInSourceContent(file2);
    }

    @Override
    @NotNull
    public String trimUrl(@NotNull String url) {
        if (url == null) {
            PsiFileReferenceHelper.$$$reportNull$$$0(9);
        }
        String string = url.trim();
        if (string == null) {
            PsiFileReferenceHelper.$$$reportNull$$$0(10);
        }
        return string;
    }

    static Collection<PsiFileSystemItem> getContextsForModule(@NotNull Module module, @NotNull String packageName, @Nullable GlobalSearchScope scope) {
        if (module == null) {
            PsiFileReferenceHelper.$$$reportNull$$$0(11);
        }
        if (packageName == null) {
            PsiFileReferenceHelper.$$$reportNull$$$0(12);
        }
        List<PsiFileSystemItem> result2 = null;
        Query<VirtualFile> query = DirectoryIndex.getInstance(module.getProject()).getDirectoriesByPackageName(packageName, false);
        PsiManager manager = null;
        for (VirtualFile file2 : query) {
            PsiDirectory psiDirectory;
            if (scope != null && !scope.contains(file2)) continue;
            if (result2 == null) {
                result2 = new ArrayList<PsiFileSystemItem>();
                manager = PsiManager.getInstance((Project)module.getProject());
            }
            if ((psiDirectory = manager.findDirectory(file2)) == null) continue;
            result2.add((PsiFileSystemItem)psiDirectory);
        }
        return result2 != null ? result2 : Collections.emptyList();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 8: 
            case 9: 
            case 11: 
            case 12: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 8: 
            case 9: 
            case 11: 
            case 12: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/resolve/reference/impl/providers/PsiFileReferenceHelper";
                break;
            }
            case 1: 
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "registerFixes";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 8: 
            case 9: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/resolve/reference/impl/providers/PsiFileReferenceHelper";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getRoots";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getContexts";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "trimUrl";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "findRoot";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getRoots";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getContexts";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isMine";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "trimUrl";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getContextsForModule";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 8: 
            case 9: 
            case 11: 
            case 12: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

